/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class PlexusIoResourceAttributeUtils {
    static Pattern totalLinePattern = Pattern.compile("\\w*\\s\\d*");
    private static final int[] LS_LAST_DATE_PART_INDICES = new int[]{7, 7, 6};

    private PlexusIoResourceAttributeUtils() {
    }

    public static PlexusIoResourceAttributes mergeAttributes(PlexusIoResourceAttributes override, PlexusIoResourceAttributes base, PlexusIoResourceAttributes def) {
        if (override == null) {
            return base;
        }
        SimpleResourceAttributes result = base == null ? new SimpleResourceAttributes() : new SimpleResourceAttributes(base.getUserId(), base.getUserName(), base.getGroupId(), base.getGroupName(), base.getOctalMode());
        if (override.getGroupId() != -1) {
            result.setGroupId(override.getGroupId());
        }
        if (def != null && result.getGroupId() < 0) {
            result.setGroupId(def.getGroupId());
        }
        if (override.getGroupName() != null) {
            result.setGroupName(override.getGroupName());
        }
        if (def != null && result.getGroupName() == null) {
            result.setGroupName(def.getGroupName());
        }
        if (override.getUserId() != -1) {
            result.setUserId(override.getUserId());
        }
        if (def != null && result.getUserId() < 0) {
            result.setUserId(def.getUserId());
        }
        if (override.getUserName() != null) {
            result.setUserName(override.getUserName());
        }
        if (def != null && result.getUserName() == null) {
            result.setUserName(def.getUserName());
        }
        if (override.getOctalMode() > 0) {
            result.setOctalMode(override.getOctalMode());
        }
        if (def != null && result.getOctalMode() < 0) {
            result.setOctalMode(def.getOctalMode());
        }
        return result;
    }

    public static boolean isGroupExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 8);
    }

    public static boolean isGroupReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 32);
    }

    public static boolean isGroupWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 16);
    }

    public static boolean isOwnerExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 64);
    }

    public static boolean isOwnerReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 256);
    }

    public static boolean isOwnerWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 128);
    }

    public static boolean isWorldExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 1);
    }

    public static boolean isWorldReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 4);
    }

    public static boolean isWorldWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 2);
    }

    public static boolean isOctalModeEnabled(int mode, int targetMode) {
        return (mode & targetMode) != 0;
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file) throws IOException {
        Map byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, null, 0, false);
        return (PlexusIoResourceAttributes)byPath.get(file.getAbsolutePath());
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file, Logger logger) throws IOException {
        Map byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, logger, 0, false);
        return (PlexusIoResourceAttributes)byPath.get(file.getAbsolutePath());
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file, Logger logger, int logLevel) throws IOException {
        Map byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, logger, logLevel, false);
        return (PlexusIoResourceAttributes)byPath.get(file.getAbsolutePath());
    }

    public static Map getFileAttributesByPath(File dir) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, null, 0, true);
    }

    public static Map getFileAttributesByPath(File dir, Logger logger) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, logger, 0, true);
    }

    public static Map getFileAttributesByPath(File dir, Logger logger, int logLevel) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, logger, 0, true);
    }

    public static Map getFileAttributesByPath(File dir, Logger logger, int logLevel, boolean recursive) throws IOException {
        if (!PlexusIoResourceAttributeUtils.enabledOnCurrentOperatingSystem()) {
            return Collections.EMPTY_MAP;
        }
        if (logger == null) {
            logger = new ConsoleLogger(1, "Internal");
        }
        LoggerStreamConsumer loggerConsumer = new LoggerStreamConsumer(logger, logLevel);
        AttributeParser parser = new AttributeParser(loggerConsumer, logger);
        String lsOptions = "-1nla" + (recursive ? "R" : "d");
        try {
            PlexusIoResourceAttributeUtils.executeLs(dir, lsOptions, loggerConsumer, parser, logger);
        }
        catch (CommandLineException e2) {
            IOException error = new IOException("Failed to quote directory: '" + dir + "'");
            error.initCause(e2);
            throw error;
        }
        parser.initSecondPass();
        lsOptions = "-1la" + (recursive ? "R" : "d");
        try {
            PlexusIoResourceAttributeUtils.executeLs(dir, lsOptions, loggerConsumer, parser, logger);
        }
        catch (CommandLineException e3) {
            IOException error = new IOException("Failed to quote directory: '" + dir + "'");
            error.initCause(e3);
            throw error;
        }
        return parser.attributesByPath;
    }

    private static boolean enabledOnCurrentOperatingSystem() {
        return !Os.isFamily("windows") && !Os.isFamily("win9x");
    }

    private static void executeLs(File dir, String options, LoggerStreamConsumer loggerConsumer, StreamConsumer parser, Logger logger) throws IOException, CommandLineException {
        Commandline numericCli = new Commandline();
        numericCli.getShell().setQuotedArgumentsEnabled(true);
        numericCli.getShell().setQuotedExecutableEnabled(false);
        numericCli.setExecutable("ls");
        numericCli.createArg().setLine(options);
        numericCli.createArg().setValue(dir.getAbsolutePath());
        if (logger.isDebugEnabled()) {
            logger.debug("Executing:\n\n" + numericCli.toString() + "\n");
        }
        try {
            int result = CommandLineUtils.executeCommandLine(numericCli, parser, loggerConsumer);
            if (result != 0) {
                throw new IOException("Failed to retrieve numeric file attributes using: '" + numericCli.toString() + "'");
            }
        }
        catch (CommandLineException e2) {
            IOException error = new IOException("Failed to retrieve numeric file attributes using: '" + numericCli.toString() + "'");
            error.initCause(e2);
            throw error;
        }
    }

    static final class AttributeParser
    implements StreamConsumer {
        private final StreamConsumer delegate;
        private final Map attributesByPath = new LinkedHashMap();
        private final Logger logger;
        private boolean nextIsPathPrefix = false;
        private String pathPrefix = "";
        private boolean extractNames = false;
        private boolean secondPass = false;
        private final SimpleDateFormat[] LS_DATE_FORMATS;

        public AttributeParser(StreamConsumer delegate, Logger logger) {
            this.delegate = delegate;
            this.logger = logger;
            this.LS_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("MMM dd yyyy"), new SimpleDateFormat("MMM dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeLine(String line) {
            if (!totalLinePattern.matcher(line).matches()) {
                if (line.trim().length() == 0) {
                    this.nextIsPathPrefix = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Anticipating path prefix in next line");
                    }
                } else if (this.nextIsPathPrefix) {
                    if (!line.endsWith(":")) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Path prefix not found. Checking next line.");
                        }
                    } else {
                        this.nextIsPathPrefix = false;
                        this.pathPrefix = line.substring(0, line.length() - 1);
                        if (!this.pathPrefix.endsWith("/")) {
                            this.pathPrefix = this.pathPrefix + "/";
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Set path prefix to: " + this.pathPrefix);
                        }
                    }
                } else {
                    String[] parts = line.split("\\s+");
                    int lastDatePart = this.verifyParsability(line, parts, this.logger);
                    if (lastDatePart > 0) {
                        int idx = line.indexOf(parts[lastDatePart]) + parts[lastDatePart].length() + 1;
                        String path = this.pathPrefix + line.substring(idx);
                        while (path.length() > 0 && Character.isWhitespace(path.charAt(0))) {
                            path = path.substring(1);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("path: '" + path + "'");
                            this.logger.debug("mode: '" + parts[0] + "'");
                            this.logger.debug("uid: '" + parts[2]);
                            this.logger.debug("gid: '" + parts[3]);
                        }
                        Map map = this.attributesByPath;
                        synchronized (map) {
                            FileAttributes attributes;
                            if (this.secondPass) {
                                attributes = (FileAttributes)this.attributesByPath.get(path);
                            } else {
                                attributes = new FileAttributes();
                                attributes.setLsModeline(parts[0]);
                                this.attributesByPath.put(path, attributes);
                            }
                            if (attributes != null) {
                                if (this.extractNames) {
                                    attributes.setUserName(parts[2]);
                                    attributes.setGroupName(parts[3]);
                                } else {
                                    attributes.setUserId(Integer.parseInt(parts[2]));
                                    attributes.setGroupId(Integer.parseInt(parts[3]));
                                }
                            }
                        }
                    }
                }
            }
            this.delegate.consumeLine(line);
        }

        public void initSecondPass() {
            this.secondPass = true;
            this.extractNames = true;
            this.nextIsPathPrefix = false;
            this.pathPrefix = "";
        }

        public Map getAttributesByPath() {
            return this.attributesByPath;
        }

        private int verifyParsability(String line, String[] parts, Logger logger) {
            if (parts.length > 7) {
                String dateCandidate = parts[5] + " " + parts[6] + " " + parts[7];
                for (int i = 0; i < this.LS_DATE_FORMATS.length; ++i) {
                    try {
                        this.LS_DATE_FORMATS[i].parse(dateCandidate);
                        return LS_LAST_DATE_PART_INDICES[i];
                    }
                    catch (ParseException e2) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Failed to parse date: '" + dateCandidate + "' using format: " + this.LS_DATE_FORMATS[i].toPattern(), e2);
                        continue;
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Unparseable line: '" + line + "'\nReason: unrecognized date format; ambiguous start-index for path in listing.");
            }
            return -1;
        }
    }

    private static final class LoggerStreamConsumer
    implements StreamConsumer {
        private Logger logger;
        private int level;

        public LoggerStreamConsumer(Logger logger, int level) {
            this.logger = logger;
            this.level = level;
        }

        public void consumeLine(String line) {
            switch (this.level) {
                case 0: {
                    this.logger.debug(line);
                    break;
                }
                case 3: {
                    this.logger.error(line);
                    break;
                }
                case 4: {
                    this.logger.fatalError(line);
                    break;
                }
                case 2: {
                    this.logger.warn(line);
                    break;
                }
                default: {
                    this.logger.info(line);
                }
            }
        }
    }
}

