/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.codehaus.plexus.util.cli.CommandLineException;

public class Commandline
implements Cloneable {
    protected static final String OS_NAME = "os.name";
    protected static final String WINDOWS = "Windows";
    private String shell = null;
    private Vector shellArgs = new Vector();
    protected String executable = null;
    protected Vector arguments = new Vector();
    protected Vector envVars = new Vector();
    private boolean newEnvironment = false;
    private File workingDir = null;

    public Commandline(String toProcess) {
        this.setDefaultShell();
        String[] tmp = new String[]{};
        try {
            tmp = Commandline.translateCommandline(toProcess);
        }
        catch (Exception e2) {
            System.err.println("Error translating Commandline.");
        }
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArgument().setValue(tmp[i]);
            }
        }
    }

    public Commandline() {
        this.setDefaultShell();
    }

    private void setDefaultShell() {
        String os = System.getProperty(OS_NAME);
        if (os.indexOf(WINDOWS) != -1) {
            if (os.indexOf("95") != -1 || os.indexOf("98") != -1 || os.indexOf("Me") != -1) {
                this.shell = "COMMAND.COM";
                this.shellArgs.add("/C");
            } else {
                this.shell = "CMD.EXE";
                this.shellArgs.add("/X");
                this.shellArgs.add("/C");
            }
        }
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] line) {
        for (int i = 0; i < line.length; ++i) {
            this.createArgument().setValue(line[i]);
        }
    }

    public void addEnvironment(String name, String value) {
        this.envVars.add(name + "=" + value);
        this.newEnvironment = true;
    }

    public String[] getEnvironments() {
        return this.envVars.toArray(new String[this.envVars.size()]);
    }

    public String[] getCurrentEnvironment() {
        if (!this.newEnvironment) {
            return null;
        }
        return this.getEnvironments();
    }

    public String[] getCommandline() {
        String[] args = this.getArguments();
        if (this.executable == null) {
            return args;
        }
        String[] result = new String[args.length + 1];
        result[0] = this.executable;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    public String[] getShellCommandline() {
        int shellCount = 0;
        int arrayPos = 0;
        if (this.shell != null) {
            shellCount = 1;
        }
        String[] args = this.getArguments();
        String[] result = new String[(shellCount += this.shellArgs.size()) + args.length + (this.executable == null ? 0 : 1)];
        if (this.shell != null) {
            result[0] = this.shell;
            ++arrayPos;
        }
        System.arraycopy(this.shellArgs.toArray(), 0, result, arrayPos, this.shellArgs.size());
        arrayPos += this.shellArgs.size();
        if (this.executable != null) {
            result[arrayPos] = this.executable;
            ++arrayPos;
        }
        System.arraycopy(args, 0, result, arrayPos, args.length);
        return result;
    }

    public String[] getArguments() {
        Vector<String> result = new Vector<String>(this.arguments.size() * 2);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = (Argument)this.arguments.elementAt(i);
            String[] s = arg.getParts();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                result.addElement(s[j]);
            }
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String argument) throws CommandLineException {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            return '\'' + argument + '\'';
        }
        if (argument.indexOf("'") > -1 || argument.indexOf(" ") > -1) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result.append(' ');
            }
            try {
                result.append(Commandline.quoteArgument(line[i]));
                continue;
            }
            catch (Exception e2) {
                System.err.println("Error quoting argument.");
            }
        }
        return result.toString();
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                v.addElement(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
        }
        if (current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CommandLineException("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        Commandline c = new Commandline();
        c.setExecutable(this.executable);
        c.addArguments(this.getArguments());
        return c;
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public void setWorkingDirectory(String path) {
        if (path != null) {
            this.workingDir = new File(path);
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public Process execute() throws CommandLineException {
        Process process = null;
        try {
            if (this.workingDir == null) {
                process = Runtime.getRuntime().exec(this.getShellCommandline(), this.getCurrentEnvironment());
            } else {
                if (!this.workingDir.exists()) {
                    throw new CommandLineException("Working directory \"" + this.workingDir.getPath() + "\" does not exist!");
                }
                if (!this.workingDir.isDirectory()) {
                    throw new CommandLineException("Path \"" + this.workingDir.getPath() + "\" does not specify a directory.");
                }
                process = Runtime.getRuntime().exec(this.getShellCommandline(), this.getCurrentEnvironment(), this.workingDir);
            }
        }
        catch (IOException ex) {
            throw new CommandLineException("Error while executing process.", ex);
        }
        return process;
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                for (int i = 0; i < this.position; ++i) {
                    Argument arg = (Argument)Commandline.this.arguments.elementAt(i);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }

    public static class Argument {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            try {
                this.parts = Commandline.translateCommandline(line);
            }
            catch (Exception e2) {
                System.err.println("Error translating Commandline.");
            }
        }

        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

