/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.client;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.cn.client.CertificateFilter;
import org.dataone.cn.client.NodeApproval;
import org.dataone.configuration.Settings;

public class Main {
    static Logger logger;
    static FilenameFilter certificateFilter;

    public static void main(String[] args) {
        try {
            String nodeId = null;
            NodeApproval nodeApproval = new NodeApproval();
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("h", "help", false, "print options");
            OptionBuilder.withLongOpt("NodeId");
            OptionBuilder.withDescription("the id of the node to approve");
            OptionBuilder.hasArg();
            OptionBuilder.withType(String.class);
            OptionBuilder.withValueSeparator();
            OptionBuilder.withArgName("NODEID");
            options.addOption(OptionBuilder.create());
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("h") || line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("D1ApproveNode", options);
                return;
            }
            if (line.hasOption("NodeId")) {
                nodeId = line.getOptionValue("NodeId");
            }
            nodeApproval.approveNode(nodeId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        File[] certificateFiles;
        logger = Logger.getLogger(Main.class.getName());
        certificateFilter = new CertificateFilter();
        Settings.getConfiguration().addProperty("dataone.hazelcast.location.clientconfig", "classpath:org/dataone/configuration/hazelcastClientConf.xml");
        String clientCertificateDirectory = Settings.getConfiguration().getString("D1Client.certificate.directory");
        File certsDirectory = new File(clientCertificateDirectory);
        if (certsDirectory.exists() && certsDirectory.isDirectory() && (certificateFiles = certsDirectory.listFiles(certificateFilter)).length > 0) {
            String clientCertificateLocation = null;
            if (certificateFiles.length > 1) {
                Integer certInteger;
                System.console().printf("Choose the number of the Certificate to use\n", new Object[0]);
                for (int i = 0; i < certificateFiles.length; ++i) {
                    System.console().printf("%d)\t%s\n", i, certificateFiles[i].getName());
                }
                String certSelection = System.console().readLine();
                try {
                    certInteger = Integer.parseInt(certSelection);
                }
                catch (NumberFormatException e2) {
                    throw new RuntimeException(e2.getMessage());
                }
                clientCertificateLocation = certificateFiles[certInteger].getAbsolutePath();
            } else {
                clientCertificateLocation = certificateFiles[0].getAbsolutePath();
            }
            CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
        }
    }
}

