/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.ITopic;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.v2.impl.NodeRegistryServiceImpl;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;

public class NodeApproval {
    NodeRegistryServiceImpl nodeRegistryService = new NodeRegistryServiceImpl();
    private static String[] approvedResponses = new String[]{"Y", "N", "C"};
    ITopic<NodeReference> hzNodeTopic = null;
    static final String hzNodeTopicName = Settings.getConfiguration().getString("dataone.hazelcast.nodeTopic");

    public NodeApproval() throws FileNotFoundException {
        HazelcastClient hzclient = HazelcastClientFactory.getProcessingClient();
        this.hzNodeTopic = hzclient.getTopic(hzNodeTopicName);
    }

    public void approveNode(String nodeId) throws ServiceFailure, NotFound, IOException, InterruptedException, NotImplemented {
        if (nodeId == null) {
            nodeId = this.promptPendingList();
        }
        if (nodeId == null) {
            return;
        }
        NodeReference approveNodeId = new NodeReference();
        approveNodeId.setValue(nodeId);
        this.nodeRegistryService.approveNode(approveNodeId);
        System.console().printf("Node Approved in LDAP\n", new Object[0]);
        Thread.sleep(3500L);
        this.hzNodeTopic.publish(approveNodeId);
        System.console().printf("Hazelcast Node Topic published to. Approval Complete\n", new Object[0]);
        System.console().writer().flush();
        System.console().writer().close();
        System.console().reader().close();
    }

    private String promptPendingList() throws ServiceFailure, NotImplemented, NotFound {
        String approval = "N";
        String nodeId = null;
        NodeList pendingNodes = this.nodeRegistryService.listPendingNodes();
        List<Node> pendingNodeList = pendingNodes.getNodeList();
        if (!pendingNodeList.isEmpty()) {
            System.console().printf("Pending Nodes to Approve\n", new Object[0]);
            do {
                int rows = pendingNodeList.size() / 4;
                for (int i = 0; i < rows; ++i) {
                    System.console().printf("%d) %s\t%d) %s\t%d) %s\t%d) %s\n", i * 4 + 0, pendingNodeList.get(i * 4 + 0).getIdentifier().getValue(), i * 4 + 1, pendingNodeList.get(i * 4 + 1).getIdentifier().getValue(), i * 4 + 2, pendingNodeList.get(i * 4 + 2).getIdentifier().getValue(), i * 4 + 3, pendingNodeList.get(i * 4 + 3).getIdentifier().getValue());
                }
                int remainder = pendingNodeList.size() % 4;
                if (remainder > 0) {
                    Object[] consoleArgs = new String[remainder * 2];
                    StringBuilder formatStringBuilder = new StringBuilder();
                    int i = 0;
                    int j = 0;
                    while (i < remainder) {
                        formatStringBuilder.append("%s) %s\t");
                        consoleArgs[j] = new Integer(rows * 4 + i).toString();
                        consoleArgs[j + 1] = pendingNodeList.get(rows * 4 + i).getIdentifier().getValue();
                        ++i;
                        j += 2;
                    }
                    formatStringBuilder.append("\n");
                    System.console().printf(formatStringBuilder.toString(), consoleArgs);
                }
                System.console().printf("Type the number of the Node to verify and press enter (return): \n", new Object[0]);
                String nodeIdIndex = System.console().readLine();
                try {
                    int nodeListIndex = Integer.parseInt(nodeIdIndex);
                    nodeId = pendingNodeList.get(nodeListIndex).getIdentifier().getValue();
                    ArrayList<String> validApprovalResponses = new ArrayList<String>(Arrays.asList(approvedResponses));
                    do {
                        System.console().printf("Do you wish to approve %s (Y=yes,N=no,C=cancel)\n", nodeId);
                        approval = System.console().readLine();
                    } while (!validApprovalResponses.contains(approval = approval.toUpperCase()));
                    if (!approval.equalsIgnoreCase("c")) continue;
                    System.exit(0);
                }
                catch (NumberFormatException ex) {
                    System.console().printf(nodeIdIndex + " is not a valid number. Please try again.\n", new Object[0]);
                }
                catch (IndexOutOfBoundsException ex) {
                    System.console().printf(nodeIdIndex + " is out of range Please select a number from 0 to " + (pendingNodeList.size() - 1) + ". Please try again.\n", new Object[0]);
                }
            } while (approval.equals("N"));
        } else {
            System.console().printf("There are No Pending Nodes to Approve\n", new Object[0]);
        }
        return nodeId;
    }
}

