/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.hazelcast.membership;

import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.hazelcast.HazelcastConfigLocationFactory;
import org.dataone.cn.hazelcast.HazelcastInstanceFactory;
import org.dataone.cn.hazelcast.membership.ClusterPartitionMembershipListener;
import org.dataone.configuration.Settings;

public class ClusterPartitionMonitor {
    private static final String IPLIST_PROPERTY = "dataone.hazelcast.iplist";
    private static ClusterPartitionMembershipListener storageMembershipListener = null;
    private static boolean storagePartition = false;
    private static ClusterPartitionMembershipListener processingMembershipListener = null;
    private static boolean processingPartition = false;
    private static ClusterPartitionMembershipListener sessionMembershipListener = null;
    private static boolean sessionPartition = false;

    private ClusterPartitionMonitor() {
    }

    public static void startStorageMonitor() {
        storageMembershipListener = new ClusterPartitionMembershipListener(HazelcastClientFactory.getStorageClient(), HazelcastConfigLocationFactory.getStorageConfigLocation(), "storage");
        storageMembershipListener.startListener();
    }

    public static void startProcessingMonitor() {
        processingMembershipListener = new ClusterPartitionMembershipListener(HazelcastInstanceFactory.getProcessingInstance(), "processing");
        processingMembershipListener.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
        processingMembershipListener.startListener();
    }

    public static void startSessionMonitor() {
        sessionMembershipListener = new ClusterPartitionMembershipListener(HazelcastClientFactory.getSessionClient(), HazelcastConfigLocationFactory.getSessionConfigLocation(), "session");
        sessionMembershipListener.startListener();
    }

    public static void stopMonitors() {
        storageMembershipListener.stopListener();
        processingMembershipListener.stopListener();
        sessionMembershipListener.stopListener();
    }

    public static void setStoragePartition(boolean partition) {
        storagePartition = partition;
    }

    public static void setProcessingPartition(boolean partition) {
        processingPartition = partition;
    }

    public static void setSessionPartition(boolean partition) {
        sessionPartition = partition;
    }

    public static boolean getStoragePartion() {
        return storagePartition;
    }

    public static boolean getProcessingPartition() {
        return processingPartition;
    }

    public static boolean getSessionPartition() {
        return sessionPartition;
    }
}

