/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.ore;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.util.EncodingUtilities;
import org.dataone.vocabulary.CITO;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.OREParserFactory;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.TripleJena;

public class ResourceMapFactory {
    private static String D1_URI_PREFIX;
    private static final String RESOURCE_MAP_SERIALIZATION_FORMAT = "RDF/XML";
    private static Predicate DC_TERMS_IDENTIFIER;
    private static ResourceMapFactory instance;
    private static Model oreModel;
    private static Log log;

    private void init() throws URISyntaxException {
        DC_TERMS_IDENTIFIER = new Predicate();
        DC_TERMS_IDENTIFIER.setNamespace(Vocab.dcterms_Agent.ns().toString());
        DC_TERMS_IDENTIFIER.setPrefix(Vocab.dcterms_Agent.schema());
        DC_TERMS_IDENTIFIER.setName("identifier");
        DC_TERMS_IDENTIFIER.setURI(new URI(DC_TERMS_IDENTIFIER.getNamespace() + DC_TERMS_IDENTIFIER.getName()));
    }

    private ResourceMapFactory() {
        try {
            this.init();
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
        }
    }

    public static ResourceMapFactory getInstance() {
        if (instance == null) {
            instance = new ResourceMapFactory();
        }
        return instance;
    }

    public ResourceMap createResourceMap(Identifier resourceMapId, String title) throws OREException, URISyntaxException {
        if (resourceMapId == null || resourceMapId.getValue() == null || resourceMapId.getValue().isEmpty()) {
            throw new OREException("The resource map identifier can not be null or empty. Please set its value.");
        }
        if (title == null || title.isEmpty()) {
            title = "DataONE Aggregation";
        }
        Aggregation aggregation = OREFactory.createAggregation(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(resourceMapId.getValue()) + "#aggregation"));
        ResourceMap resourceMap = aggregation.createResourceMap(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(resourceMapId.getValue())));
        Agent creator = OREFactory.createAgent();
        creator.addName("DataONE Java Client Library");
        resourceMap.addCreator(creator);
        aggregation.addTitle(title);
        TripleJena resourceMapIdentifier = new TripleJena();
        resourceMapIdentifier.initialise(resourceMap);
        resourceMapIdentifier.relate(DC_TERMS_IDENTIFIER, resourceMapId.getValue());
        resourceMap.addTriple(resourceMapIdentifier);
        return resourceMap;
    }

    public ResourceMap createResourceMap(Identifier resourceMapId, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        String title = null;
        ResourceMap resourceMap = this.createResourceMap(resourceMapId, title);
        Aggregation aggregation = resourceMap.getAggregation();
        if (aggregation.getTitles().isEmpty()) {
            aggregation.addTitle("DataONE Aggregation");
        }
        for (Identifier metadataId : idMap.keySet()) {
            AggregatedResource metadataResource = aggregation.createAggregatedResource(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(metadataId.getValue())));
            TripleJena metadataIdentifier = new TripleJena();
            metadataIdentifier.initialise(metadataResource);
            metadataIdentifier.relate(DC_TERMS_IDENTIFIER, metadataId.getValue());
            resourceMap.addTriple(metadataIdentifier);
            aggregation.addAggregatedResource(metadataResource);
            List<Identifier> dataIds = idMap.get(metadataId);
            for (Identifier dataId : dataIds) {
                AggregatedResource dataResource = aggregation.createAggregatedResource(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(dataId.getValue())));
                TripleJena identifier = new TripleJena();
                identifier.initialise(dataResource);
                identifier.relate(DC_TERMS_IDENTIFIER, dataId.getValue());
                resourceMap.addTriple(identifier);
                TripleJena isDocumentedBy = new TripleJena();
                isDocumentedBy.initialise(dataResource);
                isDocumentedBy.relate(CITO.predicate("isDocumentedBy"), metadataResource);
                resourceMap.addTriple(isDocumentedBy);
                TripleJena documents = new TripleJena();
                documents.initialise(metadataResource);
                documents.relate(CITO.predicate("documents"), dataResource);
                resourceMap.addTriple(documents);
                aggregation.addAggregatedResource(dataResource);
            }
        }
        return resourceMap;
    }

    public ResourceMap createResourceMap(Identifier resourceMapId, Map<Identifier, List<Identifier>> idMap, Map<Predicate, Map<Identifier, List<Identifier>>> tripleMap) throws OREException, URISyntaxException {
        ResourceMap resourceMap = this.createResourceMap(resourceMapId, idMap);
        ArrayList<Identifier> externalIds = new ArrayList<Identifier>();
        ArrayList<Identifier> internalIds = new ArrayList<Identifier>();
        Collection<List<Identifier>> idMapValues = idMap.values();
        for (List<Identifier> list : idMapValues) {
            for (Identifier id : list) {
                internalIds.add(id);
            }
        }
        for (Map.Entry entry : tripleMap.entrySet()) {
            Predicate predicate = (Predicate)entry.getKey();
            Map tripleIdMap = (Map)entry.getValue();
            for (Map.Entry thisTripleIdMap : tripleIdMap.entrySet()) {
                Identifier subjectId = (Identifier)thisTripleIdMap.getKey();
                List objectIdList = (List)thisTripleIdMap.getValue();
                for (Identifier objectId : objectIdList) {
                    if (!internalIds.contains(objectId)) {
                        externalIds.add(objectId);
                    }
                    Triple triple = OREFactory.createTriple(new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(subjectId.getValue())), predicate, new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(objectId.getValue())));
                    resourceMap.addTriple(triple);
                }
            }
        }
        for (Identifier identifier : externalIds) {
            URI externalURI = new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment(identifier.getValue()));
            TripleJena identifier2 = new TripleJena();
            identifier2.initialise(externalURI);
            identifier2.relate(DC_TERMS_IDENTIFIER, identifier.getValue());
            resourceMap.addTriple(identifier2);
        }
        return resourceMap;
    }

    public Map<Identifier, Map<Identifier, List<Identifier>>> parseResourceMap(String resourceMapContents) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        ByteArrayInputStream is = new ByteArrayInputStream(resourceMapContents.getBytes("UTF-8"));
        return this.parseResourceMap(is);
    }

    public Map<Identifier, Map<Identifier, List<Identifier>>> parseResourceMap(InputStream is) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        HashMap idMap = new HashMap();
        OREParser parser = OREParserFactory.getInstance(RESOURCE_MAP_SERIALIZATION_FORMAT);
        ResourceMap resourceMap = parser.parse(is);
        if (resourceMap == null) {
            throw new OREException("Null resource map returned from OREParser (format: RDF/XML)");
        }
        TripleSelector idSelector = new TripleSelector(null, DC_TERMS_IDENTIFIER.getURI(), null);
        TripleSelector documentsSelector = new TripleSelector(null, CITO.predicate("documents").getURI(), null);
        TripleSelector isDocBySelector = new TripleSelector(null, CITO.predicate("isDocumentedBy").getURI(), null);
        Identifier packageId = new Identifier();
        log.debug(resourceMap.getURI());
        List<Triple> packageIdTriples = resourceMap.listTriples(idSelector);
        if (packageIdTriples.isEmpty()) {
            throw new OREException("No Identifer statement was found for the resourceMap resource ('" + resourceMap.getURI().toString() + "')");
        }
        packageId.setValue(packageIdTriples.get(0).getObjectLiteral());
        List<AggregatedResource> resources = resourceMap.getAggregation().getAggregatedResources();
        HashMap<String, Identifier> idHash = new HashMap<String, Identifier>();
        for (AggregatedResource aggregatedResource : resources) {
            List<Triple> idTriples = aggregatedResource.listTriples(idSelector);
            if (!idTriples.isEmpty()) {
                Identifier arId = new Identifier();
                arId.setValue(idTriples.get(0).getObjectLiteral());
                idHash.put(aggregatedResource.getURI().toString(), arId);
                continue;
            }
            throw new OREException("Aggregated resource '" + aggregatedResource.getURI().toString() + "' in the resource map is missing the required Identifier statement");
        }
        HashMap metadataMap = new HashMap();
        for (AggregatedResource ar : resources) {
            log.debug("Agg resource: " + ar.getURI());
            List<Triple> documentsTriples = ar.listTriples(documentsSelector);
            log.debug("--- documents count: " + documentsTriples.size());
            if (!documentsTriples.isEmpty()) {
                String metadataURI = ar.getURI().toString();
                log.debug("  ---metadataURI : " + metadataURI);
                if (!metadataMap.containsKey(metadataURI)) {
                    metadataMap.put(metadataURI, new HashSet());
                    log.debug("Creating new HashSet for: " + metadataURI + " : " + ((Set)metadataMap.get(metadataURI)).size());
                }
                for (Triple triple : documentsTriples) {
                    String documentsObject = triple.getObjectURI().toString();
                    log.debug("  ---documentsObject: " + documentsObject);
                    ((Set)metadataMap.get(metadataURI)).add(documentsObject);
                }
            }
            List<Triple> docByTriples = ar.listTriples(isDocBySelector);
            log.debug("+++ isDocBy count: " + docByTriples.size());
            if (docByTriples.isEmpty()) continue;
            String docBySubjectURI = ar.getURI().toString();
            log.debug("  +++docBySubjectURI: " + docBySubjectURI);
            for (Triple trip3 : docByTriples) {
                String metadataURI = trip3.getObjectURI().toString();
                log.debug("  +++metadataURI: " + metadataURI);
                if (!metadataMap.containsKey(metadataURI)) {
                    metadataMap.put(metadataURI, new HashSet());
                    log.debug("Creating new HashSet for: " + metadataURI + " : " + ((Set)metadataMap.get(metadataURI)).size());
                }
                ((Set)metadataMap.get(metadataURI)).add(docBySubjectURI);
            }
        }
        for (String metadata : metadataMap.keySet()) {
            Identifier metadataID = (Identifier)idHash.get(metadata);
            ArrayList<Identifier> dataIDs = new ArrayList<Identifier>();
            log.debug("~~~~~ data count: " + metadata + ": " + ((Set)metadataMap.get(metadata)).size());
            for (String string : (Set)metadataMap.get(metadata)) {
                Identifier pid = (Identifier)idHash.get(string);
                dataIDs.add(pid);
            }
            idMap.put(metadataID, dataIDs);
        }
        HashMap<Identifier, Map<Identifier, List<Identifier>>> hashMap = new HashMap<Identifier, Map<Identifier, List<Identifier>>>();
        hashMap.put(packageId, idMap);
        return hashMap;
    }

    public String serializeResourceMap(ResourceMap resourceMap) throws ORESerialiserException {
        ORESerialiser serializer = ORESerialiserFactory.getInstance(RESOURCE_MAP_SERIALIZATION_FORMAT);
        ResourceMapDocument doc = serializer.serialise(resourceMap);
        String serialisation = doc.toString();
        return serialisation;
    }

    public ResourceMap deserializeResourceMap(InputStream is) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        return this.deserializeResourceMap(is, false);
    }

    public ResourceMap deserializeResourceMap(InputStream is, boolean useReasoning) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        ResourceMap resourceMap = null;
        if (useReasoning) {
            OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_RULE_INF, this.getOREModel());
            model.read(is, null, RESOURCE_MAP_SERIALIZATION_FORMAT);
            SimpleSelector selector = new SimpleSelector(null, ORE.describes, (RDFNode)null);
            StmtIterator itr = model.listStatements(selector);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = statement.getSubject();
                resourceMap = JenaOREFactory.createResourceMap(model, new URI(resource.getURI()));
            }
        } else {
            OREParser parser = OREParserFactory.getInstance(RESOURCE_MAP_SERIALIZATION_FORMAT);
            resourceMap = parser.parse(is);
        }
        return resourceMap;
    }

    protected Model getOREModel() {
        if (oreModel == null) {
            InputStream is = this.getClass().getResourceAsStream("www.openarchives.org-ore-terms.xml");
            oreModel = ModelFactory.createDefaultModel();
            if (is != null) {
                oreModel.read(is, null, RESOURCE_MAP_SERIALIZATION_FORMAT);
            } else {
                log.warn("Cannot find cached ORE terms document. Getting from namespace URI");
                oreModel.read("http://www.openarchives.org/ore/terms/");
            }
        }
        return oreModel;
    }

    public List<String> validateResourceMap(ResourceMap resourceMap) throws OREException, UnsupportedEncodingException {
        LinkedList<String> messages = new LinkedList<String>();
        if (resourceMap == null) {
            messages.add("resource Map object was null");
            return messages;
        }
        messages.addAll(this.validateD1Resource(resourceMap, resourceMap.getURI()));
        Aggregation aggregation = resourceMap.getAggregation();
        List<AggregatedResource> resources = aggregation.getAggregatedResources();
        for (AggregatedResource entry : resources) {
            log.info("aggregatedResource: " + entry.getURI());
            messages.addAll(this.validateD1Resource(resourceMap, entry.getURI()));
        }
        if (!aggregation.getURI().toString().equals(resourceMap.getURI().toString() + "#aggregation")) {
            messages.add("the aggregation resource is not of the proper construct: '{resourceMapURI}#aggregation'.  Got: " + aggregation.getURI().toString());
        }
        return messages;
    }

    private List<String> validateD1Resource(ResourceMap resourceMap, URI subjectURI) throws UnsupportedEncodingException, OREException {
        LinkedList<String> messages = new LinkedList<String>();
        String uriIdentifier = EncodingUtilities.decodeString(StringUtils.substringAfterLast(subjectURI.getRawPath(), "/"));
        String prefix = StringUtils.substringBeforeLast(subjectURI.toString(), "/");
        if (!prefix.endsWith(".dataone.org/cn/v1/resolve")) {
            messages.add("A. uri does not use the DataONE CN_Read.resolve endpoint (https://cn(.*).dataone.org/cn/v1/resolve). Got " + prefix);
        } else if (!prefix.startsWith("https://cn")) {
            messages.add("A. uri does not use the DataONE CN_Read.resolve endpoint(https://cn(.*).dataone.org/cn/v1/resolve/{pid}). Got " + prefix);
        }
        TripleSelector idTripleSelector = new TripleSelector(subjectURI, DC_TERMS_IDENTIFIER.getURI(), null);
        List<Triple> triples = resourceMap.listAllTriples(idTripleSelector);
        if (triples.isEmpty()) {
            messages.add("B. Identifier triple is not asserted for " + subjectURI.toString());
        } else {
            String identifierValue = triples.get(0).getObjectLiteral();
            if (!uriIdentifier.equals(identifierValue)) {
                messages.add("C. Identifier object doesn't match the URI of the resource: " + subjectURI.toString() + " : " + uriIdentifier + " : " + identifierValue);
            }
        }
        return messages;
    }

    static {
        DC_TERMS_IDENTIFIER = null;
        instance = null;
        oreModel = null;
        log = LogFactory.getLog(ResourceMapFactory.class);
        String baseUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
        D1_URI_PREFIX = StringUtils.isBlank(baseUrl) ? "https://fake.test.dataone.org/cn/v1/resolve/" : baseUrl + "/v1/resolve/";
    }
}

