/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TypeMarshaller {
    static Logger logger = Logger.getLogger(TypeMarshaller.class.getName());
    protected static final Map<Class, JAXBContext> jaxbContextMap = new HashMap<Class, JAXBContext>();
    protected static final boolean USE_SCHEMA_VALIDATION = Settings.getConfiguration().getBoolean("marshalling.d1.schema.validation", true);
    protected static final Schema D1_SCHEMAS;

    protected static synchronized JAXBContext getJAXBContext(Class clazz) throws JAXBException {
        if (!jaxbContextMap.containsKey(clazz)) {
            jaxbContextMap.put(clazz, JAXBContext.newInstance(clazz));
        }
        return jaxbContextMap.get(clazz);
    }

    public static void validateAgainstSchema(Object typeObject) throws MarshallingException {
        try {
            Marshaller jaxbMarshaller = TypeMarshaller.getJAXBContext(typeObject.getClass()).createMarshaller();
            jaxbMarshaller.setSchema(D1_SCHEMAS);
            jaxbMarshaller.marshal(typeObject, new DefaultHandler());
        }
        catch (JAXBException e2) {
            throw new MarshallingException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File marshalTypeToFile(Object typeObject, String filenamePath) throws MarshallingException, FileNotFoundException, IOException {
        FileOutputStream typeOutput = null;
        File outputFile = new File(filenamePath);
        typeOutput = new FileOutputStream(outputFile);
        try {
            TypeMarshaller.marshalTypeToOutputStream(typeObject, typeOutput, null);
        }
        finally {
            if (typeOutput != null) {
                try {
                    typeOutput.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        }
        return outputFile;
    }

    public static void marshalTypeToOutputStream(Object typeObject, OutputStream os) throws MarshallingException, IOException {
        TypeMarshaller.marshalTypeToOutputStream(typeObject, os, null);
    }

    public static void marshalTypeToOutputStream(Object typeObject, OutputStream os, String styleSheet) throws MarshallingException, IOException {
        try {
            Marshaller jaxbMarshaller = TypeMarshaller.getJAXBContext(typeObject.getClass()).createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            if (styleSheet != null) {
                jaxbMarshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", String.format("<?xml-stylesheet type=\"text/xsl\" href=\"%s\" ?>", styleSheet));
            }
            if (USE_SCHEMA_VALIDATION) {
                jaxbMarshaller.setSchema(D1_SCHEMAS);
            }
            jaxbMarshaller.marshal(typeObject, os);
        }
        catch (JAXBException e2) {
            throw new MarshallingException(e2.getMessage(), e2);
        }
    }

    public static <T> T unmarshalTypeFromFile(Class<T> domainClass, File file) throws IOException, InstantiationException, IllegalAccessException, MarshallingException {
        try {
            Unmarshaller jaxbUnmarshaller = TypeMarshaller.getJAXBContext(domainClass).createUnmarshaller();
            return (T)jaxbUnmarshaller.unmarshal(file);
        }
        catch (JAXBException e2) {
            throw new MarshallingException(e2.getMessage(), e2);
        }
    }

    public static <T> T unmarshalTypeFromFile(Class<T> domainClass, String filenamePath) throws IOException, InstantiationException, IllegalAccessException, MarshallingException {
        return TypeMarshaller.unmarshalTypeFromFile(domainClass, new File(filenamePath));
    }

    public static <T> T unmarshalTypeFromStream(Class<T> domainClass, InputStream inputStream) throws IOException, InstantiationException, IllegalAccessException, MarshallingException {
        try {
            Unmarshaller jaxbUnmarshaller = TypeMarshaller.getJAXBContext(domainClass).createUnmarshaller();
            Object object = jaxbUnmarshaller.unmarshal(inputStream);
            return (T)object;
        }
        catch (JAXBException e2) {
            throw new MarshallingException(e2.getMessage(), e2);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    static {
        Source[] schemas = null;
        String[] schemaUrls = Settings.getConfiguration().getStringArray("marshalling.d1.schema.urls");
        if (schemaUrls == null || schemaUrls.length == 0) {
            schemas = new StreamSource[]{new StreamSource(TypeMarshaller.class.getResourceAsStream("dataoneTypes.xsd")), new StreamSource(TypeMarshaller.class.getResourceAsStream("dataoneTypes_v1.1.xsd")), new StreamSource(TypeMarshaller.class.getResourceAsStream("dataoneTypes_v2.0.xsd")), new StreamSource(TypeMarshaller.class.getResourceAsStream("dataoneErrors.xsd"))};
        } else {
            schemas = new StreamSource[schemaUrls.length];
            for (int i = 0; i < schemaUrls.length; ++i) {
                String url = schemaUrls[i];
                logger.debug("Adding schema location: " + url);
                try {
                    schemas[i] = new StreamSource(new URL(url).openStream());
                    continue;
                }
                catch (IOException e2) {
                    throw new Error("Failed to initialize TypeMarshaller with the (DataONE) schemas!! IOException from: " + url, e2);
                }
            }
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            D1_SCHEMAS = schemaFactory.newSchema(schemas);
        }
        catch (SAXException e3) {
            throw new Error("Failed to initialize TypeMarshaller with the DataONE schemas!!", e3);
        }
        finally {
            for (Source s : schemas) {
                IOUtils.closeQuietly(((StreamSource)s).getInputStream());
            }
        }
    }
}

