/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.path.PluralAttributePath;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberOfPredicate<E, C extends Collection<E>>
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<E> elementExpression;
    private final PluralAttributePath<C> collectionPath;

    public MemberOfPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<E> elementExpression, PluralAttributePath<C> collectionPath) {
        super(criteriaBuilder);
        this.elementExpression = elementExpression;
        this.collectionPath = collectionPath;
    }

    public MemberOfPredicate(CriteriaBuilderImpl criteriaBuilder, E element, PluralAttributePath<C> collectionPath) {
        this(criteriaBuilder, new LiteralExpression<E>(criteriaBuilder, element), collectionPath);
    }

    public PluralAttributePath<C> getCollectionPath() {
        return this.collectionPath;
    }

    public Expression<E> getElementExpression() {
        return this.elementExpression;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getCollectionPath(), registry);
        ParameterContainer.Helper.possibleParameter(this.getElementExpression(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return ((Renderable)((Object)this.elementExpression)).render(renderingContext) + (this.isNegated() ? " not" : "") + " member of " + this.getCollectionPath().render(renderingContext);
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

