/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;

class AnnotationAuditingMetadata {
    private static final ReflectionUtils.AnnotationFieldFilter CREATED_BY_FILTER = new ReflectionUtils.AnnotationFieldFilter(CreatedBy.class);
    private static final ReflectionUtils.AnnotationFieldFilter CREATED_DATE_FILTER = new ReflectionUtils.AnnotationFieldFilter(CreatedDate.class);
    private static final ReflectionUtils.AnnotationFieldFilter LAST_MODIFIED_BY_FILTER = new ReflectionUtils.AnnotationFieldFilter(LastModifiedBy.class);
    private static final ReflectionUtils.AnnotationFieldFilter LAST_MODIFIED_DATE_FILTER = new ReflectionUtils.AnnotationFieldFilter(LastModifiedDate.class);
    private static final Map<Class<?>, AnnotationAuditingMetadata> METADATA_CACHE = new ConcurrentHashMap();
    static final List<Class<?>> SUPPORTED_DATE_TYPES;
    private final Field createdByField;
    private final Field createdDateField;
    private final Field lastModifiedByField;
    private final Field lastModifiedDateField;

    private AnnotationAuditingMetadata(Class<?> type) {
        Assert.notNull(type, "Given type must not be null!");
        this.createdByField = ReflectionUtils.findField(type, CREATED_BY_FILTER);
        this.createdDateField = ReflectionUtils.findField(type, CREATED_DATE_FILTER);
        this.lastModifiedByField = ReflectionUtils.findField(type, LAST_MODIFIED_BY_FILTER);
        this.lastModifiedDateField = ReflectionUtils.findField(type, LAST_MODIFIED_DATE_FILTER);
        this.assertValidDateFieldType(this.createdDateField);
        this.assertValidDateFieldType(this.lastModifiedDateField);
    }

    private void assertValidDateFieldType(Field field) {
        if (field == null || SUPPORTED_DATE_TYPES.contains(field.getType())) {
            return;
        }
        throw new IllegalStateException(String.format("Found created/modified date field with type %s but only %s are supported!", field.getType(), SUPPORTED_DATE_TYPES));
    }

    public static AnnotationAuditingMetadata getMetadata(Class<?> type) {
        if (METADATA_CACHE.containsKey(type)) {
            return METADATA_CACHE.get(type);
        }
        AnnotationAuditingMetadata metadata = new AnnotationAuditingMetadata(type);
        METADATA_CACHE.put(type, metadata);
        return metadata;
    }

    public boolean isAuditable() {
        return this.createdByField != null || this.createdDateField != null || this.lastModifiedByField != null || this.lastModifiedDateField != null;
    }

    public Field getCreatedByField() {
        return this.createdByField;
    }

    public Field getCreatedDateField() {
        return this.createdDateField;
    }

    public Field getLastModifiedByField() {
        return this.lastModifiedByField;
    }

    public Field getLastModifiedDateField() {
        return this.lastModifiedDateField;
    }

    static {
        ArrayList<Class<Long>> types = new ArrayList<Class<Long>>(4);
        types.add(DateTime.class);
        types.add(Date.class);
        types.add(Long.class);
        types.add(Long.TYPE);
        SUPPORTED_DATE_TYPES = Collections.unmodifiableList(types);
    }
}

