/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private boolean singleSession = true;

    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        if (this.isSingleSession() && TransactionSynchronizationManager.hasResource(this.getSessionFactory()) || SessionFactoryUtils.isDeferredCloseActive(this.getSessionFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else if (this.isSingleSession()) {
            this.logger.debug("Opening single Hibernate Session in OpenSessionInViewInterceptor");
            Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
            this.applyFlushMode(session, false);
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        } else {
            SessionFactoryUtils.initDeferredClose(this.getSessionFactory());
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
            this.logger.debug("Flushing single Hibernate Session in OpenSessionInViewInterceptor");
            try {
                this.flushIfNecessary(sessionHolder.getSession(), false);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            this.logger.debug("Closing single Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        } else {
            SessionFactoryUtils.processDeferredClose(this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return String.valueOf(this.getSessionFactory().toString()) + PARTICIPATE_SUFFIX;
    }
}

