/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.propertyfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.main.OpCompiler;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.List;

public class labelSearch
implements PropertyFunction {
    List myArgs = null;
    static int hiddenVariableCount = 0;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argSubject.isList() || argObject.isList()) {
            throw new QueryBuildException("List arguments to " + predicate.getURI());
        }
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Node nodeVar = argSubject.getArg();
        String pattern = NodeUtils.stringLiteral(argObject.getArg());
        if (pattern == null) {
            ALog.warn(this, "Pattern must be a plain literal or xsd:string: " + argObject.getArg());
            return new QueryIterNullIterator(execCxt);
        }
        Var var2 = labelSearch.createNewVar();
        BasicPattern bp = new BasicPattern();
        Triple t = new Triple(nodeVar, RDFS.label.asNode(), var2);
        bp.add(t);
        OpBGP op = new OpBGP(bp);
        E_Regex regex = new E_Regex((Expr)new ExprVar(var2.getName()), pattern, "i");
        Op filter = OpFilter.filter(regex, (Op)op);
        Table table = TableFactory.create(input);
        Op op2 = OpJoin.create(OpTable.create(table), filter);
        return Algebra.exec(op2, execCxt.getDataset());
    }

    private QueryIterator buildSyntax(QueryIterator input, Node nodeVar, String pattern, ExecutionContext execCxt) {
        Var var2 = labelSearch.createNewVar();
        ElementTriplesBlock elementBGP = new ElementTriplesBlock();
        Triple t = new Triple(nodeVar, RDFS.label.asNode(), var2);
        elementBGP.addTriple(t);
        E_Regex regex = new E_Regex((Expr)new ExprVar(var2.getName()), pattern, "i");
        ElementGroup elementGroup = new ElementGroup();
        elementGroup.addElement(elementBGP);
        elementGroup.addElement(new ElementFilter(regex));
        Op op = Algebra.compile(elementGroup);
        return OpCompiler.compile(op, input, execCxt);
    }

    private static Var createNewVar() {
        String varName = "-search-" + ++hiddenVariableCount;
        return Var.alloc(varName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        ResultSet rs;
        String prologue = "PREFIX ext: <java:arq.examples.propertyfunction.>\n";
        String qs = prologue + "SELECT * { ?x ext:labelSearch 'EF' }";
        Query query2 = QueryFactory.create(qs);
        Model model = labelSearch.make();
        QueryExecution qExec = QueryExecutionFactory.create(query2, model);
        try {
            rs = qExec.execSelect();
            ResultSetFormatter.out(rs);
        }
        finally {
            qExec.close();
        }
        PropertyFunctionRegistry.get().put("http://example/f#search", labelSearch.class);
        prologue = "PREFIX ext: <http://example/f#>\n";
        qs = prologue + "SELECT * { ?x ext:search 'EF' }";
        query2 = QueryFactory.create(qs);
        qExec = QueryExecutionFactory.create(query2, model);
        try {
            rs = qExec.execSelect();
            ResultSetFormatter.out(rs);
        }
        finally {
            qExec.close();
        }
    }

    private static Model make() {
        String BASE = "http://example/";
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("", BASE);
        Resource r1 = model.createResource(BASE + "r1");
        Resource r2 = model.createResource(BASE + "r2");
        r1.addProperty(RDFS.label, "abc");
        r2.addProperty(RDFS.label, "def");
        return model;
    }
}

