/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.OntModelSpecAssembler;
import com.hp.hpl.jena.assembler.assemblers.ReasonerFactoryAssembler;
import com.hp.hpl.jena.assembler.exceptions.ReasonerClashException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelGetter;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.shared.CannotCreateException;
import java.lang.reflect.Field;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestOntModelSpecAssembler
extends AssemblerTestBase {
    public TestOntModelSpecAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return OntModelSpecAssembler.class;
    }

    public void testOntModelSpecAssemblerType() {
        this.testDemandsMinimalType(new OntModelSpecAssembler(), JA.OntModelSpec);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTestSuite(TestOntModelSpecAssembler.class);
        TestOntModelSpecAssembler.addParameterisedTests(result);
        return result;
    }

    protected static void addParameterisedTests(TestSuite result) {
        Field[] fields = OntModelSpec.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String name = f.getName();
            if (f.getType() != (class$com$hp$hpl$jena$ontology$OntModelSpec == null ? TestOntModelSpecAssembler.class$("com.hp.hpl.jena.ontology.OntModelSpec") : class$com$hp$hpl$jena$ontology$OntModelSpec)) continue;
            try {
                result.addTest(TestOntModelSpecAssembler.createTest((OntModelSpec)f.get(null), name));
                continue;
            }
            catch (Exception e2) {
                System.err.println("WARNING: failed to create test for OntModelSpec " + name);
            }
        }
    }

    protected void testBuiltinSpec(OntModelSpec ontModelSpec, String specName) {
        this.testBuiltinSpecAsRootName(ontModelSpec, specName);
        this.testBuiltinSpecAsLikeTarget(ontModelSpec, specName);
    }

    private void testBuiltinSpecAsLikeTarget(OntModelSpec ontModelSpec, String specName) {
        Resource rr = this.resourceInModel("_x rdf:type ja:OntModelSpec; _x ja:likeBuiltinSpec <OM>".replaceAll("<OM>", JA.getURI() + specName));
        TestOntModelSpecAssembler.assertEquals(ontModelSpec, new OntModelSpecAssembler().open(rr));
    }

    private void testBuiltinSpecAsRootName(OntModelSpec ontModelSpec, String specName) {
        Resource root = this.resourceInModel(JA.getURI() + specName + " rdf:type ja:OntModelSpec");
        TestOntModelSpecAssembler.assertEquals(ontModelSpec, new OntModelSpecAssembler().open(root));
    }

    protected static Test createTest(final OntModelSpec spec, final String name) {
        return new TestOntModelSpecAssembler(name){

            public void runBare() {
                this.testBuiltinSpec(spec, name);
            }
        };
    }

    public void testOntModelSpecVocabulary() {
        this.assertDomain(JA.OntModelSpec, JA.ontLanguage);
        this.assertDomain(JA.OntModelSpec, JA.documentManager);
        this.assertDomain(JA.OntModelSpec, JA.likeBuiltinSpec);
    }

    public void testCreateFreshDocumentManager() {
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:documentManager y");
        OntDocumentManager dm = new OntDocumentManager();
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestOntModelSpecAssembler.resource("y"), dm);
        OntModelSpec om = (OntModelSpec)a.open(mock, root);
        TestOntModelSpecAssembler.assertSame(dm, om.getDocumentManager());
    }

    public void testUseSpecifiedReasoner() {
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:reasonerFactory R");
        FakeReasonerFactory rf = new FakeReasonerFactory();
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestOntModelSpecAssembler.resource("R"), rf);
        OntModelSpec om = (OntModelSpec)a.open(mock, root);
        TestOntModelSpecAssembler.assertSame(rf, om.getReasonerFactory());
    }

    public void testUseSpecifiedImpliedReasoner() {
        this.testUsedSpecifiedImpliedReasoner("http://jena.hpl.hp.com/2003/OWLFBRuleReasoner");
        this.testUsedSpecifiedImpliedReasoner("http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner");
    }

    private void testUsedSpecifiedImpliedReasoner(String R) {
        ReasonerFactory rf = ReasonerFactoryAssembler.getReasonerFactoryByURL(TestOntModelSpecAssembler.resource("x"), TestOntModelSpecAssembler.resource(R));
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:reasonerURL " + R);
        AssemblerTestBase.FixedObjectAssembler mock = new AssemblerTestBase.FixedObjectAssembler("(should not be this string)");
        OntModelSpec om = (OntModelSpec)a.open(mock, root);
        TestOntModelSpecAssembler.assertSame(rf, om.getReasonerFactory());
    }

    public void testDetectsClashingImpliedAndExplicitReasoners() {
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:reasonerURL R; x ja:reasonerFactory F");
        AssemblerTestBase.FixedObjectAssembler mock = new AssemblerTestBase.FixedObjectAssembler("(should not be this string)");
        try {
            a.open(mock, root);
            TestOntModelSpecAssembler.fail("should detect reasoner clash");
        }
        catch (ReasonerClashException e2) {
            TestOntModelSpecAssembler.pass();
        }
    }

    public void testUseSpecifiedLanguage() {
        this.testSpecifiedLanguage("http://www.daml.org/2001/03/daml+oil#");
        this.testSpecifiedLanguage(ProfileRegistry.OWL_DL_LANG);
        this.testSpecifiedLanguage(ProfileRegistry.OWL_LANG);
        this.testSpecifiedLanguage(ProfileRegistry.OWL_LITE_LANG);
        this.testSpecifiedLanguage(ProfileRegistry.RDFS_LANG);
    }

    private void testSpecifiedLanguage(String lang) {
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:ontLanguage " + lang);
        OntModelSpec om = (OntModelSpec)a.open(root);
        TestOntModelSpecAssembler.assertEquals(lang, om.getLanguage());
    }

    public void testSpecifiedModelGetter() {
        OntModelSpecAssembler a = new OntModelSpecAssembler();
        ModelGetter getter = new ModelGetter(){

            public Model getModel(String URL2) {
                return null;
            }

            public Model getModel(String URL2, ModelReader loadIfAbsent) {
                throw new CannotCreateException(URL2);
            }
        };
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestOntModelSpecAssembler.resource("source"), getter);
        Resource root = this.resourceInModel("x rdf:type ja:OntModelSpec; x ja:importSource source");
        OntModelSpec om = (OntModelSpec)a.open(mock, root);
        TestOntModelSpecAssembler.assertSame(getter, om.getImportModelGetter());
    }

    private static final class FakeReasonerFactory
    implements ReasonerFactory {
        private FakeReasonerFactory() {
        }

        public Reasoner create(Resource configuration) {
            return null;
        }

        public Model getCapabilities() {
            return null;
        }

        public String getURI() {
            return null;
        }
    }
}

