/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.CardinalityQRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestSuite;

public class TestClassExpression
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$QualifiedRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$CardinalityQRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction;

    public static TestSuite suite() {
        return new TestClassExpression("TestClassExpression");
    }

    public TestClassExpression(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntClass.super-class", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addSuperClass(B);
                1.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.SUB_CLASS_OF()));
                1.assertEquals("A should have super-class B", B, A.getSuperClass());
                A.addSuperClass(C2);
                1.assertEquals("Cardinality should be 2", 2, A.getCardinality(prof.SUB_CLASS_OF()));
                this.iteratorTest(A.listSuperClasses(), new Object[]{C2, B});
                A.setSuperClass(C2);
                1.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.SUB_CLASS_OF()));
                1.assertEquals("A shuold have super-class C", C2, A.getSuperClass());
                1.assertTrue("A shuold not have super-class B", !A.hasSuperClass(B, false));
                A.removeSuperClass(B);
                1.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.SUB_CLASS_OF()));
                A.removeSuperClass(C2);
                1.assertEquals("Cardinality should be 0", 0, A.getCardinality(prof.SUB_CLASS_OF()));
            }
        }, new OntTestBase.OntTestCase("OntClass.sub-class", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addSubClass(B);
                2.assertEquals("Cardinality should be 1", 1, B.getCardinality(prof.SUB_CLASS_OF()));
                2.assertEquals("A should have sub-class B", B, A.getSubClass());
                A.addSubClass(C2);
                2.assertEquals("Cardinality should be 2", 2, B.getCardinality(prof.SUB_CLASS_OF()) + C2.getCardinality(prof.SUB_CLASS_OF()));
                this.iteratorTest(A.listSubClasses(), new Object[]{C2, B});
                A.setSubClass(C2);
                2.assertEquals("Cardinality should be 1", 1, B.getCardinality(prof.SUB_CLASS_OF()) + C2.getCardinality(prof.SUB_CLASS_OF()));
                2.assertEquals("A shuold have sub-class C", C2, A.getSubClass());
                2.assertTrue("A shuold not have sub-class B", !A.hasSubClass(B, false));
                A.removeSubClass(B);
                2.assertTrue("A should have sub-class C", A.hasSubClass(C2, false));
                A.removeSubClass(C2);
                2.assertTrue("A should not have sub-class C", !A.hasSubClass(C2, false));
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addEquivalentClass(B);
                3.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.EQUIVALENT_CLASS()));
                3.assertEquals("A have equivalentClass B", B, A.getEquivalentClass());
                A.addEquivalentClass(C2);
                3.assertEquals("Cardinality should be 2", 2, A.getCardinality(prof.EQUIVALENT_CLASS()));
                this.iteratorTest(A.listEquivalentClasses(), new Object[]{C2, B});
                A.setEquivalentClass(C2);
                3.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.EQUIVALENT_CLASS()));
                3.assertEquals("A should have equivalentClass C", C2, A.getEquivalentClass());
                3.assertTrue("A should not have equivalentClass B", !A.hasEquivalentClass(B));
                A.removeEquivalentClass(B);
                3.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.EQUIVALENT_CLASS()));
                A.removeEquivalentClass(C2);
                3.assertEquals("Cardinality should be 0", 0, A.getCardinality(prof.EQUIVALENT_CLASS()));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjointWith", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addDisjointWith(B);
                4.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.DISJOINT_WITH()));
                4.assertEquals("A have be disjoint with B", B, A.getDisjointWith());
                A.addDisjointWith(C2);
                4.assertEquals("Cardinality should be 2", 2, A.getCardinality(prof.DISJOINT_WITH()));
                this.iteratorTest(A.listDisjointWith(), new Object[]{C2, B});
                A.setDisjointWith(C2);
                4.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.DISJOINT_WITH()));
                4.assertEquals("A should be disjoint with C", C2, A.getDisjointWith());
                4.assertTrue("A should not be disjoint with B", !A.isDisjointWith(B));
                A.removeDisjointWith(B);
                4.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.DISJOINT_WITH()));
                A.removeDisjointWith(C2);
                4.assertEquals("Cardinality should be 0", 0, A.getCardinality(prof.DISJOINT_WITH()));
            }
        }, new OntTestBase.OntTestCase("EnumeratedClass.oneOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                EnumeratedClass A = m.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestClassExpression.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                A.addOneOf(a);
                5.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.ONE_OF()));
                5.assertEquals("Size should be 1", 1, A.getOneOf().size());
                5.assertTrue("A should have a as enumerated member", A.getOneOf().contains(a));
                A.addOneOf(b);
                5.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.ONE_OF()));
                5.assertEquals("Size should be 2", 2, A.getOneOf().size());
                this.iteratorTest(A.listOneOf(), new Object[]{a, b});
                A.setOneOf(m.createList(new RDFNode[]{b}));
                5.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.ONE_OF()));
                5.assertEquals("Size should be 1", 1, A.getOneOf().size());
                5.assertTrue("A should have b in the enum", A.hasOneOf(b));
                5.assertTrue("A should not have a in the enum", !A.hasOneOf(a));
                A.removeOneOf(a);
                5.assertTrue("Should have b as an enum value", A.hasOneOf(b));
                A.removeOneOf(b);
                5.assertTrue("Should not have b as an enum value", !A.hasOneOf(b));
            }
        }, new OntTestBase.OntTestCase("IntersectionClass.intersectionOf", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                IntersectionClass A = m.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addOperand(B);
                6.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals("Size should be 1", 1, A.getOperands().size());
                6.assertTrue("A should have a as intersection member", A.getOperands().contains(B));
                A.addOperand(C2);
                6.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals("Size should be 2", 2, A.getOperands().size());
                this.iteratorTest(A.listOperands(), new Object[]{B, C2});
                ExtendedIterator i = A.listOperands();
                6.assertTrue("Argument should be an OntClass", i.next() instanceof OntClass);
                i.close();
                A.setOperands(m.createList(new RDFNode[]{C2}));
                6.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.INTERSECTION_OF()));
                6.assertEquals("Size should be 1", 1, A.getOperands().size());
                6.assertTrue("A should have C in the intersection", A.hasOperand(C2));
                6.assertTrue("A should not have B in the intersection", !A.hasOperand(B));
                A.removeOperand(B);
                6.assertTrue("Should have C as an operand", A.hasOperand(C2));
                A.removeOperand(C2);
                6.assertTrue("Should not have C as an operand", !A.hasOperand(C2));
            }
        }, new OntTestBase.OntTestCase("UnionClass.unionOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                UnionClass A = m.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.addOperand(B);
                7.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.UNION_OF()));
                7.assertEquals("Size should be 1", 1, A.getOperands().size());
                7.assertTrue("A should have a as union member", A.getOperands().contains(B));
                A.addOperand(C2);
                7.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.UNION_OF()));
                7.assertEquals("Size should be 2", 2, A.getOperands().size());
                this.iteratorTest(A.listOperands(), new Object[]{B, C2});
                ExtendedIterator i = A.listOperands();
                7.assertTrue("Argument should be an OntClass", i.next() instanceof OntClass);
                i.close();
                A.setOperands(m.createList(new RDFNode[]{C2}));
                7.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.UNION_OF()));
                7.assertEquals("Size should be 1", 1, A.getOperands().size());
                7.assertTrue("A should have C in the union", A.hasOperand(C2));
                7.assertTrue("A should not have B in the union", !A.hasOperand(B));
                A.removeOperand(B);
                7.assertTrue("Should have C as an operand", A.hasOperand(C2));
                A.removeOperand(C2);
                7.assertTrue("Should not have C as an operand", !A.hasOperand(C2));
            }
        }, new OntTestBase.OntTestCase("ComplementClass.complementOf", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ComplementClass A = m.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", null);
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                boolean ex = false;
                try {
                    A.addOperand(B);
                }
                catch (UnsupportedOperationException e2) {
                    ex = true;
                }
                8.assertTrue("Should fail to add to a complement", ex);
                ex = false;
                try {
                    A.addOperands(NullIterator.instance);
                }
                catch (UnsupportedOperationException e3) {
                    ex = true;
                }
                8.assertTrue("Should fail to add to a complement", ex);
                ex = false;
                try {
                    A.setOperands(m.createList(new RDFNode[]{C2}));
                }
                catch (UnsupportedOperationException e4) {
                    ex = true;
                }
                8.assertTrue("Should fail to set a list to a complement", ex);
                A.setOperand(B);
                8.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.COMPLEMENT_OF()));
                8.assertEquals("Complement should be B", B, A.getOperand());
                this.iteratorTest(A.listOperands(), new Object[]{B});
                A.setOperand(C2);
                8.assertEquals("Cardinality should be 1", 1, A.getCardinality(prof.COMPLEMENT_OF()));
                8.assertTrue("A should have C in the complement", A.hasOperand(C2));
                8.assertTrue("A should not have B in the complement", !A.hasOperand(B));
                A.removeOperand(B);
                8.assertTrue("Should have C as an operand", A.hasOperand(C2));
                A.removeOperand(C2);
                8.assertTrue("Should not have C as an operand", !A.hasOperand(C2));
            }
        }, new OntTestBase.OntTestCase("Restriction.onProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, B);
                9.assertEquals("Restriction should be on property p", p, A.getOnProperty());
                9.assertTrue("Restriction should be on property p", A.onProperty(p));
                9.assertTrue("Restriction should not be on property q", !A.onProperty(q));
                9.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ON_PROPERTY()));
                A.setOnProperty(q);
                9.assertEquals("Restriction should be on property q", q, A.getOnProperty());
                9.assertTrue("Restriction should not be on property p", !A.onProperty(p));
                9.assertTrue("Restriction should not on property q", A.onProperty(q));
                9.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ON_PROPERTY()));
                A.removeOnProperty(p);
                9.assertTrue("Should have q as on property", A.onProperty(q));
                A.removeOnProperty(q);
                9.assertTrue("Should not have q as on property", !A.onProperty(q));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, B);
                10.assertEquals("Restriction should be all values from B", B, A.getAllValuesFrom());
                10.assertTrue("Restriction should be all values from B", A.hasAllValuesFrom(B));
                10.assertTrue("Restriction should not be all values from C", !A.hasAllValuesFrom(C2));
                10.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
                A.setAllValuesFrom(C2);
                10.assertEquals("Restriction should be all values from C", C2, A.getAllValuesFrom());
                10.assertTrue("Restriction should not be all values from B", !A.hasAllValuesFrom(B));
                10.assertTrue("Restriction should be all values from C", A.hasAllValuesFrom(C2));
                10.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom(C2);
                10.assertTrue("Restriction should not be some values from C", !A.hasAllValuesFrom(C2));
                10.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, XSD.gDay);
                11.assertEquals("Restriction should be all values from gDay", XSD.gDay, A.getAllValuesFrom());
                11.assertTrue("Restriction should be all values from gDay", A.hasAllValuesFrom(XSD.gDay));
                11.assertTrue("Restriction should not be all values from decimal", !A.hasAllValuesFrom(XSD.decimal));
                11.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
                A.setAllValuesFrom(XSD.gMonth);
                11.assertEquals("Restriction should be all values from gMonth", XSD.gMonth, A.getAllValuesFrom());
                11.assertTrue("Restriction should not be all values from gDay", !A.hasAllValuesFrom(XSD.gDay));
                11.assertTrue("Restriction should be all values from gMonth", A.hasAllValuesFrom(XSD.gMonth));
                11.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom(XSD.gMonth);
                11.assertTrue("Restriction should not be some values from gMonth", !A.hasAllValuesFrom(XSD.gMonth));
                11.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, RDFS.Literal);
                12.assertEquals("Restriction should be all values from literal", RDFS.Literal, A.getAllValuesFrom());
                12.assertTrue("Restriction should be all values from literal", A.hasAllValuesFrom(RDFS.Literal));
                12.assertTrue("Restriction should not be all values from decimal", !A.hasAllValuesFrom(XSD.decimal));
                12.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("AllValuesFromRestriction.allValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Literal x = m.createTypedLiteral(1);
                Literal y = m.createTypedLiteral(2);
                DataRange dr = m.createDataRange(m.createList(new RDFNode[]{x, y}));
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction A = m.createAllValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, dr);
                13.assertEquals("Restriction should be all values from dr", dr, A.getAllValuesFrom());
                13.assertTrue("value should be a datarange", A.getAllValuesFrom() instanceof DataRange);
                13.assertTrue("Restriction should be all values from dr", A.hasAllValuesFrom(dr));
                13.assertTrue("Restriction should not be all values from decimal", !A.hasAllValuesFrom(XSD.decimal));
                13.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.ALL_VALUES_FROM()));
                A.removeAllValuesFrom(dr);
                13.assertTrue("Restriction should not be some values from gMonth", !A.hasAllValuesFrom(dr));
                13.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.ALL_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("HasValueRestriction.hasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual b = m.createIndividual(B);
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                Individual c = m.createIndividual(C2);
                HasValueRestriction A = m.createHasValueRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, b);
                14.assertEquals("Restriction should be has value b", b, A.getHasValue());
                14.assertTrue("Restriction should be to have value b", A.hasValue(b));
                14.assertTrue("Restriction should not be have value c", !A.hasValue(c));
                14.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.HAS_VALUE()));
                A.setHasValue(c);
                14.assertEquals("Restriction should be has value c", c, A.getHasValue());
                14.assertTrue("Restriction should not be to have value b", !A.hasValue(b));
                14.assertTrue("Restriction should not be have value c", A.hasValue(c));
                14.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.HAS_VALUE()));
                A.removeHasValue(c);
                14.assertTrue("Restriction should not be to have value b", !A.hasValue(b));
                14.assertTrue("Restriction should not be have value c", !A.hasValue(c));
                14.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.HAS_VALUE()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.someValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, B);
                15.assertEquals("Restriction should be some values from B", B, A.getSomeValuesFrom());
                15.assertTrue("Restriction should be some values from B", A.hasSomeValuesFrom(B));
                15.assertTrue("Restriction should not be some values from C", !A.hasSomeValuesFrom(C2));
                15.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
                A.setSomeValuesFrom(C2);
                15.assertEquals("Restriction should be some values from C", C2, A.getSomeValuesFrom());
                15.assertTrue("Restriction should not be some values from B", !A.hasSomeValuesFrom(B));
                15.assertTrue("Restriction should be some values from C", A.hasSomeValuesFrom(C2));
                15.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom(C2);
                15.assertTrue("Restriction should not be some values from C", !A.hasSomeValuesFrom(C2));
                15.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datatype", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, XSD.gDay);
                16.assertEquals("Restriction should be some values from gDay", XSD.gDay, A.getSomeValuesFrom());
                16.assertTrue("Restriction should be some values from gDay", A.hasSomeValuesFrom(XSD.gDay));
                16.assertTrue("Restriction should not be some values from decimal", !A.hasSomeValuesFrom(XSD.decimal));
                16.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
                A.setSomeValuesFrom(XSD.gMonth);
                16.assertEquals("Restriction should be some values from gMonth", XSD.gMonth, A.getSomeValuesFrom());
                16.assertTrue("Restriction should not be some values from gDay", !A.hasSomeValuesFrom(XSD.gDay));
                16.assertTrue("Restriction should be some values from gMonth", A.hasSomeValuesFrom(XSD.gMonth));
                16.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom(XSD.gMonth);
                16.assertTrue("Restriction should not be some values from gMonth", !A.hasSomeValuesFrom(XSD.gMonth));
                16.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.literal", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, RDFS.Literal);
                17.assertEquals("Restriction should be some values from literal", RDFS.Literal, A.getSomeValuesFrom());
                17.assertTrue("Restriction should be some values from literal", A.hasSomeValuesFrom(RDFS.Literal));
                17.assertTrue("Restriction should not be some values from decimal", !A.hasSomeValuesFrom(XSD.decimal));
                17.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("SomeValuesFromRestriction.SomeValuesFrom.datarange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Literal x = m.createTypedLiteral(1);
                Literal y = m.createTypedLiteral(2);
                DataRange dr = m.createDataRange(m.createList(new RDFNode[]{x, y}));
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction A = m.createSomeValuesFromRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, dr);
                18.assertEquals("Restriction should be some values from dr", dr, A.getSomeValuesFrom());
                18.assertTrue("value should be a datarange", A.getSomeValuesFrom() instanceof DataRange);
                18.assertTrue("Restriction should be some values from dr", A.hasSomeValuesFrom(dr));
                18.assertTrue("Restriction should not be some values from decimal", !A.hasSomeValuesFrom(XSD.decimal));
                18.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.SOME_VALUES_FROM()));
                A.removeSomeValuesFrom(dr);
                18.assertTrue("Restriction should not be some values from gMonth", !A.hasSomeValuesFrom(dr));
                18.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.SOME_VALUES_FROM()));
            }
        }, new OntTestBase.OntTestCase("CardinalityRestriction.cardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction A = m.createCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3);
                19.assertEquals("Restriction should be cardinality 3", 3, A.getCardinality());
                19.assertTrue("Restriction should be cardinality 3", A.hasCardinality(3));
                19.assertTrue("Restriction should not be cardinality 2", !A.hasCardinality(2));
                19.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.CARDINALITY()));
                A.setCardinality(2);
                19.assertEquals("Restriction should be cardinality 2", 2, A.getCardinality());
                19.assertTrue("Restriction should not be cardinality 3", !A.hasCardinality(3));
                19.assertTrue("Restriction should be cardinality 2", A.hasCardinality(2));
                19.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.CARDINALITY()));
                A.removeCardinality(2);
                19.assertTrue("Restriction should not be cardinality 3", !A.hasCardinality(3));
                19.assertTrue("Restriction should not be cardinality 2", !A.hasCardinality(2));
                19.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityRestriction.minCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction A = m.createMinCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3);
                20.assertEquals("Restriction should be min cardinality 3", 3, A.getMinCardinality());
                20.assertTrue("Restriction should be min cardinality 3", A.hasMinCardinality(3));
                20.assertTrue("Restriction should not be min cardinality 2", !A.hasMinCardinality(2));
                20.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.MIN_CARDINALITY()));
                A.setMinCardinality(2);
                20.assertEquals("Restriction should be min cardinality 2", 2, A.getMinCardinality());
                20.assertTrue("Restriction should not be min cardinality 3", !A.hasMinCardinality(3));
                20.assertTrue("Restriction should be min cardinality 2", A.hasMinCardinality(2));
                20.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.MIN_CARDINALITY()));
                A.removeMinCardinality(2);
                20.assertTrue("Restriction should not be cardinality 3", !A.hasMinCardinality(3));
                20.assertTrue("Restriction should not be cardinality 2", !A.hasMinCardinality(2));
                20.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.MIN_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityRestriction.maxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction A = m.createMaxCardinalityRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3);
                21.assertEquals("Restriction should be max cardinality 3", 3, A.getMaxCardinality());
                21.assertTrue("Restriction should be max cardinality 3", A.hasMaxCardinality(3));
                21.assertTrue("Restriction should not be max cardinality 2", !A.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.MAX_CARDINALITY()));
                A.setMaxCardinality(2);
                21.assertEquals("Restriction should be max cardinality 2", 2, A.getMaxCardinality());
                21.assertTrue("Restriction should not be max cardinality 3", !A.hasMaxCardinality(3));
                21.assertTrue("Restriction should be max cardinality 2", A.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 1 ", 1, A.getCardinality(prof.MAX_CARDINALITY()));
                A.removeMaxCardinality(2);
                21.assertTrue("Restriction should not be cardinality 3", !A.hasMaxCardinality(3));
                21.assertTrue("Restriction should not be cardinality 2", !A.hasMaxCardinality(2));
                21.assertEquals("cardinality should be 0 ", 0, A.getCardinality(prof.MAX_CARDINALITY()));
            }
        }, new OntTestBase.OntTestCase("QualifiedRestriction.hasClassQ", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntClass d = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
                String nameA = "ABCBA";
                MaxCardinalityQRestriction A = m.createMaxCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#" + nameA, p, 3, c);
                22.assertEquals("Restriction should hasClassQ c", c, A.getHasClassQ());
                22.assertTrue("Restriction should be hasClassQ c", A.hasHasClassQ(c));
                22.assertFalse("Restriction should not be hasClassQ d", A.hasHasClassQ(d));
                A.setHasClassQ(d);
                22.assertEquals("Restriction should hasClassQ d", d, A.getHasClassQ());
                22.assertTrue("Restriction should be hasClassQ d", A.hasHasClassQ(d));
                22.assertFalse("Restriction should not be hasClassQ c", A.hasHasClassQ(c));
                22.assertTrue("Should be a qualified restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#" + nameA).canAs(class$com$hp$hpl$jena$ontology$QualifiedRestriction == null ? (class$com$hp$hpl$jena$ontology$QualifiedRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.QualifiedRestriction")) : class$com$hp$hpl$jena$ontology$QualifiedRestriction));
                A.removeHasClassQ(d);
                22.assertFalse("Should not be a qualified restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#" + nameA).canAs(class$com$hp$hpl$jena$ontology$QualifiedRestriction == null ? (class$com$hp$hpl$jena$ontology$QualifiedRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.QualifiedRestriction")) : class$com$hp$hpl$jena$ontology$QualifiedRestriction));
            }
        }, new OntTestBase.OntTestCase("CardinalityQRestriction.cardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                CardinalityQRestriction A = m.createCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3, c);
                23.assertEquals("Restriction should cardinality 3", 3, A.getCardinalityQ());
                23.assertTrue("Restriction should be cardinality 3", A.hasCardinalityQ(3));
                23.assertFalse("Restriction should not be cardinality 1", A.hasCardinalityQ(1));
                A.setCardinalityQ(1);
                23.assertEquals("Restriction should cardinality 1", 1, A.getCardinalityQ());
                23.assertFalse("Restriction should not be cardinality 3", A.hasCardinalityQ(3));
                23.assertTrue("Restriction should be cardinality 1", A.hasCardinalityQ(1));
                23.assertTrue("Should be a qualified cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$CardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.CardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityQRestriction));
                A.removeCardinalityQ(1);
                23.assertFalse("Should not be a qualified cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$CardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$CardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.CardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$CardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("MinCardinalityQRestriction.minCardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                MinCardinalityQRestriction A = m.createMinCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3, c);
                24.assertEquals("Restriction should min cardinality 3", 3, A.getMinCardinalityQ());
                24.assertTrue("Restriction should be min cardinality 3", A.hasMinCardinalityQ(3));
                24.assertFalse("Restriction should not be min cardinality 1", A.hasMinCardinalityQ(1));
                A.setMinCardinalityQ(1);
                24.assertEquals("Restriction should min cardinality 1", 1, A.getMinCardinalityQ());
                24.assertFalse("Restriction should not be min cardinality 3", A.hasMinCardinalityQ(3));
                24.assertTrue("Restriction should be min cardinality 1", A.hasMinCardinalityQ(1));
                24.assertTrue("Should be a qualified min cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MinCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction));
                A.removeMinCardinalityQ(1);
                24.assertFalse("Should not be a qualified min cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MinCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MinCardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("MaxCardinalityQRestriction.maxCardinality", false, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                MaxCardinalityQRestriction A = m.createMaxCardinalityQRestriction("http://jena.hpl.hp.com/testing/ontology#A", p, 3, c);
                25.assertEquals("Restriction should max cardinality 3", 3, A.getMaxCardinalityQ());
                25.assertTrue("Restriction should be max cardinality 3", A.hasMaxCardinalityQ(3));
                25.assertFalse("Restriction should not be max cardinality 1", A.hasMaxCardinalityQ(1));
                A.setMaxCardinalityQ(1);
                25.assertEquals("Restriction should max cardinality 1", 1, A.getMaxCardinalityQ());
                25.assertFalse("Restriction should not be max cardinality 3", A.hasMaxCardinalityQ(3));
                25.assertTrue("Restriction should be max cardinality 1", A.hasMaxCardinalityQ(1));
                25.assertTrue("Should be a qualified max cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MaxCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction));
                A.removeMaxCardinalityQ(1);
                25.assertFalse("Should not be a qualified max cardinality restriction", m.getResource("http://jena.hpl.hp.com/testing/ontology#A").canAs(class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction == null ? (class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction = TestClassExpression.class$("com.hp.hpl.jena.ontology.MaxCardinalityQRestriction")) : class$com$hp$hpl$jena$ontology$MaxCardinalityQRestriction));
            }
        }, new OntTestBase.OntTestCase("OntClass.subclass.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassB");
                this.iteratorTest(A.listSuperClasses(), new Object[]{B});
                this.iteratorTest(B.listSubClasses(), new Object[]{A});
            }
        }, new OntTestBase.OntTestCase("OntClass.equivalentClass.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassC");
                27.assertTrue("A should be equiv to C", A.hasEquivalentClass(C2));
            }
        }, new OntTestBase.OntTestCase("OntClass.disjoint.fromFile", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/ClassExpression/test.rdf";
                m.read(fileName);
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassA");
                OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#ClassD");
                28.assertTrue("A should be disjoint with D", A.isDisjointWith(D));
            }
        }, new OntTestBase.OntTestCase("OntClass.isEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", b);
                Individual y = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", b);
                EnumeratedClass a = m.createEnumeratedClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{x, y}));
                29.assertTrue("enumerated class test not correct", a.isEnumeratedClass());
                29.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                29.assertTrue("union class test not correct", !a.isUnionClass());
                29.assertTrue("complement class test not correct", !a.isComplementClass());
                29.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isIntersectionClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                IntersectionClass a = m.createIntersectionClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{b, c}));
                30.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                30.assertTrue("intersection class test not correct", a.isIntersectionClass());
                30.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                30.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                30.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isUnionClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                UnionClass a = m.createUnionClass("http://jena.hpl.hp.com/testing/ontology#A", m.createList(new RDFNode[]{b, c}));
                31.assertTrue("enumerated class test not correct", !a.isEnumeratedClass());
                31.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                31.assertTrue("union class test not correct", a.isUnionClass());
                31.assertTrue("complement class test not correct", !a.isComplementClass());
                31.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isComplementClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ComplementClass a = m.createComplementClass("http://jena.hpl.hp.com/testing/ontology#A", b);
                32.assertTrue("enumerated class test not correct", !a.isEnumeratedClass());
                32.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                32.assertTrue("union class test not correct", !a.isUnionClass());
                32.assertTrue("complement class test not correct", a.isComplementClass());
                32.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.isRestriction", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Restriction a = m.createRestriction(null);
                33.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                33.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                33.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                33.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                33.assertTrue("restriction test not correct", a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toEnumeratedClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                34.assertTrue("enumerated class test not correct", !a.isEnumeratedClass());
                34.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                34.assertTrue("union class test not correct", !a.isUnionClass());
                34.assertTrue("complement class test not correct", !a.isComplementClass());
                34.assertTrue("restriction test not correct", !a.isRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#x", b);
                Individual y = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#y", b);
                a = a.convertToEnumeratedClass(m.createList(new RDFNode[]{x, y}));
                34.assertTrue("enumerated class test not correct", a.isEnumeratedClass());
                34.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                34.assertTrue("union class test not correct", !a.isUnionClass());
                34.assertTrue("complement class test not correct", !a.isComplementClass());
                34.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toIntersectionClass", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                35.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                35.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                35.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                35.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                35.assertTrue("restriction test not correct", !a.isRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a = a.convertToIntersectionClass(m.createList(new RDFNode[]{b, c}));
                35.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                35.assertTrue("intersection class test not correct", a.isIntersectionClass());
                35.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                35.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                35.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toUnionClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                36.assertTrue("enumerated class test not correct", !a.isEnumeratedClass());
                36.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                36.assertTrue("union class test not correct", !a.isUnionClass());
                36.assertTrue("complement class test not correct", !a.isComplementClass());
                36.assertTrue("restriction test not correct", !a.isRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a = a.convertToUnionClass(m.createList(new RDFNode[]{b, c}));
                36.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                36.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                36.assertTrue("union class test not correct", this.m_owlLiteLang || a.isUnionClass());
                36.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                36.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toComplementClass", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                37.assertTrue("enumerated class test not correct", !a.isEnumeratedClass());
                37.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                37.assertTrue("union class test not correct", !a.isUnionClass());
                37.assertTrue("complement class test not correct", !a.isComplementClass());
                37.assertTrue("restriction test not correct", !a.isRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToComplementClass(b);
                37.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                37.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                37.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                37.assertTrue("complement class test not correct", this.m_owlLiteLang || a.isComplementClass());
                37.assertTrue("restriction test not correct", !a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.toRestriction", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass a = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                38.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                38.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                38.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                38.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                38.assertTrue("restriction test not correct", !a.isRestriction());
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                a = a.convertToRestriction(p);
                38.assertTrue("enumerated class test not correct", this.m_owlLiteLang || !a.isEnumeratedClass());
                38.assertTrue("intersection class test not correct", !a.isIntersectionClass());
                38.assertTrue("union class test not correct", this.m_owlLiteLang || !a.isUnionClass());
                38.assertTrue("complement class test not correct", this.m_owlLiteLang || !a.isComplementClass());
                38.assertTrue("restriction test not correct", a.isRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                AllValuesFromRestriction a = m.createAllValuesFromRestriction(null, p, b);
                39.assertTrue("all values from test not correct", a.isAllValuesFromRestriction());
                39.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                39.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                39.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                39.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                39.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                SomeValuesFromRestriction a = m.createSomeValuesFromRestriction(null, p, b);
                40.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                40.assertTrue("some values from test not correct", a.isSomeValuesFromRestriction());
                40.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                40.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                40.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                40.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isHasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual(b);
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                HasValueRestriction a = m.createHasValueRestriction(null, p, x);
                41.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                41.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                41.assertTrue("has value test not correct", this.m_owlLiteLang || a.isHasValueRestriction());
                41.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                41.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                41.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                CardinalityRestriction a = m.createCardinalityRestriction(null, p, 3);
                42.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                42.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                42.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                42.assertTrue("cardinality test not correct", a.isCardinalityRestriction());
                42.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                42.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isMinCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MinCardinalityRestriction a = m.createMinCardinalityRestriction(null, p, 1);
                43.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                43.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                43.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                43.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                43.assertTrue("min cardinality test not correct", a.isMinCardinalityRestriction());
                43.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.isMaxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                MaxCardinalityRestriction a = m.createMaxCardinalityRestriction(null, p, 5);
                44.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                44.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                44.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                44.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                44.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                44.assertTrue("max cardinality test not correct", a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToAllValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                45.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                45.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                45.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                45.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                45.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                45.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToAllValuesFromRestriction(b);
                45.assertTrue("all values from test not correct", a.isAllValuesFromRestriction());
                45.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                45.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                45.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                45.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                45.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToSomeValuesFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                46.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                46.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                46.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                46.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                46.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                46.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                a = a.convertToSomeValuesFromRestriction(b);
                46.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                46.assertTrue("some values from test not correct", a.isSomeValuesFromRestriction());
                46.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                46.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                46.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                46.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertToHasValue", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                47.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                47.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                47.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                47.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                47.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                47.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                OntClass b = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual(b);
                a = a.convertToHasValueRestriction(x);
                47.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                47.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                47.assertTrue("has value test not correct", this.m_owlLiteLang || a.isHasValueRestriction());
                47.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                47.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                47.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                48.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                48.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                48.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                48.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                48.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                48.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                a = a.convertToCardinalityRestriction(3);
                48.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                48.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                48.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                48.assertTrue("cardinality test not correct", a.isCardinalityRestriction());
                48.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                48.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMinCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                49.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                49.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                49.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                49.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                49.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                49.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                a = a.convertToMinCardinalityRestriction(3);
                49.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                49.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                49.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                49.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                49.assertTrue("min cardinality test not correct", a.isMinCardinalityRestriction());
                49.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("Restriction.convertMaxCardinality", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                Restriction a = m.createRestriction(p);
                50.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                50.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                50.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                50.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                50.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                50.assertTrue("max cardinality test not correct", !a.isMaxCardinalityRestriction());
                a = a.convertToMaxCardinalityRestriction(3);
                50.assertTrue("all values from test not correct", !a.isAllValuesFromRestriction());
                50.assertTrue("some values from test not correct", !a.isSomeValuesFromRestriction());
                50.assertTrue("has value test not correct", this.m_owlLiteLang || !a.isHasValueRestriction());
                50.assertTrue("cardinality test not correct", !a.isCardinalityRestriction());
                50.assertTrue("min cardinality test not correct", !a.isMinCardinalityRestriction());
                50.assertTrue("max cardinality test not correct", a.isMaxCardinalityRestriction());
            }
        }, new OntTestBase.OntTestCase("OntClass.listInstances", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual a0 = m.createIndividual(A);
                Individual a1 = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#a1", A);
                Individual b0 = m.createIndividual(B);
                m.createIndividual("http://jena.hpl.hp.com/testing/ontology#b1", B);
                b0.addRDFType(A);
                this.iteratorTest(A.listInstances(), new Object[]{a0, a1, b0});
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                OntProperty s = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                p.setDomain(A);
                q.setDomain(A);
                s.setDomain(C2);
                if (this.m_rdfsLang) {
                    this.iteratorTest(A.listDeclaredProperties(), new Object[]{p, q, r});
                } else {
                    Restriction r0 = m.createRestriction(r);
                    C2.addSuperClass(r0);
                    this.iteratorTest(A.listDeclaredProperties(), new Object[]{p, q, r});
                    this.iteratorTest(C2.listDeclaredProperties(), new Object[]{s, r});
                    this.iteratorTest(r0.listDeclaredProperties(), new Object[]{r});
                }
            }
        }, new OntTestBase.OntTestCase("OntClass.listDefinedProperties.notAll", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass C2 = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                C2.addSuperClass(A);
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty s = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#s");
                p.setDomain(A);
                q.setDomain(A);
                s.setDomain(C2);
                this.iteratorTest(C2.listDeclaredProperties(false), new Object[]{p, q, s});
                this.iteratorTest(C2.listDeclaredProperties(true), new Object[]{s});
                53.assertTrue("declared property should be an ont prop", C2.listDeclaredProperties(true).next() instanceof OntProperty);
                53.assertTrue("declared property should be an ont prop", C2.listDeclaredProperties(false).next() instanceof OntProperty);
            }
        }, new OntTestBase.OntTestCase("DataRange.oneOf", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                Literal x = m.createTypedLiteral(42);
                Literal y = m.createTypedLiteral(true);
                Literal z = m.createTypedLiteral("life");
                RDFList lits = m.createList(new RDFNode[]{x, y});
                DataRange d0 = m.createDataRange(lits);
                54.assertTrue("datarange should contain x", d0.hasOneOf(x));
                54.assertTrue("datarange should contain y", d0.hasOneOf(y));
                54.assertFalse("datarange should not contain z", d0.hasOneOf(z));
                d0.removeOneOf(z);
                54.assertTrue("datarange should contain x", d0.hasOneOf(x));
                54.assertTrue("datarange should contain y", d0.hasOneOf(y));
                54.assertFalse("datarange should not contain z", d0.hasOneOf(z));
                d0.removeOneOf(x);
                54.assertFalse("datarange should not contain x", d0.hasOneOf(x));
                54.assertTrue("datarange should contain y", d0.hasOneOf(y));
                54.assertFalse("datarange should not contain z", d0.hasOneOf(z));
                d0.addOneOf(z);
                54.assertEquals("datarange should be size 2", 2, d0.getOneOf().size());
                this.iteratorTest(d0.listOneOf(), new Object[]{y, z});
                d0.setOneOf(m.createList(new RDFNode[]{x}));
                this.iteratorTest(d0.listOneOf(), new Object[]{x});
            }
        }};
    }
}

