/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntTools;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class TestOntTools
extends TestCase {
    String NS = "http://example.com/test#";
    OntModel m_model;
    OntClass m_a;
    OntClass m_b;
    OntClass m_c;
    OntClass m_d;
    OntClass m_e;
    OntClass m_f;
    OntClass m_g;
    OntClass m_top;

    protected void setUp() throws Exception {
        this.m_model = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        this.m_a = this.m_model.createClass(this.NS + "A");
        this.m_b = this.m_model.createClass(this.NS + "B");
        this.m_c = this.m_model.createClass(this.NS + "C");
        this.m_d = this.m_model.createClass(this.NS + "D");
        this.m_e = this.m_model.createClass(this.NS + "E");
        this.m_f = this.m_model.createClass(this.NS + "F");
        this.m_g = this.m_model.createClass(this.NS + "G");
        this.m_top = this.m_model.createClass(OWL.Thing.getURI());
    }

    public void testIndexLCA0() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_b, this.m_c));
    }

    public void testIndexLCA1() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_c, this.m_b));
    }

    public void testIndexLCA2() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_a, this.m_c));
    }

    public void testIndexLCA3() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_b, this.m_a));
    }

    public void testIndexLCA4() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_d, this.m_c));
    }

    public void testIndexLCA5() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_c, this.m_d));
    }

    public void testIndexLCA6() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        this.m_c.addSubClass(this.m_e);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_d, this.m_e));
    }

    public void testIndexLCA7() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        this.m_c.addSubClass(this.m_e);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_e, this.m_d));
    }

    public void testIndexLCA8() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        this.m_d.addSubClass(this.m_e);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_c, this.m_e));
    }

    public void testIndexLCA9() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_b.addSubClass(this.m_d);
        this.m_d.addSubClass(this.m_e);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_b, this.m_c));
    }

    public void testIndexLCA10() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_a.addSubClass(this.m_d);
        this.m_c.addSubClass(this.m_e);
        this.m_d.addSubClass(this.m_f);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_b, this.m_e));
    }

    public void testIndexLCA11() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_a.addSubClass(this.m_d);
        this.m_c.addSubClass(this.m_e);
        this.m_d.addSubClass(this.m_f);
        TestOntTools.assertEquals(this.m_a, OntTools.getLCA(this.m_model, this.m_b, this.m_f));
    }

    public void testIndexLCA12() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_a.addSubClass(this.m_d);
        this.m_d.addSubClass(this.m_e);
        this.m_d.addSubClass(this.m_f);
        TestOntTools.assertEquals(this.m_d, OntTools.getLCA(this.m_model, this.m_f, this.m_e));
    }

    public void testIndexLCA13() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        this.m_a.addSubClass(this.m_d);
        this.m_c.addSubClass(this.m_e);
        this.m_d.addSubClass(this.m_e);
        this.m_d.addSubClass(this.m_f);
        TestOntTools.assertEquals(this.m_d, OntTools.getLCA(this.m_model, this.m_f, this.m_e));
    }

    public void testIndexLCA14() {
        this.m_a.addSubClass(this.m_b);
        this.m_a.addSubClass(this.m_c);
        TestOntTools.assertEquals(OWL.Thing, OntTools.getLCA(this.m_model, this.m_b, this.m_e));
        TestOntTools.assertEquals(OWL.Thing, OntTools.getLCA(this.m_model, this.m_c, this.m_e));
        TestOntTools.assertEquals(OWL.Thing, OntTools.getLCA(this.m_model, this.m_a, this.m_e));
    }

    public void testShortestPath0() {
        Property p = this.m_model.createProperty(this.NS + "p");
        this.m_a.addProperty(p, this.m_b);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_b, Filter.any), new Property[]{p});
    }

    public void testShortestPath1() {
        Property p = this.m_model.createProperty(this.NS + "p");
        this.m_a.addProperty(p, this.m_b);
        this.m_b.addProperty(p, this.m_c);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_c, Filter.any), new Property[]{p, p});
    }

    public void testShortestPath2() {
        Property p = this.m_model.createProperty(this.NS + "p");
        this.m_a.addProperty(p, this.m_b);
        this.m_b.addProperty(p, this.m_c);
        this.m_a.addProperty(p, this.m_d);
        this.m_d.addProperty(p, this.m_e);
        this.m_e.addProperty(p, this.m_f);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_c, Filter.any), new Property[]{p, p});
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_f, Filter.any), new Property[]{p, p, p});
    }

    public void testShortestPath3() {
        Property p = this.m_model.createProperty(this.NS + "p");
        this.m_a.addProperty(p, this.m_b);
        this.m_b.addProperty(p, this.m_c);
        this.m_a.addProperty(p, this.m_d);
        this.m_d.addProperty(p, this.m_e);
        this.m_e.addProperty(p, this.m_f);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_c, new OntTools.PredicatesFilter(p)), new Property[]{p, p});
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_f, new OntTools.PredicatesFilter(p)), new Property[]{p, p, p});
    }

    public void testShortestPath4() {
        Property p = this.m_model.createProperty(this.NS + "p");
        Property q = this.m_model.createProperty(this.NS + "q");
        this.m_a.addProperty(q, this.m_b);
        this.m_b.addProperty(q, this.m_c);
        this.m_a.addProperty(p, this.m_d);
        this.m_d.addProperty(p, this.m_e);
        this.m_e.addProperty(p, this.m_f);
        TestOntTools.assertNull(OntTools.findShortestPath(this.m_model, this.m_a, this.m_c, new OntTools.PredicatesFilter(p)));
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_f, new OntTools.PredicatesFilter(p)), new Property[]{p, p, p});
    }

    public void testShortestPath5() {
        Property p = this.m_model.createProperty(this.NS + "p");
        this.m_a.addProperty(p, this.m_a);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_a, Filter.any), new Property[]{p});
    }

    public void testShortestPath6() {
        Property p = this.m_model.createProperty(this.NS + "p");
        Property q = this.m_model.createProperty(this.NS + "q");
        this.m_a.addProperty(q, this.m_b);
        this.m_b.addProperty(q, this.m_a);
        TestOntTools.assertNull(OntTools.findShortestPath(this.m_model, this.m_a, this.m_c, new OntTools.PredicatesFilter(new Property[]{p, q})));
    }

    public void testShortestPath7() {
        Property p = this.m_model.createProperty(this.NS + "p");
        Property q = this.m_model.createProperty(this.NS + "q");
        this.m_a.addProperty(p, this.m_d);
        this.m_d.addProperty(q, this.m_e);
        this.m_d.addProperty(q, this.m_b);
        this.m_e.addProperty(p, this.m_f);
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, this.m_f, new OntTools.PredicatesFilter(new Property[]{p, q})), new Property[]{p, q, p});
    }

    public void testShortestPath8() {
        Property p = this.m_model.createProperty(this.NS + "p");
        Property q = this.m_model.createProperty(this.NS + "q");
        this.m_a.addProperty(p, this.m_d);
        this.m_d.addProperty(q, this.m_e);
        this.m_d.addProperty(q, "bluff");
        this.m_d.addProperty(q, this.m_b);
        this.m_e.addProperty(p, this.m_f);
        this.m_f.addProperty(q, "arnie");
        this.testPath(OntTools.findShortestPath(this.m_model, this.m_a, ResourceFactory.createPlainLiteral("arnie"), new OntTools.PredicatesFilter(new Property[]{p, q})), new Property[]{p, q, p, q});
    }

    public void testNamedHierarchyRoots0() {
        this.m_a.addSubClass(this.m_b);
        this.m_b.addSubClass(this.m_c);
        this.m_c.addSubClass(this.m_d);
        this.m_e.addSubClass(this.m_e);
        this.m_e.addSubClass(this.m_f);
        List nhr = OntTools.namedHierarchyRoots(this.m_model);
        TestOntTools.assertEquals(3, nhr.size());
        TestOntTools.assertTrue(nhr.contains(this.m_a));
        TestOntTools.assertTrue(nhr.contains(this.m_e));
        TestOntTools.assertTrue(nhr.contains(this.m_g));
    }

    public void testNamedHierarchyRoots1() {
        this.m_a.addSubClass(this.m_b);
        this.m_b.addSubClass(this.m_c);
        this.m_c.addSubClass(this.m_d);
        this.m_e.addSubClass(this.m_e);
        this.m_e.addSubClass(this.m_f);
        OntClass anon0 = this.m_model.createClass();
        anon0.addSubClass(this.m_a);
        anon0.addSubClass(this.m_e);
        List nhr = OntTools.namedHierarchyRoots(this.m_model);
        TestOntTools.assertEquals(3, nhr.size());
        TestOntTools.assertTrue(nhr.contains(this.m_a));
        TestOntTools.assertTrue(nhr.contains(this.m_e));
        TestOntTools.assertTrue(nhr.contains(this.m_g));
    }

    public void testNamedHierarchyRoots2() {
        OntClass anon0 = this.m_model.createClass();
        OntClass anon1 = this.m_model.createClass();
        anon0.addSubClass(this.m_a);
        anon0.addSubClass(this.m_e);
        anon0.addSubClass(anon1);
        anon1.addSubClass(this.m_g);
        this.m_a.addSubClass(this.m_b);
        this.m_b.addSubClass(this.m_c);
        this.m_c.addSubClass(this.m_d);
        this.m_e.addSubClass(this.m_e);
        this.m_e.addSubClass(this.m_f);
        List nhr = OntTools.namedHierarchyRoots(this.m_model);
        TestOntTools.assertEquals(3, nhr.size());
        TestOntTools.assertTrue(nhr.contains(this.m_a));
        TestOntTools.assertTrue(nhr.contains(this.m_e));
        TestOntTools.assertTrue(nhr.contains(this.m_g));
    }

    private void testPath(OntTools.Path path, Property[] expected) {
        TestOntTools.assertEquals(expected.length, path.size());
        int i = 0;
        Iterator j = path.iterator();
        while (j.hasNext()) {
            TestOntTools.assertEquals("path position: " + i, expected[i], ((Statement)j.next()).getPredicate());
            ++i;
        }
    }
}

