/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.ListIndexException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.RDFListImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestList
extends TestCase {
    public static final String NS = "uri:urn:x-rdf:test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList;

    public TestList(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite s = new TestSuite("TestList");
        for (int i = 0; i <= 5; ++i) {
            s.addTest(new CountTest(i));
            s.addTest(new TailTest(i));
        }
        s.addTest(new ValidityTest());
        s.addTest(new HeadTest());
        s.addTest(new SetHeadTest());
        s.addTest(new SetTailTest());
        s.addTest(new ConsTest());
        s.addTest(new AddTest());
        s.addTest(new TestListGet());
        s.addTest(new ReplaceTest());
        s.addTest(new IndexTest1());
        s.addTest(new IndexTest2());
        s.addTest(new AppendTest());
        s.addTest(new ConcatenateTest());
        s.addTest(new ConcatenateTest2());
        s.addTest(new ApplyTest());
        s.addTest(new ReduceTest());
        s.addTest(new RemoveTest());
        s.addTest(new Map1Test());
        s.addTest(new ListEqualsTest());
        s.addTest(new ListSubclassTest());
        s.addTest(new UserDefinedListTest());
        return s;
    }

    protected static void iteratorTest(Iterator i, Object[] expected) {
        Log logger = LogFactory.getLog(TestList.class);
        ArrayList<Object> expList = new ArrayList<Object>();
        for (int j = 0; j < expected.length; ++j) {
            expList.add(expected[j]);
        }
        while (i.hasNext()) {
            Object next = i.next();
            if (!expList.contains(next)) {
                logger.debug("TestList - Unexpected iterator result: " + next);
            }
            TestList.assertTrue("Value " + next + " was not expected as a result from this iterator ", expList.contains(next));
            TestList.assertTrue("Value " + next + " was not removed from the list ", expList.remove(next));
        }
        if (expList.size() != 0) {
            logger.debug("TestList - Expected iterator results not found");
            Iterator j = expList.iterator();
            while (j.hasNext()) {
                logger.debug("TestList - missing: " + j.next());
            }
        }
        TestList.assertEquals("There were expected elements from the iterator that were not found", 0, expList.size());
    }

    protected static class UserDefListImpl
    extends RDFListImpl
    implements UserDefList {
        public static final String NS = "http://example.org/testlist#";
        public static final Property FIRST = ResourceFactory.createProperty("http://example.org/testlist#first");
        public static final Property REST = ResourceFactory.createProperty("http://example.org/testlist#rest");
        public static final Resource NIL = ResourceFactory.createResource("http://example.org/testlist#nil");
        public static final Resource LIST = ResourceFactory.createResource("http://example.org/testlist#List");
        public static Implementation factory = new Implementation(){

            public EnhNode wrap(Node n, EnhGraph eg) {
                if (this.canWrap(n, eg)) {
                    UserDefListImpl impl = new UserDefListImpl(n, eg);
                    Model m = impl.getModel();
                    impl.m_listFirst = (Property)FIRST.inModel(m);
                    impl.m_listRest = (Property)REST.inModel(m);
                    impl.m_listNil = (Resource)NIL.inModel(m);
                    impl.m_listType = (Resource)LIST.inModel(m);
                    return impl;
                }
                throw new JenaException("Cannot convert node " + n + " to UserDefList");
            }

            public boolean canWrap(Node node, EnhGraph eg) {
                Graph g = eg.asGraph();
                return node.equals(NIL.asNode()) || g.contains(node, FIRST.asNode(), Node.ANY) || g.contains(node, REST.asNode(), Node.ANY) || g.contains(node, RDF.type.asNode(), LIST.asNode());
            }
        };

        public Class listAbstractionClass() {
            return class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList == null ? (class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList = TestList.class$("com.hp.hpl.jena.rdf.model.test.TestList$UserDefList")) : class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList;
        }

        public UserDefListImpl(Node n, EnhGraph g) {
            super(n, g);
        }
    }

    protected static interface UserDefList
    extends RDFList {
    }

    protected static class UserDefinedListTest
    extends ListTest {
        public UserDefinedListTest() {
            super("UserDefinedListTest");
        }

        public void runTest() {
            BuiltinPersonalities.model.add(class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList == null ? (class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList = TestList.class$("com.hp.hpl.jena.rdf.model.test.TestList$UserDefList")) : class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList, UserDefListImpl.factory);
            Model m = ModelFactory.createDefaultModel();
            String NS = "http://example.org/test#";
            Resource a = m.createResource(NS + "a");
            Resource b = m.createResource(NS + "b");
            Resource empty = m.createResource(UserDefListImpl.NIL.getURI());
            UserDefList ul = (UserDefList)empty.as(class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList == null ? (class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList = TestList.class$("com.hp.hpl.jena.rdf.model.test.TestList$UserDefList")) : class$com$hp$hpl$jena$rdf$model$test$TestList$UserDefList);
            UserDefinedListTest.assertNotNull("UserList facet of empty list", ul);
            UserDefList ul0 = (UserDefList)ul.cons(b);
            ul0 = (UserDefList)ul0.cons(a);
            UserDefinedListTest.assertEquals("should be length 2", 2, ul0.size());
            UserDefinedListTest.assertTrue("first statement", m.contains((Resource)ul0, UserDefListImpl.FIRST, a));
        }
    }

    protected static class UserListImpl
    extends RDFListImpl
    implements UserList {
        public UserListImpl(Node n, EnhGraph g) {
            super(n, g);
        }
    }

    protected static interface UserList
    extends RDFList {
    }

    protected static class ListSubclassTest
    extends ListTest {
        public ListSubclassTest() {
            super("ListSubClassTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            String NS = "http://example.org/test#";
            Resource a = m.createResource(NS + "a");
            Resource b = m.createResource(NS + "b");
            Resource cell0 = m.createResource();
            Resource cell1 = m.createResource();
            cell0.addProperty(RDF.first, a);
            cell0.addProperty(RDF.rest, cell1);
            cell1.addProperty(RDF.first, b);
            cell1.addProperty(RDF.rest, RDF.nil);
            UserListImpl ul = new UserListImpl(cell0.asNode(), (EnhGraph)((Object)m));
            ListSubclassTest.assertEquals("User list length ", 2, ul.size());
            ListSubclassTest.assertEquals("head of user list ", a, ul.getHead());
            RDFList l = (RDFList)ul.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            ListSubclassTest.assertNotNull("RDFList facet of user-defined list subclass", l);
        }
    }

    protected static class ListEqualsTest
    extends ListTest {
        public ListEqualsTest() {
            super("ListEqualsTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList nilList = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] r0 = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            Resource[] r1 = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            Resource[] r2 = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d")};
            Resource[] r3 = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#e")};
            Resource[] r4 = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#D"), m.createResource("uri:urn:x-rdf:test#e")};
            Object[][] testSpec = new Object[][]{{r0, r1, Boolean.TRUE}, {r0, r2, Boolean.FALSE}, {r0, r3, Boolean.FALSE}, {r0, r4, Boolean.FALSE}, {r1, r2, Boolean.FALSE}, {r1, r3, Boolean.FALSE}, {r1, r4, Boolean.FALSE}, {r2, r3, Boolean.FALSE}, {r2, r4, Boolean.FALSE}};
            for (int i = 0; i < testSpec.length; ++i) {
                RDFList l0 = nilList.append(Arrays.asList((Object[])testSpec[i][0]).iterator());
                RDFList l1 = nilList.append(Arrays.asList((Object[])testSpec[i][1]).iterator());
                boolean expected = (Boolean)testSpec[i][2];
                ListEqualsTest.assertEquals("sameListAs testSpec[" + i + "] incorrect", expected, l0.sameListAs(l1));
                ListEqualsTest.assertEquals("sameListAs testSpec[" + i + "] (swapped) incorrect", expected, l1.sameListAs(l0));
            }
        }
    }

    protected static class RemoveTest
    extends ListTest {
        public RemoveTest() {
            super("RemoveTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list0 = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            RDFList list1 = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource r0 = m.createResource("uri:urn:x-rdf:test#x");
            Resource r1 = m.createResource("uri:urn:x-rdf:test#y");
            Resource r2 = m.createResource("uri:urn:x-rdf:test#z");
            for (int i = 0; i < 10; ++i) {
                list0 = list0.cons(r0);
                list1 = list1.cons(r1);
            }
            while (!list0.isEmpty()) {
                list0 = list0.removeHead();
                this.checkValid("removeTest0", list0, true);
            }
            list1.removeList();
            RemoveTest.assertEquals("Model should be empty after deleting two lists", 0L, m.size());
            RDFList list2 = ((RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList)).cons(r2).cons(r1).cons(r0);
            RemoveTest.assertTrue("list should contain x ", list2.contains(r0));
            RemoveTest.assertTrue("list should contain y ", list2.contains(r1));
            RemoveTest.assertTrue("list should contain z ", list2.contains(r2));
            list2 = list2.remove(r1);
            RemoveTest.assertTrue("list should contain x ", list2.contains(r0));
            RemoveTest.assertTrue("list should contain y ", !list2.contains(r1));
            RemoveTest.assertTrue("list should contain z ", list2.contains(r2));
            list2 = list2.remove(r0);
            RemoveTest.assertTrue("list should contain x ", !list2.contains(r0));
            RemoveTest.assertTrue("list should contain y ", !list2.contains(r1));
            RemoveTest.assertTrue("list should contain z ", list2.contains(r2));
            list2 = list2.remove(r2);
            RemoveTest.assertTrue("list should contain x ", !list2.contains(r0));
            RemoveTest.assertTrue("list should contain y ", !list2.contains(r1));
            RemoveTest.assertTrue("list should contain z ", !list2.contains(r2));
            RemoveTest.assertTrue("list should be empty", list2.isEmpty());
        }
    }

    protected static class Map1Test
    extends ListTest {
        public Map1Test() {
            super("Map1Test");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            RDFList root = this.getListRoot(m);
            TestList.iteratorTest(root.mapWith(new Map1(){

                public Object map1(Object x) {
                    return ((Resource)x).getLocalName();
                }
            }), new Object[]{"a", "b", "c", "d", "e"});
        }
    }

    protected static class ReduceTest
    extends ListTest {
        public ReduceTest() {
            super("ReduceTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            RDFList root = this.getListRoot(m);
            RDFList.ReduceFn f = new RDFList.ReduceFn(){

                public Object reduce(RDFNode n, Object acc) {
                    return (String)acc + ((Resource)n).getLocalName();
                }
            };
            ReduceTest.assertEquals("Result of reduce should be concatentation of local names", (Object)"abcde", root.reduce(f, ""));
        }
    }

    protected static class ApplyTest
    extends ListTest {
        public ApplyTest() {
            super("ApplyTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            RDFList root = this.getListRoot(m);
            class MyApply
            implements RDFList.ApplyFn {
                String collect = "";

                MyApply() {
                }

                public void apply(RDFNode n) {
                    this.collect = this.collect + ((Resource)n).getLocalName();
                }
            }
            MyApply f = new MyApply();
            root.apply(f);
            ApplyTest.assertEquals("Result of apply should be concatentation of local names", "abcde", f.collect);
        }
    }

    protected static class ConcatenateTest2
    extends ListTest {
        public ConcatenateTest2() {
            super("ConcatenateTest2");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Resource a = m.createResource("uri:urn:x-rdf:test#a");
            RDFNode[] rs = new Resource[]{m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            RDFList aList = m.createList().cons(a);
            RDFList rsList = m.createList(rs);
            aList.concatenate(rsList);
            this.checkValid("concatTest3", aList, true);
            RDFList root = this.getListRoot(m);
            ConcatenateTest2.assertTrue("Constructed and loaded lists should be the same", aList.sameListAs(root));
        }
    }

    protected static class ConcatenateTest
    extends ListTest {
        public ConcatenateTest() {
            super("ConcatenateTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource r = m.createResource("uri:urn:x-rdf:test#foo");
            for (int i = 0; i < 5; ++i) {
                list = list.cons(r);
            }
            int listLen = list.size();
            RDFList root = this.getListRoot(m);
            int rootLen = root.size();
            root.concatenate(list);
            this.checkValid("concatTest0", list, true);
            ConcatenateTest.assertEquals("Original list should be unchanged", listLen, list.size());
            this.checkValid("concatTest1", root, true);
            ConcatenateTest.assertEquals("Root list should be new length", rootLen + listLen, root.size());
        }
    }

    protected static class AppendTest
    extends ListTest {
        public AppendTest() {
            super("AppendTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource r = m.createResource("uri:urn:x-rdf:test#foo");
            for (int i = 0; i < 5; ++i) {
                list = list.cons(r);
            }
            int listLen = list.size();
            RDFList root = this.getListRoot(m);
            int rootLen = root.size();
            RDFList appended = root.append(list);
            this.checkValid("appendTest0", root, true);
            AppendTest.assertEquals("Original list should be unchanged", rootLen, root.size());
            this.checkValid("appendTest1", list, true);
            AppendTest.assertEquals("Original list should be unchanged", listLen, list.size());
            this.checkValid("appendTest2", appended, true);
            AppendTest.assertEquals("Appended list not correct length", rootLen + listLen, appended.size());
        }
    }

    protected static class IndexTest2
    extends ListTest {
        public IndexTest2() {
            super("IndexTest2");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource r = m.createResource("uri:urn:x-rdf:test#a");
            for (int i = 0; i < 10; ++i) {
                list = list.cons(r);
            }
            for (int j = 0; j < 10; ++j) {
                IndexTest2.assertEquals("index of j'th item should be j", j, list.indexOf(r, j));
            }
        }
    }

    protected static class IndexTest1
    extends ListTest {
        public IndexTest1() {
            super("IndexTest1");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Resource[] toGet = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            RDFList l1 = this.getListRoot(m);
            for (int i = 0; i < toGet.length; ++i) {
                IndexTest1.assertTrue("list should contain element " + i, l1.contains(toGet[i]));
                IndexTest1.assertEquals("list element " + i + " is not correct", i, l1.indexOf(toGet[i]));
            }
        }
    }

    protected static class ReplaceTest
    extends ListTest {
        public ReplaceTest() {
            super("ReplaceTest");
        }

        public void runTest() {
            int i;
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Literal[] toSet = new Literal[]{m.createLiteral("a"), m.createLiteral("b"), m.createLiteral("c"), m.createLiteral("d"), m.createLiteral("e")};
            RDFList l1 = this.getListRoot(m);
            for (i = 0; i < toSet.length; ++i) {
                l1.replace(i, toSet[i]);
            }
            for (i = 0; i < toSet.length; ++i) {
                ReplaceTest.assertEquals("list element " + i + " is not correct", toSet[i], l1.get(i));
            }
            boolean gotEx = false;
            try {
                l1.replace(toSet.length + 1, toSet[0]);
            }
            catch (ListIndexException e2) {
                gotEx = true;
            }
            ReplaceTest.assertTrue("Should see exception raised by accessing beyond end of list", gotEx);
        }
    }

    protected static class TestListGet
    extends ListTest {
        public TestListGet() {
            super("TestListGet");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            Resource[] toGet = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            RDFList l1 = this.getListRoot(m);
            for (int i = 0; i < toGet.length; ++i) {
                TestListGet.assertEquals("list element " + i + " is not correct", toGet[i], l1.get(i));
            }
            boolean gotEx = false;
            try {
                l1.get(toGet.length + 1);
            }
            catch (ListIndexException e2) {
                gotEx = true;
            }
            TestListGet.assertTrue("Should see exception raised by accessing beyond end of list", gotEx);
        }
    }

    protected static class AddTest
    extends ListTest {
        public AddTest() {
            super("AddTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource root = m.createResource("uri:urn:x-rdf:test#root");
            Property p = m.createProperty(TestList.NS, "p");
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] toAdd = new Resource[]{m.createResource("uri:urn:x-rdf:test#a"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#e")};
            for (int i = 0; i < toAdd.length; ++i) {
                RDFList list0 = list.with(toAdd[i]);
                this.checkValid("addTest0", list0, true);
                AddTest.assertTrue("added'ed lists should be equal", list.equals(nil) || list0.equals(list));
                list = list0;
            }
            m.add(root, p, list);
            Model m0 = ModelFactory.createDefaultModel();
            m0.read("file:testing/ontology/list5.rdf");
            AddTest.assertTrue("Add'ed and read models should be the same", m0.isIsomorphicWith(m));
        }
    }

    protected static class ConsTest
    extends ListTest {
        public ConsTest() {
            super("ConsTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource root = m.createResource("uri:urn:x-rdf:test#root");
            Property p = m.createProperty(TestList.NS, "p");
            Resource nil = m.getResource(RDF.nil.getURI());
            RDFList list = (RDFList)nil.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            Resource[] toAdd = new Resource[]{m.createResource("uri:urn:x-rdf:test#e"), m.createResource("uri:urn:x-rdf:test#d"), m.createResource("uri:urn:x-rdf:test#c"), m.createResource("uri:urn:x-rdf:test#b"), m.createResource("uri:urn:x-rdf:test#a")};
            for (int i = 0; i < toAdd.length; ++i) {
                RDFList list0 = list.cons(toAdd[i]);
                this.checkValid("constest1", list0, true);
                ConsTest.assertTrue("cons'ed lists should not be equal", !list0.equals(list));
                list = list0;
            }
            m.add(root, p, list);
            Model m0 = ModelFactory.createDefaultModel();
            m0.read("file:testing/ontology/list5.rdf");
            ConsTest.assertTrue("Cons'ed and read models should be the same", m0.isIsomorphicWith(m));
        }
    }

    protected static class SetTailTest
    extends ListTest {
        public SetTailTest() {
            super("SetTailTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource root = m.createResource("uri:urn:x-rdf:test#root");
            Property p = m.createProperty(TestList.NS, "p");
            Resource nil = RDF.nil;
            m.add(nil, RDF.type, RDF.List);
            Resource list0 = m.createResource();
            m.add(list0, RDF.type, RDF.List);
            m.add(list0, RDF.first, "fred");
            m.add(list0, RDF.rest, nil);
            m.add(root, p, list0);
            RDFList l1 = this.getListRoot(m);
            this.checkValid("settail1", l1, true);
            Resource list1 = m.createResource();
            m.add(list1, RDF.type, RDF.List);
            m.add(list1, RDF.first, "george");
            m.add(list1, RDF.rest, nil);
            RDFList l2 = (RDFList)list1.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            SetTailTest.assertNotNull("as(RDFList) should not return null for root", l2);
            this.checkValid("settail2", l2, true);
            SetTailTest.assertEquals("l1 should have length 1", 1, l1.size());
            SetTailTest.assertEquals("l2 should have length 1", 1, l2.size());
            l1.setTail(l2);
            this.checkValid("settail3", l1, true);
            this.checkValid("settail4", l2, true);
            SetTailTest.assertEquals("l1 should have length 2", 2, l1.size());
            SetTailTest.assertEquals("l2 should have length 1", 1, l2.size());
        }
    }

    protected static class SetHeadTest
    extends ListTest {
        public SetHeadTest() {
            super("SetHeadTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource root = m.createResource("uri:urn:x-rdf:test#root");
            Property p = m.createProperty(TestList.NS, "p");
            Resource nil = RDF.nil;
            m.add(nil, RDF.type, RDF.List);
            Resource list = m.createResource();
            m.add(list, RDF.type, RDF.List);
            m.add(list, RDF.first, "fred");
            m.add(list, RDF.rest, nil);
            m.add(root, p, list);
            RDFList l1 = this.getListRoot(m);
            this.checkValid("sethead1", l1, true);
            SetHeadTest.assertEquals("List head should be 'fred'", "fred", ((Literal)l1.getHead()).getString());
            l1.setHead(m.createTypedLiteral(42));
            this.checkValid("sethead2", l1, true);
            SetHeadTest.assertEquals("List head should be '42'", 42, ((Literal)l1.getHead()).getInt());
        }
    }

    protected static class TailTest
    extends ListTest {
        protected int i;

        public TailTest(int i) {
            super("TailTest");
            this.i = i;
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list" + this.i + ".rdf");
            RDFList l0 = this.getListRoot(m);
            for (int j = 0; j < this.i; ++j) {
                l0 = l0.getTail();
            }
            TailTest.assertTrue("Should have reached the end of the list after " + this.i + " getTail()'s", l0.isEmpty());
        }
    }

    protected static class HeadTest
    extends ListTest {
        public HeadTest() {
            super("HeadTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list5.rdf");
            RDFList l0 = this.getListRoot(m);
            String[] names = new String[]{"a", "b", "c", "d", "e"};
            for (int i = 0; i < names.length; ++i) {
                HeadTest.assertEquals("head of list has incorrect URI", TestList.NS + names[i], ((Resource)l0.getHead()).getURI());
                l0 = l0.getTail();
            }
        }
    }

    protected static class ValidityTest
    extends ListTest {
        public ValidityTest() {
            super("ValidityTest");
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            Resource root = m.createResource("uri:urn:x-rdf:test#root");
            Property p = m.createProperty(TestList.NS, "p");
            Resource nil = RDF.nil;
            m.add(root, p, nil);
            RDFList l0 = this.getListRoot(m);
            this.checkValid("valid1", l0, true);
            Resource badList = m.createResource();
            m.getRequiredProperty(root, p).remove();
            m.add(root, p, badList);
            m.add(badList, RDF.type, RDF.List);
            RDFList l1 = this.getListRoot(m);
            this.checkValid("valid2", l1, false);
            m.add(badList, RDF.first, "fred");
            this.checkValid("valid4", l1, false);
            m.add(badList, RDF.rest, nil);
            this.checkValid("valid5", l1, true);
        }
    }

    protected static class CountTest
    extends ListTest {
        protected int i;

        public CountTest(int i) {
            super("CountTest");
            this.i = i;
        }

        public void runTest() {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/ontology/list" + this.i + ".rdf");
            RDFList l0 = this.getListRoot(m);
            CountTest.assertEquals("List size should be " + this.i, this.i, l0.size());
        }
    }

    protected static class ListTest
    extends TestCase {
        public ListTest(String n) {
            super(n);
        }

        protected void checkValid(String testName, RDFList l, boolean validExpected) {
            l.setStrict(true);
            boolean valid = l.isValid();
            ListTest.assertEquals("Validity test " + testName + " returned wrong isValid() result", validExpected, valid);
        }

        protected RDFList getListRoot(Model m) {
            Resource root = m.getResource("uri:urn:x-rdf:test#root");
            ListTest.assertNotNull("Root resource should not be null", root);
            Resource listHead = root.getRequiredProperty(m.getProperty("uri:urn:x-rdf:test#p")).getResource();
            RDFList l = (RDFList)listHead.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = TestList.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList);
            ListTest.assertNotNull("as(RDFList) should not return null for root", l);
            return l;
        }
    }
}

