/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestResourceImpl
extends ModelTestBase {
    public TestResourceImpl(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestResourceImpl.class);
    }

    public void testCannotAsNonLiteral() {
        Model m = ModelFactory.createDefaultModel();
        TestResourceImpl.resource(m, "plumPie").as(Resource.class);
    }

    public void testAsLiteral() {
        Model m = ModelFactory.createDefaultModel();
        try {
            TestResourceImpl.literal(m, "17").as(Resource.class);
            TestResourceImpl.fail("literals cannot be resources");
        }
        catch (ResourceRequiredException e2) {
            TestResourceImpl.pass();
        }
    }

    public void testNameSpace() {
        TestResourceImpl.assertEquals("eh:x", TestResourceImpl.resource("eh:xyz").getNameSpace());
        TestResourceImpl.assertEquals("http://d/", TestResourceImpl.resource("http://d/stuff").getNameSpace());
        TestResourceImpl.assertEquals("ftp://dd.com/12345", TestResourceImpl.resource("ftp://dd.com/12345").getNameSpace());
        TestResourceImpl.assertEquals("http://domain/spoo#", TestResourceImpl.resource("http://domain/spoo#anchor").getNameSpace());
        TestResourceImpl.assertEquals("ftp://abd/def#ghi#", TestResourceImpl.resource("ftp://abd/def#ghi#e11-2").getNameSpace());
    }

    public void testLocalName() {
        TestResourceImpl.assertEquals("yz", TestResourceImpl.resource("eh:xyz").getLocalName());
    }

    public void testHasURI() {
        TestResourceImpl.assertTrue(TestResourceImpl.resource("eh:xyz").hasURI("eh:xyz"));
        TestResourceImpl.assertFalse(TestResourceImpl.resource("eh:xyz").hasURI("eh:1yz"));
        TestResourceImpl.assertFalse(ResourceFactory.createResource().hasURI("42"));
    }

    public void testAddTypedPropertyDouble() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0);
        TestResourceImpl.assertEquals(m.createTypedLiteral(1.0), r.getProperty(RDF.value).getLiteral());
    }

    public void testAddTypedPropertyFloat() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0f);
        TestResourceImpl.assertEquals(m.createTypedLiteral(1.0f), r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyDouble() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0);
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, 1.0));
    }

    public void testHasTypedPropertyFloat() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1.0f);
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, 1.0f));
    }

    public void testAddTypedPropertyLong() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1L);
        TestResourceImpl.assertEquals(m.createTypedLiteral(1L), r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyLong() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 1L);
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, 1L));
    }

    public void testAddTypedPropertyInt() {
    }

    public void testHasTypedPropertyInt() {
    }

    public void testAddTypedPropertyChar() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 'x');
        TestResourceImpl.assertEquals(m.createTypedLiteral('x'), r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyChar() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, 'x');
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, 'x'));
    }

    public void testAddTypedPropertyBoolean() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, true);
        TestResourceImpl.assertEquals(m.createTypedLiteral(true), r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyBoolean() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, false);
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, false));
    }

    public void testAddTypedPropertyString() {
    }

    public void testHasTypedPropertyString() {
    }

    public void testAddTypedPropertyObject() {
        Object z = new Object();
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, z);
        TestResourceImpl.assertEquals(m.createTypedLiteral(z), r.getProperty(RDF.value).getLiteral());
    }

    public void testHasTypedPropertyObject() {
        Object z = new Object();
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addLiteral(RDF.value, z);
        TestResourceImpl.assertTrue(r.hasLiteral(RDF.value, z));
    }
}

