/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid.test;

import com.hp.hpl.jena.shared.uuid.Bits;
import junit.framework.TestCase;

public class TestBits
extends TestCase {
    public void testMask1() {
        long v = Bits.mask(0, 1);
        this.check(1L, v);
    }

    public void testMask2() {
        long v = Bits.mask(0, 2);
        this.check(3L, v);
    }

    public void testMask3() {
        long v = Bits.mask(1, 2);
        this.check(2L, v);
    }

    public void testMask4() {
        long v = Bits.mask(0, 64);
        this.check(-1L, v);
    }

    public void testMask5() {
        long v = Bits.mask(16, 48);
        this.check(0xFFFFFFFF0000L, v);
    }

    public void testMask6() {
        long v = Bits.mask(16, 64);
        this.check(-65536L, v);
    }

    public void testMask7() {
        long v = Bits.mask(0, 0);
        this.check(0L, v);
    }

    public void testMaskZero1() {
        long v = Bits.maskZero(0, 1);
        this.check(-2L, v);
    }

    public void testMaskZero2() {
        long v = Bits.maskZero(0, 2);
        this.check(-4L, v);
    }

    public void testMaskZero3() {
        long v = Bits.maskZero(1, 2);
        this.check(-3L, v);
    }

    public void testMaskZero4() {
        long v = Bits.maskZero(0, 64);
        this.check(0L, v);
    }

    public void testMaskZero5() {
        long v = Bits.maskZero(16, 48);
        this.check(-281474976645121L, v);
    }

    public void testMaskZero6() {
        long v = Bits.maskZero(16, 64);
        this.check(65535L, v);
    }

    public void testMaskZero7() {
        long v = Bits.maskZero(0, 0);
        this.check(-1L, v);
    }

    public void testClear1() {
        long v = 61680L;
        v = Bits.clear(v, 4, 8);
        String s = Long.toHexString(v);
        this.check(61440L, v);
    }

    public void testClear2() {
        long v = Long.MIN_VALUE;
        v = Bits.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(0L, v);
    }

    public void testClear3() {
        long v = -4611686018427387904L;
        v = Bits.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(0x4000000000000000L, v);
    }

    public void testClear4() {
        long v = -1L;
        v = Bits.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(Long.MAX_VALUE, v);
    }

    public void testClear5() {
        long v = -1L;
        v = Bits.clear(v, 32, 64);
        String s = Long.toHexString(v);
        this.check(0xFFFFFFFFL, v);
    }

    public void testClear6() {
        long v = -1L;
        v = Bits.clear(v, 0, 32);
        String s = Long.toHexString(v);
        this.check(-4294967296L, v);
    }

    public void testClear7() {
        long v = -1L;
        v = Bits.clear(v, 0, 0);
        String s = Long.toHexString(v);
        this.check(-1L, v);
    }

    public void testSet1() {
        long v = 0L;
        v = Bits.set(v, 0, 1);
        this.check(1L, v);
    }

    public void testSet2() {
        long v = 1L;
        v = Bits.set(v, 0, 1);
        this.check(1L, v);
    }

    public void testSet3() {
        long v = 240L;
        v = Bits.set(v, 0, 1);
        this.check(241L, v);
    }

    public void testSet4() {
        long v = -1085102592571150096L;
        v = Bits.set(v, 0, 8);
        this.check(-1085102592571150081L, v);
    }

    public void testSet5() {
        long v = 0L;
        v = Bits.set(v, 16, 48);
        this.check(0xFFFFFFFF0000L, v);
    }

    public void testSet6() {
        long v = 0L;
        v = Bits.set(v, 63, 64);
        this.check(Long.MIN_VALUE, v);
    }

    public void testSet7() {
        long v = 0L;
        v = Bits.set(v, 62, 64);
        this.check(-4611686018427387904L, v);
    }

    public void testSet8() {
        long v = 0L;
        v = Bits.set(v, 0, 64);
        this.check(-1L, v);
    }

    public void testSet9() {
        long v = 0L;
        v = Bits.set(v, 10, 10);
        this.check(0L, v);
    }

    public void testSetBit1() {
        long v = 0L;
        v = Bits.set(v, 0);
        this.check(1L, v);
    }

    public void testSetBit2() {
        long v = 0L;
        v = Bits.set(v, 1);
        this.check(2L, v);
    }

    public void testSetBit3() {
        long v = 1L;
        v = Bits.set(v, 0);
        this.check(1L, v);
    }

    public void testSetBit4() {
        long v = -1L;
        v = Bits.set(v, 0);
        this.check(-1L, v);
    }

    public void testSetBit5() {
        long v = 0L;
        v = Bits.set(v, 62);
        this.check(0x4000000000000000L, v);
    }

    public void testSetBit6() {
        long v = 0L;
        v = Bits.set(v, 63);
        this.check(Long.MIN_VALUE, v);
    }

    public void testBitTest1() {
        long v = 0L;
        TestBits.assertTrue(Bits.test(v, false, 0));
    }

    public void testBitTest2() {
        long v = 1L;
        TestBits.assertTrue(Bits.test(v, true, 0));
    }

    public void testBitTest3() {
        long v = -1L;
        TestBits.assertTrue(Bits.test(v, true, 63));
    }

    public void testBitTest4() {
        long v = Long.MAX_VALUE;
        TestBits.assertTrue(Bits.test(v, false, 63));
    }

    public void testBitsTest1() {
        long v = -81985529216486896L;
        TestBits.assertTrue(Bits.test(v, 0L, 0, 4));
    }

    public void testBitsTest2() {
        long v = -81985529216486896L;
        TestBits.assertTrue(Bits.test(v, 16L, 0, 8));
    }

    public void testBitsTest3() {
        long v = -81985529216486896L;
        TestBits.assertTrue(Bits.test(v, v, 0, 64));
    }

    public void testBitsTest4() {
        long v = -81985529216486896L;
        TestBits.assertFalse(Bits.test(v, 0L, 0, 64));
    }

    public void testBitsTest5() {
        long v = -81985529216486896L;
        TestBits.assertTrue(Bits.test(v, 205163983011840L, 16, 48));
    }

    public void testAccess1() {
        long v = -1L;
        v = Bits.access(v, 4, 8);
        this.check(240L, v);
    }

    public void testAccess2() {
        long v = -81985529216486896L;
        v = Bits.access(v, 0, 8);
        this.check(16L, v);
    }

    public void testAccess3() {
        long v = -81985529216486896L;
        v = Bits.access(v, 0, 64);
        this.check(-81985529216486896L, v);
    }

    public void testAccess4() {
        long v = -81985529216486896L;
        v = Bits.access(v, 62, 64);
        this.check(-4611686018427387904L, v);
    }

    public void testAccess5() {
        long v = -81985529216486896L;
        v = Bits.access(v, 0, 2);
        this.check(0L, v);
    }

    public void testPack1() {
        long v = 0L;
        v = Bits.pack(v, 15L, 0, 4);
        this.check(15L, v);
    }

    public void testPack2() {
        long v = 240L;
        v = Bits.pack(v, 2L, 0, 4);
        this.check(242L, v);
    }

    public void testPack3() {
        long v = -1L;
        v = Bits.pack(v, 2L, 0, 8);
        this.check(-254L, v);
    }

    public void testPack4() {
        long v = -4294967296L;
        v = Bits.pack(v, 2L, 16, 32);
        this.check(-4294836224L, v);
    }

    public void testPack5() {
        long v = -4294967296L;
        v = Bits.pack(v, 65535L, 16, 32);
        this.check(-65536L, v);
    }

    public void testUnpack1() {
        long v = -6067004223159161907L;
        v = Bits.unpack(v, 0, 4);
        this.check(13L, v);
    }

    public void testUnpack2() {
        long v = -6067004223159161907L;
        v = Bits.unpack(v, 63, 64);
        this.check(1L, v);
    }

    public void testUnpack3() {
        long v = -6067004223159161907L;
        v = Bits.unpack(v, 56, 64);
        this.check(171L, v);
    }

    public void testUnpack4() {
        long v = -6067173106999841843L;
        v = Bits.unpack(v, 32, 48);
        this.check(4660L, v);
    }

    public void testUnpackStr1() {
        String s = "ABCD";
        long v = Bits.unpack(s, 0, 4);
        this.check(43981L, v);
    }

    public void testUnpackStr2() {
        String s = "ABCD";
        long v = Bits.unpack(s, 2, 4);
        this.check(205L, v);
    }

    public void testUnpackStr3() {
        String s = "ABCD";
        long v = Bits.unpack(s, 0, 2);
        this.check(171L, v);
    }

    private void check(long expected, long actual) {
        this.check(null, expected, actual);
    }

    private void check(String msg, long expected, long actual) {
        if (expected == actual) {
            return;
        }
        String s = "Expected: " + Long.toHexString(expected) + " : Got: " + Long.toHexString(actual);
        if (msg != null) {
            s = msg + ": " + s;
        }
        TestBits.assertFalse(s, true);
    }
}

