/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.junit.TestExprBoolean;
import com.hp.hpl.jena.sparql.junit.TestExprNumeric;
import com.hp.hpl.jena.sparql.junit.TestExprRDFTerm;
import com.hp.hpl.jena.sparql.junit.TestExprString;
import com.hp.hpl.jena.sparql.junit.TestExprSyntax;
import com.hp.hpl.jena.sparql.junit.TestExprURI;
import com.hp.hpl.jena.sparql.junit.TestVar;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestSuite;

public class TS_Expr
extends TestSuite {
    static final String testSetName = "ARQ - Expressions";

    public static TestSuite suite() {
        TS_Expr ts = new TS_Expr(testSetName);
        ts.addStdTests(ts);
        return ts;
    }

    public TS_Expr(String name) {
        super(name);
    }

    public void addStdTests(TestSuite ts) {
        ts.addTest(TS_Expr.variables());
        ts.addTest(TS_Expr.numericValues());
        ts.addTest(TS_Expr.numericExpr());
        ts.addTest(TS_Expr.booleanValues());
        ts.addTest(TS_Expr.booleanExpr());
        ts.addTest(TS_Expr.DateTime());
        ts.addTest(TS_Expr.rdfTermsURIs());
        ts.addTest(TS_Expr.rdfTerms());
        ts.addTest(TS_Expr.typedLiterals());
        ts.addTest(TS_Expr.stringExpr());
        ts.addTest(TS_Expr.builtinOps());
        ts.addTest(TS_Expr.castExpr());
    }

    public static TestSuite variables() {
        TestSuite ts = new TestSuite("Variables");
        ts.addTest(new TestVar("?x", "x"));
        ts.addTest(new TestVar("$x", "x"));
        ts.addTest(new TestVar("?name", "name"));
        ts.addTest(new TestVar("$name", "name"));
        ts.addTest(new TestExprSyntax("?x11"));
        ts.addTest(new TestVar("?x_", "x_"));
        ts.addTest(new TestVar("?x.", "x"));
        ts.addTest(new TestVar("?x.x", "x"));
        ts.addTest(new TestVar("?0", "0"));
        ts.addTest(new TestVar("?0x", "0x"));
        ts.addTest(new TestVar("?x0", "x0"));
        ts.addTest(new TestVar("?_", "_"));
        ts.addTest(new TestVar("?", 250));
        ts.addTest(new TestExprSyntax("??", 250));
        ts.addTest(new TestExprSyntax("?.", 250));
        ts.addTest(new TestExprSyntax("?#", 250));
        return ts;
    }

    public static TestSuite numericValues() {
        TestSuite ts = new TestSuite("Numeric Values");
        ts.addTest(new TestExprNumeric("7", 7L));
        ts.addTest(new TestExprNumeric("-3", -3L));
        ts.addTest(new TestExprNumeric("+2", 2L));
        return ts;
    }

    public static TestSuite numericExpr() {
        TestSuite ts = new TestSuite("Numeric Expressions");
        ts.addTest(new TestExprNumeric("3+-4", -1L));
        ts.addTest(new TestExprNumeric("3-+4", -1L));
        ts.addTest(new TestExprNumeric("3+-4", -1L));
        ts.addTest(new TestExprNumeric("3-(-4)", 7L));
        ts.addTest(new TestExprNumeric("3+4+5", 12L));
        ts.addTest(new TestExprNumeric("(3+4)+5", 12L));
        ts.addTest(new TestExprNumeric("3+(4+5)", 12L));
        ts.addTest(new TestExprNumeric("3*4+5", 17L));
        ts.addTest(new TestExprNumeric("3*(4+5)", 27L));
        ts.addTest(new TestExprNumeric("10-3-5", 2L));
        ts.addTest(new TestExprNumeric("(10-3)-5", 2L));
        ts.addTest(new TestExprNumeric("10-(3-5)", 12L));
        ts.addTest(new TestExprNumeric("10-3+5", 12L));
        ts.addTest(new TestExprNumeric("10-(3+5)", 2L));
        ts.addTest(new TestExprNumeric("1.5 + 2.5", 4.0));
        ts.addTest(new TestExprNumeric("1.5 + 2", 3.5));
        ts.addTest(new TestExprNumeric("4111222333444", 4111222333444L));
        ts.addTest(new TestExprNumeric("1234 + 4111222333444", 4111222334678L));
        ts.addTest(new TestExprBoolean("4111222333444 > 1234", true));
        ts.addTest(new TestExprBoolean("4111222333444 < 1234", false));
        ts.addTest(new TestExprBoolean("1.5 < 2", true));
        ts.addTest(new TestExprBoolean("1.5 > 2", false));
        ts.addTest(new TestExprBoolean("1.5 < 2.3", true));
        ts.addTest(new TestExprBoolean("1.5 > 2.3", false));
        return ts;
    }

    public static TestSuite booleanValues() {
        TestSuite ts = new TestSuite("Boolean Values");
        ts.addTest(new TestExprBoolean("'true'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        ts.addTest(new TestExprBoolean("'1'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        ts.addTest(new TestExprBoolean("'false'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        ts.addTest(new TestExprBoolean("'0'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        ts.addTest(new TestExprBoolean("1 || false", true));
        ts.addTest(new TestExprBoolean("'foo'  || false", true));
        ts.addTest(new TestExprBoolean("0 || false", false));
        ts.addTest(new TestExprBoolean("'' || false", false));
        ts.addTest(new TestExprBoolean("!'junk'^^<urn:unknown>", 200));
        return ts;
    }

    public static TestSuite booleanExpr() {
        TestSuite ts = new TestSuite("Boolean Expressions");
        ts.addTest(new TestExprBoolean("2 < 3", true));
        ts.addTest(new TestExprBoolean("2 < 3", true));
        ts.addTest(new TestExprBoolean("2 > 3", false));
        ts.addTest(new TestExprBoolean("(2 < 3) && (3<4)", true));
        ts.addTest(new TestExprBoolean("(2 < 3) && (3>=4)", false));
        ts.addTest(new TestExprBoolean("(2 < 3) || (3>=4)", true));
        ts.addTest(new TestExprBoolean("(2 < 3) || ?x > 2", true));
        ts.addTest(new TestExprBoolean("(2 > 3) || ?x > 2", 200));
        ts.addTest(new TestExprBoolean("(2 > 3) && ?x > 2", false));
        ts.addTest(new TestExprBoolean("(2 < 3) && ?x > 2", 200));
        ts.addTest(new TestExprBoolean("?x > 2 || (2 < 3)", true));
        ts.addTest(new TestExprBoolean("?x > 2 || (2 > 3)", 200));
        ts.addTest(new TestExprBoolean("?x > 2 && (2 < 3)", 200));
        ts.addTest(new TestExprBoolean("?x > 2 && (2 > 3)", false));
        ts.addTest(new TestExprBoolean("! ?x ", 200));
        ts.addTest(new TestExprBoolean("! true ", false));
        ts.addTest(new TestExprBoolean("! false ", true));
        ts.addTest(new TestExprBoolean("2 = 3", false));
        ts.addTest(new TestExprBoolean("!(2 = 3)", true));
        ts.addTest(new TestExprBoolean("'2' = 2", false));
        ts.addTest(new TestExprBoolean("2 = '2'", false));
        ts.addTest(new TestExprBoolean("2 < '3'", true, 200));
        ts.addTest(new TestExprBoolean("'2' < 3", true, 200));
        ts.addTest(new TestExprBoolean("\"fred\" != \"joe\"", true));
        ts.addTest(new TestExprBoolean("\"fred\" = \"joe\"", false));
        ts.addTest(new TestExprBoolean("\"fred\" = \"fred\"", true));
        ts.addTest(new TestExprBoolean("\"fred\" = 'fred'", true));
        ts.addTest(new TestExprBoolean("true = true", true));
        ts.addTest(new TestExprBoolean("false = false", true));
        ts.addTest(new TestExprBoolean("true = false", false));
        ts.addTest(new TestExprBoolean("true > true", false));
        ts.addTest(new TestExprBoolean("true >= false", true));
        ts.addTest(new TestExprBoolean("false > false", false));
        ts.addTest(new TestExprBoolean("false >= false", true));
        ts.addTest(new TestExprBoolean("true > false", true));
        ts.addTest(new TestExprBoolean("1 = true", false));
        ts.addTest(new TestExprBoolean("1 != true", true));
        ts.addTest(new TestExprBoolean("'a' != false", true));
        ts.addTest(new TestExprBoolean("0 != false", true));
        return ts;
    }

    public static TestSuite DateTime() {
        TestSuite ts = new TestSuite("DateTime Expressions");
        String dateTime1 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime2 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime3 = "'2005-01-01T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime4 = "'2005-02-25T13:00:00Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        ts.addTest(new TestExprBoolean(dateTime1 + " = " + dateTime2, true));
        ts.addTest(new TestExprBoolean(dateTime1 + " <= " + dateTime2, true));
        ts.addTest(new TestExprBoolean(dateTime1 + " >= " + dateTime2, true));
        ts.addTest(new TestExprBoolean(dateTime3 + " < " + dateTime1, true));
        ts.addTest(new TestExprBoolean(dateTime3 + " > " + dateTime1, false));
        ts.addTest(new TestExprBoolean(dateTime4 + " < " + dateTime1, false));
        ts.addTest(new TestExprBoolean(dateTime4 + " > " + dateTime1, true));
        return ts;
    }

    public static TestSuite rdfTermsURIs() {
        TestSuite ts = new TestSuite("RDF terms: QNames, URIs");
        Query query2 = QueryFactory.make();
        String exNS = "http://example.org/";
        String xNS = "http://example.org/dot#";
        String selNS = "http://select/";
        String dftNS = "http://default/";
        String baseNS = "http://base/";
        String rdfNS = RDF.getURI();
        query2.setBaseURI(baseNS);
        ts.addTest(new TestExprURI("<a>", baseNS + "a", query2, null, 100));
        ts.addTest(new TestExprURI("<a\\u00E9>", baseNS + "a\u00e9", query2, null, 100));
        query2.setPrefix("ex", exNS);
        query2.setPrefix("rdf", RDF.getURI());
        query2.setPrefix("x.", xNS);
        query2.setPrefix("", dftNS);
        query2.setPrefix("select", selNS);
        ts.addTest(new TestExprURI("ex:b", exNS + "b", query2, null, 100));
        ts.addTest(new TestExprURI("ex:b_", exNS + "b_", query2, null, 100));
        ts.addTest(new TestExprURI("ex:a_b", exNS + "a_b", query2, null, 100));
        ts.addTest(new TestExprURI("ex:", exNS, query2, null, 100));
        ts.addTest(new TestExprURI("x.:", xNS, query2, null, 250));
        ts.addTest(new TestExprURI("rdf:_2", rdfNS + "_2", query2, null, 100));
        ts.addTest(new TestExprURI("rdf:__2", rdfNS + "__2", query2, null, 100));
        ts.addTest(new TestExprURI(":b", dftNS + "b", query2, null, 100));
        ts.addTest(new TestExprURI(":", dftNS, query2, null, 100));
        ts.addTest(new TestExprURI(":\\u00E9", dftNS + "\u00e9", query2, null, 100));
        ts.addTest(new TestExprURI("\\u0065\\u0078:", exNS, query2, null, 100));
        ts.addTest(new TestExprURI("select:a", selNS + "a", query2, null, 100));
        ts.addTest(new TestExprRDFTerm("_:", 250));
        ts.addTest(new TestExprURI("ex:a.", exNS + "a", query2, null, 100));
        ts.addTest(new TestExprURI("ex:a.a", exNS + "a.a", query2, null, 100));
        ts.addTest(new TestExprURI("x.:a.a", xNS + "a.a", query2, null, 250));
        ts.addTest(new TestExprNumeric("1:b", 1L));
        ts.addTest(new TestExprURI("ex:2", exNS + "2", query2, null, 100));
        ts.addTest(new TestExprURI("ex:2ab_c", exNS + "2ab_c", query2, null, 100));
        return ts;
    }

    public static TestSuite rdfTerms() {
        TestSuite ts = new TestSuite("RDF terms: general");
        ts.addTest(new TestExprBoolean("'fred'@en = 'fred'", false));
        ts.addTest(new TestExprBoolean("'fred'@en = 'bert'", false));
        ts.addTest(new TestExprBoolean("'fred'@en != 'fred'", true));
        ts.addTest(new TestExprBoolean("'fred'@en != 'bert'", true));
        ts.addTest(new TestExprBoolean("'chat'@en = 'chat'@fr", false));
        ts.addTest(new TestExprBoolean("'chat'@en = 'maison'@fr", false));
        ts.addTest(new TestExprBoolean("'chat'@en != 'chat'@fr", true));
        ts.addTest(new TestExprBoolean("'chat'@en != 'maison'@fr", true));
        ts.addTest(new TestExprBoolean("'chat'@en = 'chat'@EN", true));
        ts.addTest(new TestExprBoolean("'chat'@en = 'chat'@en-uk", false));
        ts.addTest(new TestExprBoolean("'chat'@en != 'chat'@EN", false));
        ts.addTest(new TestExprBoolean("'chat'@en != 'chat'@en-uk", true));
        ts.addTest(new TestExprBoolean("'chat'@en = <http://example/>", false));
        return ts;
    }

    public static TestSuite typedLiterals() {
        TestSuite ts = new TestSuite("Type Literals");
        ts.addTest(new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type1>", true));
        ts.addTest(new TestExprBoolean("'fred'^^<type1> != 'joe'^^<type1>", 200));
        ts.addTest(new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type2>", 200));
        ts.addTest(new TestExprBoolean("'fred'^^<type1> != 'joe'^^<type2>", 200));
        ts.addTest(new TestExprBoolean("'fred'^^<" + XSDDatatype.XSDstring.getURI() + "> = 'fred'", true));
        ts.addTest(new TestExprBoolean("'fred'^^<type1> = 'fred'", 200));
        ts.addTest(new TestExprBoolean("'fred'^^<type1> != 'fred'", 200));
        ts.addTest(new TestExprNumeric("'21'^^<" + XSDDatatype.XSDinteger.getURI() + ">", 21L));
        ts.addTest(new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 21", true));
        ts.addTest(new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 22", false));
        ts.addTest(new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 21", false));
        ts.addTest(new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 22", true));
        ts.addTest(new TestExprBoolean("'x'^^<type1>  = 21", 200));
        ts.addTest(new TestExprBoolean("'x'^^<type1> != 21", 200));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> = true", 200));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> != true", 200));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> = 'x'^^<http://example/unknown>", true));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> = 'y'^^<http://example/unknown>", 200));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> != 'x'^^<http://example/unknown>", false));
        ts.addTest(new TestExprBoolean("'x'^^<http://example/unknown> != 'y'^^<http://example/unknown>", 200));
        return ts;
    }

    public static TestSuite stringExpr() {
        TestSuite ts = new TestSuite("String Expressions");
        ts.addTest(new TestExprString("'a\\nb'", "a\nb"));
        ts.addTest(new TestExprString("'a\\n'", "a\n"));
        ts.addTest(new TestExprString("'\\nb'", "\nb"));
        ts.addTest(new TestExprString("'a\\tb'", "a\tb"));
        ts.addTest(new TestExprString("'a\\bb'", "a\bb"));
        ts.addTest(new TestExprString("'a\\rb'", "a\rb"));
        ts.addTest(new TestExprString("'a\\fb'", "a\fb"));
        ts.addTest(new TestExprString("'a\\\\b'", "a\\b"));
        ts.addTest(new TestExprString("'a\\u0020a'", "a a"));
        ts.addTest(new TestExprString("'a\\uF021'", "a\uf021"));
        ts.addTest(new TestExprString("'a\\X'", "", 250));
        ts.addTest(new TestExprString("'aaa\\'", "", 250));
        ts.addTest(new TestExprString("'\\u'", "", 250));
        ts.addTest(new TestExprString("'\\u111'", "", 250));
        ts.addTest(new TestExprBoolean("'fred\\\\3' != \"fred3\"", true));
        ts.addTest(new TestExprBoolean("'urn:fred' = <urn:fred>", false));
        ts.addTest(new TestExprBoolean("'urn:fred' != <urn:fred>", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc', 'abbc')", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc' , 'a..c')", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc' , '^aabb')", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc' , 'cc$')", true));
        ts.addTest(new TestExprBoolean("! REGEX('aabbcc' , 'abbc')", false));
        ts.addTest(new TestExprBoolean("REGEX('aa\\\\cc', '\\\\\\\\')", true));
        ts.addTest(new TestExprBoolean("REGEX('aab*bcc', 'ab\\\\*bc')", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc',  'ab\\\\\\\\*bc')", true));
        ts.addTest(new TestExprBoolean("REGEX('aabbcc', 'B.*B', 'i')", true));
        ts.addTest(new TestExprBoolean("2 < 'fred'", 200));
        return ts;
    }

    public static TestSuite builtinOps() {
        TestSuite ts = new TestSuite("Builtin Operators");
        BindingMap env = new BindingMap();
        env.add(Var.alloc("a"), Node.createLiteral("A"));
        env.add(Var.alloc("b"), Node.createAnon());
        env.add(Var.alloc("x"), Node.createURI("urn:x"));
        ts.addTest(new TestExprBoolean("datatype('fred') = <" + XSD.xstring.getURI() + ">", true));
        ts.addTest(new TestExprBoolean("datatype('fred'^^<urn:foo>) = <urn:foo>", true));
        ts.addTest(new TestExprBoolean("datatype('fred'^^<foo>) = <Foo>", false));
        ts.addTest(new TestExprString("lang('fred'@en)", "en"));
        ts.addTest(new TestExprString("lang('fred'@en-uk)", "en-uk"));
        ts.addTest(new TestExprString("lang('fred')", ""));
        ts.addTest(new TestExprBoolean("isURI(?x)", true, env));
        ts.addTest(new TestExprBoolean("isURI(?a)", false, env));
        ts.addTest(new TestExprBoolean("isURI(?b)", false, env));
        ts.addTest(new TestExprBoolean("isURI(?y)", false, env, 200));
        ts.addTest(new TestExprBoolean("isURI(<urn:foo>)", true, env));
        ts.addTest(new TestExprBoolean("isURI('bar')", false, env));
        ts.addTest(new TestExprBoolean("isLiteral(?x)", false, env));
        ts.addTest(new TestExprBoolean("isLiteral(?a)", true, env));
        ts.addTest(new TestExprBoolean("isLiteral(?b)", false, env));
        ts.addTest(new TestExprBoolean("isLiteral(?y)", false, env, 200));
        ts.addTest(new TestExprBoolean("isBlank(?x)", false, env));
        ts.addTest(new TestExprBoolean("isBlank(?a)", false, env));
        ts.addTest(new TestExprBoolean("isBlank(?b)", true, env));
        ts.addTest(new TestExprBoolean("isBlank(?y)", false, env, 200));
        ts.addTest(new TestExprBoolean("bound(?a)", true, env));
        ts.addTest(new TestExprBoolean("bound(?b)", true, env));
        ts.addTest(new TestExprBoolean("bound(?x)", true, env));
        ts.addTest(new TestExprBoolean("bound(?y)", false, env));
        ts.addTest(new TestExprString("str(<urn:x>)", "urn:x"));
        ts.addTest(new TestExprString("str('')", ""));
        ts.addTest(new TestExprString("str(15)", "15"));
        ts.addTest(new TestExprString("str('15.20'^^<" + XSDDatatype.XSDdouble.getURI() + ">)", "15.20"));
        ts.addTest(new TestExprString("str('lex'^^<x:unknown>)", "lex"));
        ts.addTest(new TestExprBoolean("sameTerm(1,1)", true, env));
        ts.addTest(new TestExprBoolean("sameTerm(1,1.0)", false, env));
        return ts;
    }

    public static TestSuite castExpr() {
        String xsd = "http://www.w3.org/2001/XMLSchema#";
        TestSuite ts = new TestSuite("XSD Casts");
        ts.addTest(new TestExprNumeric("<" + xsd + "integer>('3')", 3L));
        ts.addTest(new TestExprNumeric("<" + xsd + "byte>('3')", 3L));
        ts.addTest(new TestExprNumeric("<" + xsd + "int>('3')", 3L));
        ts.addTest(new TestExprBoolean("<" + xsd + "double>('3') = 3", true));
        ts.addTest(new TestExprBoolean("<" + xsd + "float>('3') = 3", true));
        ts.addTest(new TestExprBoolean("<" + xsd + "double>('3') = <" + xsd + "float>('3')", true));
        ts.addTest(new TestExprBoolean("<" + xsd + "double>(str('3')) = 3", true));
        return ts;
    }
}

