/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheManager;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCache
extends TestCase {
    public TestCache(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite("Cache");
        suite.addTest(new CacheTestCase("RAND"));
        return suite;
    }

    static class CacheTestCase
    extends TestCase {
        String cacheType;

        CacheTestCase(String cacheType) {
            super(cacheType);
            this.cacheType = cacheType;
        }

        protected void runTest() {
            this.testCache();
        }

        public void testCache() {
            this.testCacheCreation(this.cacheType);
            this.testCacheSimpleReturn(this.cacheType);
            this.testFillTheCache(this.cacheType);
        }

        public void testCacheCreation(String type) {
            Cache c1 = CacheManager.createCache(type, "c1", 100);
            try {
                Cache c2 = CacheManager.createCache(type, "c2", 1);
                CacheTestCase.assertTrue("Missing error on bad cache size: " + type, false);
            }
            catch (Error error) {
                // empty catch block
            }
        }

        public void testCacheSimpleReturn(String type) {
            Integer v1;
            Integer v2;
            String k1;
            String k2;
            int size = 100;
            Cache c1 = CacheManager.createCache(type, "c1", size);
            String k3 = k2 = (k1 = "one");
            Integer v3 = v2 = (v1 = new Integer(-1));
            c1.put(k1, v1);
            for (int i = 0; i < size; ++i) {
                k1 = k2;
                v1 = v2;
                Object o = c1.get(k1);
                CacheTestCase.assertTrue("expected a hit", o != null);
                CacheTestCase.assertEquals("should be the expected object", o, v1);
                k2 = k3;
                v2 = v3;
                o = c1.get(k2);
                CacheTestCase.assertTrue("expected a hit", o != null);
                CacheTestCase.assertEquals("should be the expected object", o, v2);
                k3 = "T" + i;
                v3 = new Integer(i);
                c1.put(k3, v3);
            }
        }

        public void testFillTheCache(String type) {
            int size = 100;
            Cache c1 = CacheManager.createCache(type, "c1", 100);
            String[] k = new String[100];
            String[] v = new String[100];
            for (int i = 0; i < 100; ++i) {
                k[i] = "K" + i;
                v[i] = "V" + i;
                c1.put(k[i], v[i]);
            }
            int count = 0;
            for (int i = 0; i < 100; ++i) {
                if (c1.get(k[i]) == null) continue;
                ++count;
            }
            CacheTestCase.assertTrue("too low a hit rate: " + type + " = " + count, count > 50);
            CacheTestCase.assertEquals("count puts", 100L, c1.getPuts());
            CacheTestCase.assertEquals("count gets", 100L, c1.getGets());
            CacheTestCase.assertEquals("count hits", (long)count, c1.getHits());
        }
    }
}

