/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class SegmentMerger {
    static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    private Directory directory;
    private String segment;
    private int termIndexInterval = 128;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private int mergedDocs;
    private IndexOutput freqOutput = null;
    private IndexOutput proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private int skipInterval;
    private int maxSkipLevels;
    private SegmentMergeQueue queue = null;
    private DefaultSkipListWriter skipListWriter = null;
    private final TermInfo termInfo = new TermInfo();
    private byte[] payloadBuffer = null;

    SegmentMerger(Directory dir, String name) {
        this.directory = dir;
        this.segment = name;
    }

    SegmentMerger(IndexWriter writer, String name) {
        this.directory = writer.getDirectory();
        this.segment = name;
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    final void add(IndexReader reader) {
        this.readers.addElement(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.elementAt(i);
    }

    final int merge() throws CorruptIndexException, IOException {
        this.mergedDocs = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        return this.mergedDocs;
    }

    final void closeReaders() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            reader.close();
        }
    }

    final Vector createCompoundFile(String fileName) throws IOException {
        int i;
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, fileName);
        Vector<String> files = new Vector<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
        for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
            files.add(this.segment + "." + IndexFileNames.COMPOUND_EXTENSIONS[i]);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            files.add(this.segment + "." + "nrm");
            break;
        }
        if (this.fieldInfos.hasVectors()) {
            for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                files.add(this.segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
            }
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        return files;
    }

    private void addIndexed(IndexReader reader, FieldInfos fieldInfos, Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean storePayloads) throws IOException {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String field;
            fieldInfos.add(field, true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector, !reader.hasNorms(field = (String)i.next()), storePayloads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws CorruptIndexException, IOException {
        this.fieldInfos = new FieldInfos();
        int docCount = 0;
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET), true, true, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION), true, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET), true, false, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR), true, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.STORES_PAYLOADS), false, false, false, true);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.INDEXED), false, false, false, false);
            this.fieldInfos.add(reader.getFieldNames(IndexReader.FieldOption.UNINDEXED), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        FieldSelector fieldSelectorMerge = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                return FieldSelectorResult.LOAD_FOR_MERGE;
            }
        };
        try {
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader reader = (IndexReader)this.readers.elementAt(i);
                int maxDoc = reader.maxDoc();
                for (int j = 0; j < maxDoc; ++j) {
                    if (reader.isDeleted(j)) continue;
                    fieldsWriter.addDocument(reader.document(j, fieldSelectorMerge));
                    ++docCount;
                }
            }
        }
        finally {
            fieldsWriter.close();
        }
        return docCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            for (int r = 0; r < this.readers.size(); ++r) {
                IndexReader reader = (IndexReader)this.readers.elementAt(r);
                int maxDoc = reader.maxDoc();
                for (int docNum = 0; docNum < maxDoc; ++docNum) {
                    if (reader.isDeleted(docNum)) continue;
                    termVectorsWriter.addAllDocVectors(reader.getTermFreqVectors(docNum));
                }
            }
        }
        finally {
            termVectorsWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws CorruptIndexException, IOException {
        try {
            this.freqOutput = this.directory.createOutput(this.segment + ".frq");
            this.proxOutput = this.directory.createOutput(this.segment + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos, this.termIndexInterval);
            this.skipInterval = this.termInfosWriter.skipInterval;
            this.maxSkipLevels = this.termInfosWriter.maxSkipLevels;
            this.skipListWriter = new DefaultSkipListWriter(this.skipInterval, this.maxSkipLevels, this.mergedDocs, this.freqOutput, this.proxOutput);
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws CorruptIndexException, IOException {
        int base = 0;
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
                continue;
            }
            smi.close();
        }
        SegmentMergeInfo[] match2 = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match2[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match2[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match2[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo(match2, matchSize);
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match2[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        int df = this.appendPostings(smis, n);
        long skipPointer = this.skipListWriter.writeSkip(this.freqOutput);
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        int lastDoc = 0;
        int df = 0;
        this.skipListWriter.resetSkip();
        boolean storePayloads = this.fieldInfos.fieldInfo((String)smis[0].term.field).storePayloads;
        int lastPayloadLength = -1;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.getPositions();
            int base = smi.base;
            int[] docMap = smi.getDocMap();
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < 0 || df > 0 && doc <= lastDoc) {
                    throw new CorruptIndexException("docs out of order (" + doc + " <= " + lastDoc + " )");
                }
                if (++df % this.skipInterval == 0) {
                    this.skipListWriter.setSkipData(lastDoc, storePayloads, lastPayloadLength);
                    this.skipListWriter.bufferSkip(df);
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq();
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                for (int j = 0; j < freq; ++j) {
                    int position = postings.nextPosition();
                    int delta = position - lastPosition;
                    if (storePayloads) {
                        int payloadLength = postings.getPayloadLength();
                        if (payloadLength == lastPayloadLength) {
                            this.proxOutput.writeVInt(delta * 2);
                        } else {
                            this.proxOutput.writeVInt(delta * 2 + 1);
                            this.proxOutput.writeVInt(payloadLength);
                            lastPayloadLength = payloadLength;
                        }
                        if (payloadLength > 0) {
                            if (this.payloadBuffer == null || this.payloadBuffer.length < payloadLength) {
                                this.payloadBuffer = new byte[payloadLength];
                            }
                            postings.getPayload(this.payloadBuffer, 0);
                            this.proxOutput.writeBytes(this.payloadBuffer, 0, payloadLength);
                        }
                    } else {
                        this.proxOutput.writeVInt(delta);
                    }
                    lastPosition = position;
                }
            }
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms() throws IOException {
        byte[] normBuffer = null;
        IndexOutput output = null;
        try {
            for (int i = 0; i < this.fieldInfos.size(); ++i) {
                FieldInfo fi = this.fieldInfos.fieldInfo(i);
                if (!fi.isIndexed || fi.omitNorms) continue;
                if (output == null) {
                    output = this.directory.createOutput(this.segment + "." + "nrm");
                    output.writeBytes(NORMS_HEADER, NORMS_HEADER.length);
                }
                for (int j = 0; j < this.readers.size(); ++j) {
                    IndexReader reader = (IndexReader)this.readers.elementAt(j);
                    int maxDoc = reader.maxDoc();
                    if (normBuffer == null || normBuffer.length < maxDoc) {
                        normBuffer = new byte[maxDoc];
                    }
                    reader.norms(fi.name, normBuffer, 0);
                    if (!reader.hasDeletions()) {
                        output.writeBytes(normBuffer, maxDoc);
                        continue;
                    }
                    for (int k = 0; k < maxDoc; ++k) {
                        if (reader.isDeleted(k)) continue;
                        output.writeByte(normBuffer[k]);
                    }
                }
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }
}

