/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.versioning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.Restriction;

public class VersionRange {
    private final ArtifactVersion RELEASE = new DefaultArtifactVersion("RELEASE");
    private final ArtifactVersion recommendedVersion;
    private final List restrictions;

    private VersionRange(ArtifactVersion recommendedVersion, List restrictions) {
        this.recommendedVersion = recommendedVersion;
        this.restrictions = restrictions;
    }

    public ArtifactVersion getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public List getRestrictions() {
        return this.restrictions;
    }

    public static VersionRange createFromVersionSpec(String spec) throws InvalidVersionSpecificationException {
        if (spec == null) {
            return null;
        }
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        String process = spec;
        DefaultArtifactVersion version2 = null;
        ArtifactVersion upperBound = null;
        ArtifactVersion lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(")");
            int index = index2 = process.indexOf("]");
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionRange.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.getLowerBound();
            }
            if (upperBound != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(upperBound) < 0)) {
                throw new InvalidVersionSpecificationException("Ranges overlap: " + spec);
            }
            restrictions.add(restriction);
            upperBound = restriction.getUpperBound();
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (restrictions.size() > 0) {
                throw new InvalidVersionSpecificationException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            version2 = new DefaultArtifactVersion(process);
            restrictions.add(Restriction.EVERYTHING);
        }
        return new VersionRange(version2, restrictions);
    }

    private static Restriction parseRestriction(String spec) throws InvalidVersionSpecificationException {
        Restriction restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(",");
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException("Single version must be surrounded by []: " + spec);
            }
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(process);
            restriction = new Restriction(version2, lowerBoundInclusive, version2, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new InvalidVersionSpecificationException("Range cannot have identical boundaries: " + spec);
            }
            DefaultArtifactVersion lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = new DefaultArtifactVersion(lowerBound);
            }
            DefaultArtifactVersion upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = new DefaultArtifactVersion(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new InvalidVersionSpecificationException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }

    public static VersionRange createFromVersion(String version2) {
        return new VersionRange(new DefaultArtifactVersion(version2), Collections.EMPTY_LIST);
    }

    public VersionRange restrict(VersionRange restriction) {
        List r1 = this.restrictions;
        List r2 = restriction.restrictions;
        List restrictions = r1.isEmpty() || r2.isEmpty() ? Collections.EMPTY_LIST : this.intersection(r1, r2);
        ArtifactVersion version2 = null;
        if (restrictions.size() > 0) {
            boolean found = false;
            Iterator i = restrictions.iterator();
            while (i.hasNext() && !found) {
                Restriction r = (Restriction)i.next();
                if (this.recommendedVersion != null && r.containsVersion(this.recommendedVersion)) {
                    version2 = this.recommendedVersion;
                    found = true;
                    continue;
                }
                if (version2 != null || restriction.getRecommendedVersion() == null || !r.containsVersion(restriction.getRecommendedVersion())) continue;
                version2 = restriction.getRecommendedVersion();
            }
        } else if (this.recommendedVersion != null) {
            version2 = this.recommendedVersion;
        }
        return new VersionRange(version2, restrictions);
    }

    private List intersection(List r1, List r2) {
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>(r1.size() + r2.size());
        Iterator i1 = r1.iterator();
        Iterator i2 = r2.iterator();
        Restriction res1 = (Restriction)i1.next();
        Restriction res2 = (Restriction)i2.next();
        boolean done = false;
        while (!done) {
            if (res1.getLowerBound() == null || res2.getUpperBound() == null || res1.getLowerBound().compareTo(res2.getUpperBound()) <= 0) {
                if (res1.getUpperBound() == null || res2.getLowerBound() == null || res1.getUpperBound().compareTo(res2.getLowerBound()) >= 0) {
                    boolean upperInclusive;
                    ArtifactVersion upper;
                    int comparison;
                    boolean lowerInclusive;
                    ArtifactVersion lower;
                    if (res1.getLowerBound() == null) {
                        lower = res2.getLowerBound();
                        lowerInclusive = res2.isLowerBoundInclusive();
                    } else if (res2.getLowerBound() == null) {
                        lower = res1.getLowerBound();
                        lowerInclusive = res1.isLowerBoundInclusive();
                    } else {
                        comparison = res1.getLowerBound().compareTo(res2.getLowerBound());
                        if (comparison < 0) {
                            lower = res2.getLowerBound();
                            lowerInclusive = res2.isLowerBoundInclusive();
                        } else if (comparison == 0) {
                            lower = res1.getLowerBound();
                            lowerInclusive = res1.isLowerBoundInclusive() && res2.isLowerBoundInclusive();
                        } else {
                            lower = res1.getLowerBound();
                            lowerInclusive = res1.isLowerBoundInclusive();
                        }
                    }
                    if (res1.getUpperBound() == null) {
                        upper = res2.getUpperBound();
                        upperInclusive = res2.isUpperBoundInclusive();
                    } else if (res2.getUpperBound() == null) {
                        upper = res1.getUpperBound();
                        upperInclusive = res1.isUpperBoundInclusive();
                    } else {
                        comparison = res1.getUpperBound().compareTo(res2.getUpperBound());
                        if (comparison < 0) {
                            upper = res1.getUpperBound();
                            upperInclusive = res1.isUpperBoundInclusive();
                        } else if (comparison == 0) {
                            upper = res1.getUpperBound();
                            upperInclusive = res1.isUpperBoundInclusive() && res2.isUpperBoundInclusive();
                        } else {
                            upper = res2.getUpperBound();
                            upperInclusive = res2.isUpperBoundInclusive();
                        }
                    }
                    if (lower == null || upper == null || lower.compareTo(upper) != 0) {
                        restrictions.add(new Restriction(lower, lowerInclusive, upper, upperInclusive));
                    } else if (lowerInclusive && upperInclusive) {
                        restrictions.add(new Restriction(lower, lowerInclusive, upper, upperInclusive));
                    }
                    if (upper == res2.getUpperBound()) {
                        if (i2.hasNext()) {
                            res2 = (Restriction)i2.next();
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    if (i1.hasNext()) {
                        res1 = (Restriction)i1.next();
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (i1.hasNext()) {
                    res1 = (Restriction)i1.next();
                    continue;
                }
                done = true;
                continue;
            }
            if (i2.hasNext()) {
                res2 = (Restriction)i2.next();
                continue;
            }
            done = true;
        }
        return restrictions;
    }

    public ArtifactVersion getSelectedVersion(Artifact artifact) throws OverConstrainedVersionException {
        ArtifactVersion version2;
        if (this.recommendedVersion != null) {
            version2 = this.recommendedVersion;
        } else {
            if (this.restrictions.size() == 0) {
                throw new OverConstrainedVersionException("The artifact has no valid ranges", artifact);
            }
            Restriction restriction = (Restriction)this.restrictions.get(this.restrictions.size() - 1);
            version2 = restriction.getUpperBound();
            if (version2 == null) {
                version2 = this.RELEASE;
            }
        }
        return version2;
    }

    public boolean isSelectedVersionKnown(Artifact artifact) throws OverConstrainedVersionException {
        boolean value = false;
        if (this.recommendedVersion != null) {
            value = true;
        } else {
            if (this.restrictions.size() == 0) {
                throw new OverConstrainedVersionException("The artifact has no valid ranges", artifact);
            }
            Restriction restriction = (Restriction)this.restrictions.get(this.restrictions.size() - 1);
            if (restriction.getUpperBound() != null) {
                value = restriction.isUpperBoundInclusive();
            }
        }
        return value;
    }

    public String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction r = (Restriction)i.next();
            buf.append(r.isLowerBoundInclusive() ? "[" : "(");
            if (r.getLowerBound() != null) {
                buf.append(r.getLowerBound().toString());
            }
            buf.append(",");
            if (r.getUpperBound() != null) {
                buf.append(r.getUpperBound().toString());
            }
            buf.append(r.isUpperBoundInclusive() ? "]" : ")");
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public ArtifactVersion matchVersion(List versions) {
        ArtifactVersion matched = null;
        Iterator i = versions.iterator();
        while (i.hasNext()) {
            ArtifactVersion version2 = (ArtifactVersion)i.next();
            if (!this.containsVersion(version2) || matched != null && version2.compareTo(matched) <= 0) continue;
            matched = version2;
        }
        return matched;
    }

    public boolean containsVersion(ArtifactVersion version2) {
        boolean matched = false;
        Iterator i = this.restrictions.iterator();
        while (i.hasNext() && !matched) {
            Restriction restriction = (Restriction)i.next();
            if (!restriction.containsVersion(version2)) continue;
            matched = true;
        }
        return matched;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty() && this.recommendedVersion == null;
    }
}

