/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RegexBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.|env\\.)?([^}]+)\\}");
    private Properties envars;

    public RegexBasedModelInterpolator(Properties envars) {
        this.envars = envars;
    }

    public RegexBasedModelInterpolator() throws IOException {
        this.envars = CommandLineUtils.getSystemEnvVars();
    }

    public Model interpolate(Model model, Map context) throws ModelInterpolationException {
        return this.interpolate(model, context, true);
    }

    public Model interpolate(Model model, Map context, boolean strict) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write(sWriter, model);
        }
        catch (IOException e2) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e2);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolateInternal(serializedModel, model, context);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read(sReader);
        }
        catch (IOException e3) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e3);
        }
        catch (XmlPullParserException e4) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e4);
        }
        return model;
    }

    private String interpolateInternal(String src, Model model, Map context) throws ModelInterpolationException {
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            Object value;
            String realExpr;
            String wholeExpr;
            block7: {
                wholeExpr = matcher.group(0);
                realExpr = matcher.group(2);
                value = context.get(realExpr);
                if (value == null) {
                    if (context.containsKey(realExpr)) continue;
                    value = model.getProperties().getProperty(realExpr);
                }
                if (value == null) {
                    try {
                        value = ReflectionValueExtractor.evaluate((String)realExpr, (Object)model, (boolean)false);
                    }
                    catch (Exception e2) {
                        Logger logger = this.getLogger();
                        if (logger == null) break block7;
                        logger.debug("POM interpolation cannot proceed with expression: " + wholeExpr + ". Skipping...", e2);
                    }
                }
            }
            if (value == null) {
                value = this.envars.getProperty(realExpr);
            }
            if (String.valueOf(value).indexOf(wholeExpr) > -1) {
                throw new ModelInterpolationException(wholeExpr, "Expression value '" + value + "' references itself in '" + model.getId() + "'.");
            }
            if (value == null) continue;
            result = StringUtils.replace(result, wholeExpr, String.valueOf(value));
            matcher.reset(result);
        }
        return result;
    }
}

