/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class VMParamsAllAndReadonlyDigestZkACLProvider
extends DefaultZkACLProvider {
    public static final String DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME = "zkDigestReadonlyUsername";
    public static final String DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME = "zkDigestReadonlyPassword";
    final String zkDigestAllUsernameVMParamName;
    final String zkDigestAllPasswordVMParamName;
    final String zkDigestReadonlyUsernameVMParamName;
    final String zkDigestReadonlyPasswordVMParamName;

    public VMParamsAllAndReadonlyDigestZkACLProvider() {
        this("zkDigestUsername", "zkDigestPassword", DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME);
    }

    public VMParamsAllAndReadonlyDigestZkACLProvider(String zkDigestAllUsernameVMParamName, String zkDigestAllPasswordVMParamName, String zkDigestReadonlyUsernameVMParamName, String zkDigestReadonlyPasswordVMParamName) {
        this.zkDigestAllUsernameVMParamName = zkDigestAllUsernameVMParamName;
        this.zkDigestAllPasswordVMParamName = zkDigestAllPasswordVMParamName;
        this.zkDigestReadonlyUsernameVMParamName = zkDigestReadonlyUsernameVMParamName;
        this.zkDigestReadonlyPasswordVMParamName = zkDigestReadonlyPasswordVMParamName;
    }

    @Override
    protected List<ACL> createGlobalACLsToAdd() {
        try {
            List<ACL> result = new ArrayList<ACL>();
            String digestAllUsername = System.getProperty(this.zkDigestAllUsernameVMParamName);
            String digestAllPassword = System.getProperty(this.zkDigestAllPasswordVMParamName);
            if (!StringUtils.isEmpty(digestAllUsername) && !StringUtils.isEmpty(digestAllPassword)) {
                result.add(new ACL(31, new Id("digest", DigestAuthenticationProvider.generateDigest(digestAllUsername + ":" + digestAllPassword))));
            }
            String digestReadonlyUsername = System.getProperty(this.zkDigestReadonlyUsernameVMParamName);
            String digestReadonlyPassword = System.getProperty(this.zkDigestReadonlyPasswordVMParamName);
            if (!StringUtils.isEmpty(digestReadonlyUsername) && !StringUtils.isEmpty(digestReadonlyPassword)) {
                result.add(new ACL(1, new Id("digest", DigestAuthenticationProvider.generateDigest(digestReadonlyUsername + ":" + digestReadonlyPassword))));
            }
            if (result.isEmpty()) {
                result = super.createGlobalACLsToAdd();
            }
            return result;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }
}

