/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.cn.ldap.NodePropertyAccess;
import org.dataone.cn.ldap.NodeServicesAccess;
import org.dataone.cn.ldap.ServiceMethodRestrictionsAccess;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeReplicationPolicy;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Ping;
import org.dataone.service.types.v1.Schedule;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.ServiceMethodRestriction;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.Synchronization;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.Property;
import org.dataone.service.util.DateTimeMarshaller;

public class NodeAccess
extends LDAPService {
    public static Log log = LogFactory.getLog(NodeAccess.class);
    public static final String DEFAULT_NON_HARVEST_DATE = "1900-01-01T00:00:00Z";
    public static final String NODE_APPROVED = "d1NodeApproved";
    public static final String LOG_LAST_AGGREGATED = "d1NodeLogLastAggregated";
    public static final String AGGREGATE_LOGS = "d1NodeAggregateLogs";
    public static final String NODE_ID = "d1NodeId";
    public static final String NODE_NAME = "d1NodeName";
    public static final String NODE_DESCRIPTION = "d1NodeDescription";
    public static final String NODE_BASEURL = "d1NodeBaseURL";
    public static final String SYNC_SCHEDULE_SEC = "d1NodeSynSchdSec";
    public static final String SYNC_SCHEDULE_MIN = "d1NodeSynSchdMin";
    public static final String SYNC_SCHEDULE_HOUR = "d1NodeSynSchdHour";
    public static final String SYNC_SCHEDULE_MDAY = "d1NodeSynSchdMday";
    public static final String SYNC_SCHEDULE_MON = "d1NodeSynSchdMon";
    public static final String SYNC_SCHEDULE_WDAY = "d1NodeSynSchdWday";
    public static final String SYNC_SCHEDULE_YEAR = "d1NodeSynSchdYear";
    public static final String NODE_LAST_HARVESTED = "d1NodeLastHarvested";
    public static final String NODE_LAST_COMPLETE_HARVEST = "d1NodeLastCompleteHarvest";
    public static final String REP_POLICY_MAXOBJECTSIZE = "d1ReplicationPolicyMaxObjectSize";
    public static final String REP_POLICY_SPACEALLOCATED = "d1ReplicationPolicySpaceAllocated";
    public static final String REP_POLICY_ALLOWEDNODE = "d1ReplicationPolicyAllowedNode";
    public static final String REP_POLICY_ALLOWEDOBJECTFORMAT = "d1ReplicationPolicyAllowedObjectFormat";
    public static final String PING_SUCCESS = "d1NodePingSuccess";
    public static final String PING_DATE_CHECKED = "d1NodePingDateChecked";
    public static final String NODE_SUBJECT = "subject";
    public static final String NODE_CONTACT_SUBJECT = "d1NodeContactSubject";
    public static final String NODE_REPLICATE = "d1NodeReplicate";
    public static final String NODE_SYNCHRONIZE = "d1NodeSynchronize";
    public static final String NODE_TYPE = "d1NodeType";
    public static final String NODE_STATE = "d1NodeState";
    private static NodeServicesAccess nodeServicesAccess = new NodeServicesAccess();
    private static NodePropertyAccess nodePropertyAccess = new NodePropertyAccess();
    private static ServiceMethodRestrictionsAccess serviceMethodRestrictionsAccess = new ServiceMethodRestrictionsAccess();

    public NodeAccess() {
        this.setBase(Settings.getConfiguration().getString("nodeRegistry.ldap.base"));
    }

    protected Boolean deleteNode(DirContext ctx, NodeReference nodeReference) throws ServiceFailure {
        return super.removeEntry(ctx, this.buildNodeDN(nodeReference));
    }

    protected List<Node> getApprovedNodeList(DirContext ctx) throws ServiceFailure {
        ArrayList<Node> allNode = new ArrayList<Node>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            log.trace("BASE: " + this.getBase());
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), "(&(objectClass=d1Node)(d1NodeApproved=TRUE))", ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                log.trace("Search result found for: " + nodeDn);
                HashMap attributesMap = new HashMap();
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID().toLowerCase();
                    NamingEnumeration<?> attributeValue = attribute.getAll();
                    attributesMap.put(attributeName, attributeValue);
                }
                allNode.add(this.mapBasicNodeProperties(attributesMap, new Node()));
                values.close();
            }
            results.close();
        }
        catch (CommunicationException ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            log.error("Problem searching Approved Nodes for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return allNode;
    }

    protected Date getDateLastHarvested(DirContext ctx, NodeReference nodeReference) throws ServiceFailure {
        Date logLastAggregated = null;
        try {
            HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(ctx, nodeReference);
            if (attributesMap.containsKey(NODE_LAST_HARVESTED.toLowerCase())) {
                logLastAggregated = DateTimeMarshaller.deserializeDateToUTC(this.getEnumerationValueString(attributesMap.get(NODE_LAST_HARVESTED.toLowerCase())));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem retrieving " + NODE_LAST_HARVESTED.toLowerCase() + " of " + nodeReference.getValue(), e2);
            throw new ServiceFailure("4801", "Could retrieve " + NODE_LAST_HARVESTED.toLowerCase() + " from: " + nodeReference.getValue() + " " + e2.getMessage());
        }
        return logLastAggregated;
    }

    protected Date getLogLastAggregated(DirContext ctx, NodeReference nodeReference) throws ServiceFailure {
        Date logLastAggregated = null;
        try {
            HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(ctx, nodeReference);
            if (attributesMap.containsKey(LOG_LAST_AGGREGATED.toLowerCase())) {
                logLastAggregated = DateTimeMarshaller.deserializeDateToUTC(this.getEnumerationValueString(attributesMap.get(LOG_LAST_AGGREGATED.toLowerCase())));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem retrieving " + LOG_LAST_AGGREGATED.toLowerCase() + " of " + nodeReference.getValue(), e2);
            throw new ServiceFailure("4801", "Could retrieve " + LOG_LAST_AGGREGATED.toLowerCase() + " from: " + nodeReference.getValue() + " " + e2.getMessage());
        }
        return logLastAggregated;
    }

    protected Node getNode(DirContext dirContext, NodeReference nodeReference) throws NotFound, NamingException, NameNotFoundException {
        HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(dirContext, nodeReference);
        log.debug("Retrieved Node for: " + nodeReference.getValue());
        if (attributesMap.isEmpty()) {
            throw new NotFound("4801", nodeReference.getValue() + " not found on the server");
        }
        return this.mapBasicNodeProperties(attributesMap, new Node());
    }

    protected Node getApprovedNode(DirContext ctx, NodeReference nodeReference) throws ServiceFailure, NotFound {
        HashMap<String, NamingEnumeration<?>> attributesMap;
        Boolean nodeApproved = false;
        try {
            attributesMap = this.buildNodeAttributeMap(ctx, nodeReference);
        }
        catch (NameNotFoundException e2) {
            throw new NotFound("4801", nodeReference.getValue() + " not found on the server");
        }
        catch (Exception e3) {
            e3.printStackTrace();
            log.error("buildNodeAttributeMap- Problem determining approved state " + nodeReference.getValue(), e3);
            throw new ServiceFailure("4801", "buildNodeAttributeMap- Could not determine approved state of : " + nodeReference.getValue() + " " + e3.getMessage());
        }
        if (attributesMap.isEmpty()) {
            throw new NotFound("4801", nodeReference.getValue() + " not found on the server");
        }
        if (attributesMap.containsKey(NODE_APPROVED.toLowerCase())) {
            try {
                nodeApproved = Boolean.valueOf(this.getEnumerationValueString(attributesMap.get(NODE_APPROVED.toLowerCase())));
            }
            catch (Exception e4) {
                e4.printStackTrace();
                log.error("getEnumerationValueString- Problem determining approved state " + nodeReference.getValue(), e4);
                throw new ServiceFailure("4801", "getEnumerationValueString- Could not determine approved state of : " + nodeReference.getValue() + " " + e4.getMessage());
            }
        } else {
            log.error("attributesMap.containsKey- Problem determining approved state " + nodeReference.getValue());
            throw new ServiceFailure("4801", "attributesMap.containsKey- Could not determine approved state of : " + nodeReference.getValue());
        }
        if (!nodeApproved.booleanValue()) {
            throw new NotFound("4801", nodeReference.getValue() + " not approved on the server");
        }
        try {
            return this.mapBasicNodeProperties(attributesMap, new Node());
        }
        catch (NameNotFoundException ex) {
            log.warn("Node not found: " + nodeReference.getValue());
            throw new NotFound("4842", ex.getMessage());
        }
        catch (NamingException ex) {
            throw new ServiceFailure("4842", ex.getMessage());
        }
    }

    protected Boolean getNodeApproved(DirContext ctx, NodeReference nodeReference) throws ServiceFailure {
        Boolean nodeApproved = false;
        try {
            HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(ctx, nodeReference);
            if (attributesMap.containsKey(NODE_APPROVED.toLowerCase())) {
                String nodeApprovedStr = this.getEnumerationValueString(attributesMap.get(NODE_APPROVED.toLowerCase()));
                nodeApproved = Boolean.valueOf(nodeApprovedStr.toLowerCase());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem determining approved state " + nodeReference.getValue(), e2);
            throw new ServiceFailure("4801", "Could not determine approved state of : " + nodeReference.getValue() + " " + e2.getMessage());
        }
        return nodeApproved;
    }

    protected Map<String, String> getNodeIdList(DirContext ctx) throws ServiceFailure {
        HashMap<String, String> allNodeIds = new HashMap<String, String>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), "(objectClass=d1Node)", ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                log.trace("Search result found for: " + nodeDn);
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                String nodeId = null;
                String nodeBaseUrl = null;
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    if (attributeName.equalsIgnoreCase(NODE_ID)) {
                        nodeId = (String)attribute.get();
                    }
                    if (!attributeName.equalsIgnoreCase(NODE_BASEURL)) continue;
                    nodeBaseUrl = (String)attribute.get();
                }
                allNodeIds.put(nodeId, nodeBaseUrl);
            }
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem search Nodes for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return allNodeIds;
    }

    protected List<NodeReference> getPendingNodeReferenceList(DirContext ctx) throws ServiceFailure {
        ArrayList<NodeReference> allNodeIds = new ArrayList<NodeReference>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), "(&(objectClass=d1Node)(d1NodeApproved=FALSE))", ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                log.trace("Search result found for: " + nodeDn);
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    if (!attributeName.equalsIgnoreCase(NODE_ID)) continue;
                    NodeReference nodeId = new NodeReference();
                    nodeId.setValue((String)attribute.get());
                    allNodeIds.add(nodeId);
                }
            }
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem search Pending Nodes for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return allNodeIds;
    }

    protected Boolean getAggregateLogs(DirContext ctx, NodeReference nodeReference) throws ServiceFailure {
        Boolean aggregateLogs = true;
        try {
            HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(ctx, nodeReference);
            if (attributesMap.containsKey(AGGREGATE_LOGS.toLowerCase())) {
                aggregateLogs = Boolean.valueOf(this.getEnumerationValueString(attributesMap.get(AGGREGATE_LOGS.toLowerCase())));
                log.debug("aggregateLogsString is " + aggregateLogs);
            } else {
                String dnNodeIdentifier = this.buildNodeDN(nodeReference);
                BasicAttribute d1NodeAggregateLogs = new BasicAttribute(AGGREGATE_LOGS, Boolean.toString(aggregateLogs).toUpperCase());
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, d1NodeAggregateLogs)};
                ctx.modifyAttributes(dnNodeIdentifier, mods);
                log.debug("Initialize Aggregate Logs: " + dnNodeIdentifier);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem determining processing state " + nodeReference.getValue() + " of attribute" + AGGREGATE_LOGS, e2);
            throw new ServiceFailure("4801", "Could not determine state of : " + nodeReference.getValue() + " of attribute " + AGGREGATE_LOGS + " " + e2.getMessage());
        }
        return aggregateLogs;
    }

    private String buildNodeDN(NodeReference nodeReference) {
        return "cn=" + nodeReference.getValue() + ",dc=dataone,dc=org";
    }

    private HashMap<String, NamingEnumeration<?>> buildNodeAttributeMap(DirContext ctx, NodeReference nodeReference) throws NamingException {
        HashMap attributesMap = new HashMap();
        String nodeDN = this.buildNodeDN(nodeReference);
        Attributes attributes = ctx.getAttributes(nodeDN);
        NamingEnumeration<? extends Attribute> values = attributes.getAll();
        while (values.hasMore()) {
            Attribute attribute = values.next();
            String attributeName = attribute.getID().toLowerCase();
            NamingEnumeration<?> attributeValue = attribute.getAll();
            attributesMap.put(attributeName, attributeValue);
        }
        return attributesMap;
    }

    private Node mapBasicNodeProperties(HashMap<String, NamingEnumeration<?>> attributesMap, Node node) throws NamingException {
        String standardizedName;
        X500Principal principal2;
        if (attributesMap.containsKey(NODE_ID.toLowerCase())) {
            NodeReference nodeReference = new NodeReference();
            nodeReference.setValue(this.getEnumerationValueString(attributesMap.get(NODE_ID.toLowerCase())));
            node.setIdentifier(nodeReference);
        }
        if (attributesMap.containsKey(NODE_NAME.toLowerCase())) {
            node.setName(this.getEnumerationValueString(attributesMap.get(NODE_NAME.toLowerCase())));
        }
        if (attributesMap.containsKey(NODE_BASEURL.toLowerCase())) {
            node.setBaseURL(this.getEnumerationValueString(attributesMap.get(NODE_BASEURL.toLowerCase())));
        }
        if (attributesMap.containsKey(NODE_DESCRIPTION.toLowerCase())) {
            node.setDescription(this.getEnumerationValueString(attributesMap.get(NODE_DESCRIPTION.toLowerCase())));
        }
        if (attributesMap.containsKey(NODE_SUBJECT.toLowerCase())) {
            NamingEnumeration<?> subjects = attributesMap.get(NODE_SUBJECT.toLowerCase());
            while (subjects.hasMore()) {
                Subject nodeSubject = new Subject();
                String subjectValue = (String)subjects.next();
                nodeSubject.setValue(subjectValue);
                try {
                    principal2 = new X500Principal(subjectValue);
                    standardizedName = principal2.getName("RFC2253");
                    nodeSubject.setValue(standardizedName);
                }
                catch (IllegalArgumentException principal2) {
                    // empty catch block
                }
                node.addSubject(nodeSubject);
            }
        }
        if (attributesMap.containsKey(NODE_CONTACT_SUBJECT.toLowerCase())) {
            NamingEnumeration<?> contactSubjects = attributesMap.get(NODE_CONTACT_SUBJECT.toLowerCase());
            while (contactSubjects.hasMore()) {
                Subject nodeContactSubject = new Subject();
                String contactSubjectValue = (String)contactSubjects.next();
                nodeContactSubject.setValue(contactSubjectValue);
                try {
                    principal2 = new X500Principal(contactSubjectValue);
                    standardizedName = principal2.getName("RFC2253");
                    nodeContactSubject.setValue(standardizedName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                node.addContactSubject(nodeContactSubject);
            }
        }
        if (attributesMap.containsKey(NODE_REPLICATE.toLowerCase())) {
            node.setReplicate(Boolean.valueOf(this.getEnumerationValueString(attributesMap.get(NODE_REPLICATE.toLowerCase()))));
        }
        if (attributesMap.containsKey(NODE_SYNCHRONIZE.toLowerCase())) {
            node.setSynchronize(Boolean.valueOf(this.getEnumerationValueString(attributesMap.get(NODE_SYNCHRONIZE.toLowerCase()))));
        }
        if (attributesMap.containsKey(NODE_STATE.toLowerCase())) {
            node.setState(NodeState.convert(this.getEnumerationValueString(attributesMap.get(NODE_STATE.toLowerCase()))));
        }
        if (attributesMap.containsKey(NODE_TYPE.toLowerCase())) {
            node.setType(NodeType.convert(this.getEnumerationValueString(attributesMap.get(NODE_TYPE.toLowerCase()))));
            if (node.getType().compareTo(NodeType.MN) == 0) {
                log.trace("found a Membernode");
                if (attributesMap.containsKey(SYNC_SCHEDULE_SEC.toLowerCase())) {
                    Synchronization synchronization = new Synchronization();
                    Schedule schedule = new Schedule();
                    schedule.setSec(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_SEC.toLowerCase())));
                    schedule.setMin(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_MIN.toLowerCase())));
                    schedule.setHour(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_HOUR.toLowerCase())));
                    schedule.setMday(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_MDAY.toLowerCase())));
                    schedule.setMon(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_MON.toLowerCase())));
                    schedule.setWday(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_WDAY.toLowerCase())));
                    schedule.setYear(this.getEnumerationValueString(attributesMap.get(SYNC_SCHEDULE_YEAR.toLowerCase())));
                    synchronization.setSchedule(schedule);
                    synchronization.setLastHarvested(DateTimeMarshaller.deserializeDateToUTC(this.getEnumerationValueString(attributesMap.get(NODE_LAST_HARVESTED.toLowerCase()))));
                    synchronization.setLastCompleteHarvest(DateTimeMarshaller.deserializeDateToUTC(this.getEnumerationValueString(attributesMap.get(NODE_LAST_COMPLETE_HARVEST.toLowerCase()))));
                    node.setSynchronization(synchronization);
                }
                if (attributesMap.containsKey(PING_SUCCESS.toLowerCase())) {
                    Ping ping = new Ping();
                    ping.setSuccess(Boolean.valueOf(this.getEnumerationValueString(attributesMap.get(PING_SUCCESS.toLowerCase()))));
                    ping.setLastSuccess(DateTimeMarshaller.deserializeDateToUTC(this.getEnumerationValueString(attributesMap.get(PING_DATE_CHECKED.toLowerCase()))));
                    node.setPing(ping);
                }
                NodeReplicationPolicy nrp = null;
                if (attributesMap.containsKey(REP_POLICY_MAXOBJECTSIZE.toLowerCase())) {
                    if (nrp == null) {
                        nrp = new NodeReplicationPolicy();
                    }
                    nrp.setMaxObjectSize(new BigInteger(this.getEnumerationValueString(attributesMap.get(REP_POLICY_MAXOBJECTSIZE.toLowerCase()))));
                }
                if (attributesMap.containsKey(REP_POLICY_SPACEALLOCATED.toLowerCase())) {
                    if (nrp == null) {
                        nrp = new NodeReplicationPolicy();
                    }
                    nrp.setSpaceAllocated(new BigInteger(this.getEnumerationValueString(attributesMap.get(REP_POLICY_SPACEALLOCATED.toLowerCase()))));
                }
                if (attributesMap.containsKey(REP_POLICY_ALLOWEDNODE.toLowerCase())) {
                    if (nrp == null) {
                        nrp = new NodeReplicationPolicy();
                    }
                    NamingEnumeration<?> allowedNodes = attributesMap.get(REP_POLICY_ALLOWEDNODE.toLowerCase());
                    while (allowedNodes.hasMore()) {
                        NodeReference nr = new NodeReference();
                        nr.setValue((String)allowedNodes.next());
                        nrp.addAllowedNode(nr);
                    }
                }
                if (attributesMap.containsKey(REP_POLICY_ALLOWEDOBJECTFORMAT.toLowerCase())) {
                    if (nrp == null) {
                        nrp = new NodeReplicationPolicy();
                    }
                    NamingEnumeration<?> allowedFormats = attributesMap.get(REP_POLICY_ALLOWEDOBJECTFORMAT.toLowerCase());
                    while (allowedFormats.hasMore()) {
                        ObjectFormatIdentifier formatid = new ObjectFormatIdentifier();
                        formatid.setValue((String)allowedFormats.next());
                        nrp.addAllowedObjectFormat(formatid);
                    }
                }
                if (nrp != null) {
                    node.setNodeReplicationPolicy(nrp);
                }
            }
        }
        return node;
    }

    protected Attributes mapNodeAttributes(Node node) {
        NodeReplicationPolicy nrp;
        BasicAttribute contactSubjects;
        BasicAttributes nodeAttributes = new BasicAttributes(true);
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("device");
        objClasses.add("d1Node");
        nodeAttributes.put(objClasses);
        nodeAttributes.put(new BasicAttribute("cn", node.getIdentifier().getValue()));
        nodeAttributes.put(new BasicAttribute(NODE_ID, node.getIdentifier().getValue()));
        nodeAttributes.put(new BasicAttribute(NODE_NAME, node.getName()));
        nodeAttributes.put(new BasicAttribute(NODE_DESCRIPTION, node.getDescription()));
        nodeAttributes.put(new BasicAttribute(NODE_BASEURL, node.getBaseURL()));
        nodeAttributes.put(new BasicAttribute(NODE_REPLICATE, Boolean.toString(node.isReplicate()).toUpperCase()));
        nodeAttributes.put(new BasicAttribute(NODE_SYNCHRONIZE, Boolean.toString(node.isSynchronize()).toUpperCase()));
        nodeAttributes.put(new BasicAttribute(NODE_TYPE, node.getType().xmlValue()));
        nodeAttributes.put(new BasicAttribute(NODE_STATE, node.getState().xmlValue()));
        nodeAttributes.put(new BasicAttribute(NODE_APPROVED, Boolean.toString(Boolean.FALSE).toUpperCase()));
        if (node.getSubjectList() != null && !node.getSubjectList().isEmpty()) {
            BasicAttribute subjects = new BasicAttribute(NODE_SUBJECT);
            for (Subject subject : node.getSubjectList()) {
                subjects.add(subject.getValue());
            }
            nodeAttributes.put(subjects);
        }
        if (node.getContactSubjectList() != null && !node.getContactSubjectList().isEmpty()) {
            contactSubjects = new BasicAttribute(NODE_CONTACT_SUBJECT);
            for (Subject contactSubject : node.getContactSubjectList()) {
                contactSubjects.add(contactSubject.getValue());
            }
        } else {
            throw new NullPointerException("ContactSubjectList may not be null or empty");
        }
        nodeAttributes.put(contactSubjects);
        if (node.getType().compareTo(NodeType.MN) == 0 && node.getSynchronization() != null) {
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_SEC, node.getSynchronization().getSchedule().getSec()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_MIN, node.getSynchronization().getSchedule().getMin()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_HOUR, node.getSynchronization().getSchedule().getHour()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_MDAY, node.getSynchronization().getSchedule().getMday()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_MON, node.getSynchronization().getSchedule().getMon()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_WDAY, node.getSynchronization().getSchedule().getWday()));
            nodeAttributes.put(new BasicAttribute(SYNC_SCHEDULE_YEAR, node.getSynchronization().getSchedule().getYear()));
            nodeAttributes.put(new BasicAttribute(NODE_LAST_HARVESTED, DEFAULT_NON_HARVEST_DATE));
            nodeAttributes.put(new BasicAttribute(NODE_LAST_COMPLETE_HARVEST, DEFAULT_NON_HARVEST_DATE));
        }
        if ((nrp = node.getNodeReplicationPolicy()) != null) {
            if (nrp.getMaxObjectSize() != null) {
                nodeAttributes.put(new BasicAttribute(REP_POLICY_MAXOBJECTSIZE, nrp.getMaxObjectSize().toString()));
            }
            if (nrp.getSpaceAllocated() != null) {
                nodeAttributes.put(new BasicAttribute(REP_POLICY_SPACEALLOCATED, nrp.getSpaceAllocated().toString()));
            }
            if (nrp.getAllowedNodeList() != null && !nrp.getAllowedNodeList().isEmpty()) {
                BasicAttribute allowedNodes = new BasicAttribute(REP_POLICY_ALLOWEDNODE);
                for (NodeReference nr : nrp.getAllowedNodeList()) {
                    allowedNodes.add(nr.getValue());
                }
                nodeAttributes.put(allowedNodes);
            }
            if (nrp.getAllowedObjectFormatList() != null && !nrp.getAllowedObjectFormatList().isEmpty()) {
                BasicAttribute allowedFormats = new BasicAttribute(REP_POLICY_ALLOWEDOBJECTFORMAT);
                for (ObjectFormatIdentifier formatid : nrp.getAllowedObjectFormatList()) {
                    allowedFormats.add(formatid.getValue());
                }
                nodeAttributes.put(allowedFormats);
            }
        }
        return nodeAttributes;
    }

    private List<ModificationItem> mapNodeModificationItemList(HashMap<String, NamingEnumeration<?>> attributesMap, Node node) throws NamingException {
        ArrayList<ModificationItem> modificationItemList = new ArrayList<ModificationItem>();
        modificationItemList.addAll(this.calcModifications(NODE_NAME, attributesMap, node.getName()));
        modificationItemList.addAll(this.calcModifications(NODE_BASEURL, attributesMap, node.getBaseURL()));
        modificationItemList.addAll(this.calcModifications(NODE_DESCRIPTION, attributesMap, node.getDescription()));
        modificationItemList.addAll(this.calcSubjectListModifications(NODE_SUBJECT, attributesMap, node.getSubjectList()));
        modificationItemList.addAll(this.calcSubjectListModifications(NODE_CONTACT_SUBJECT, attributesMap, node.getContactSubjectList()));
        modificationItemList.addAll(this.calcModifications(NODE_REPLICATE, attributesMap, String.valueOf(node.isReplicate()).toUpperCase()));
        modificationItemList.addAll(this.calcModifications(NODE_SYNCHRONIZE, attributesMap, String.valueOf(node.isSynchronize()).toUpperCase()));
        modificationItemList.addAll(this.calcModifications(NODE_STATE, attributesMap, String.valueOf(node.getState().xmlValue())));
        if (attributesMap.containsKey(NODE_TYPE.toLowerCase())) {
            NodeType nodeType = NodeType.convert(this.getEnumerationValueString(attributesMap.get(NODE_TYPE.toLowerCase())));
            if (nodeType.compareTo(NodeType.MN) == 0) {
                log.trace("found a Membernode");
                if (attributesMap.containsKey(SYNC_SCHEDULE_SEC.toLowerCase()) && node.getSynchronization() == null) {
                    log.error("Unable to remove Synchronization for " + node.getIdentifier().getValue());
                } else {
                    Schedule newSchedule = node.getSynchronization().getSchedule();
                    log.warn(String.format("%s-%s-%s-%s-%s-%s-%s", newSchedule.getWday(), newSchedule.getYear(), newSchedule.getMon(), newSchedule.getMday(), newSchedule.getHour(), newSchedule.getMin(), newSchedule.getSec()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_SEC, attributesMap, newSchedule.getSec()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_MIN, attributesMap, newSchedule.getMin()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_HOUR, attributesMap, newSchedule.getHour()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_MDAY, attributesMap, newSchedule.getMday()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_MON, attributesMap, newSchedule.getMon()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_WDAY, attributesMap, newSchedule.getWday()));
                    modificationItemList.addAll(this.calcModifications(SYNC_SCHEDULE_YEAR, attributesMap, newSchedule.getYear()));
                }
                if (!attributesMap.containsKey(NODE_LAST_HARVESTED.toLowerCase()) && node.getSynchronization() != null) {
                    BasicAttribute d1NodeLastHarvested = new BasicAttribute(NODE_LAST_HARVESTED, DEFAULT_NON_HARVEST_DATE);
                    modificationItemList.add(new ModificationItem(1, d1NodeLastHarvested));
                    BasicAttribute d1NodeLastCompleteHarvest = new BasicAttribute(NODE_LAST_COMPLETE_HARVEST, DEFAULT_NON_HARVEST_DATE);
                    modificationItemList.add(new ModificationItem(1, d1NodeLastCompleteHarvest));
                }
            }
            if (node.getNodeReplicationPolicy() != null) {
                NodeReplicationPolicy rp = node.getNodeReplicationPolicy();
                modificationItemList.addAll(this.calcModifications(REP_POLICY_MAXOBJECTSIZE, attributesMap, rp.getMaxObjectSize() == null ? null : rp.getMaxObjectSize().toString()));
                modificationItemList.addAll(this.calcModifications(REP_POLICY_SPACEALLOCATED, attributesMap, rp.getSpaceAllocated() == null ? null : rp.getSpaceAllocated().toString()));
                modificationItemList.addAll(this.calcListModifications(REP_POLICY_ALLOWEDNODE, attributesMap, rp.getAllowedNodeList() == null ? null : CollectionUtils.collect(rp.getAllowedNodeList(), new Transformer(){

                    @Override
                    public Object transform(Object o) {
                        return ((NodeReference)o).getValue();
                    }
                })));
                modificationItemList.addAll(this.calcListModifications(REP_POLICY_ALLOWEDOBJECTFORMAT, attributesMap, rp.getAllowedObjectFormatList() == null ? null : CollectionUtils.collect(rp.getAllowedObjectFormatList(), new Transformer(){

                    @Override
                    public Object transform(Object o) {
                        return ((ObjectFormatIdentifier)o).getValue();
                    }
                })));
            }
        }
        return modificationItemList;
    }

    protected void setDateLastHarvested(DirContext ctx, NodeReference nodeIdentifier, Date lastDateNodeHarvested) throws ServiceFailure {
        try {
            String dnNodeIdentifier = "cn=" + nodeIdentifier.getValue() + ",dc=dataone,dc=org";
            BasicAttribute d1NodeLastHarvested = new BasicAttribute(NODE_LAST_HARVESTED, DateTimeMarshaller.serializeDateToUTC(lastDateNodeHarvested));
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, d1NodeLastHarvested)};
            ctx.modifyAttributes(dnNodeIdentifier, mods);
            log.debug("Updated entry: " + dnNodeIdentifier);
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem updating lastHarvested for node " + nodeIdentifier, e2);
            throw new ServiceFailure("4801", "Could not update account: " + e2.getMessage());
        }
    }

    protected void setLogLastAggregated(DirContext ctx, NodeReference nodeIdentifier, Date logAggregationDate) throws ServiceFailure {
        try {
            String dnNodeIdentifier = this.buildNodeDN(nodeIdentifier);
            String strLogLastAggregated = DateTimeMarshaller.serializeDateToUTC(logAggregationDate);
            BasicAttribute d1NodeLogLastAggregated = new BasicAttribute(LOG_LAST_AGGREGATED, strLogLastAggregated);
            ModificationItem[] mods = new ModificationItem[]{this.getLogLastAggregated(ctx, nodeIdentifier) == null ? new ModificationItem(1, d1NodeLogLastAggregated) : new ModificationItem(2, d1NodeLogLastAggregated)};
            ctx.modifyAttributes(dnNodeIdentifier, mods);
            log.debug("set LogLastAggregated: " + dnNodeIdentifier + " to " + strLogLastAggregated);
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem setting LogLastAggregated " + nodeIdentifier, e2);
            throw new ServiceFailure("4801", "Could not approve node: " + nodeIdentifier + " " + e2.getMessage());
        }
    }

    protected void setNodeApproved(DirContext ctx, NodeReference nodeIdentifier, Boolean approved) throws ServiceFailure {
        try {
            String dnNodeIdentifier = this.buildNodeDN(nodeIdentifier);
            BasicAttribute d1NodeApproval = new BasicAttribute(NODE_APPROVED, Boolean.toString(approved).toUpperCase());
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, d1NodeApproval)};
            ctx.modifyAttributes(dnNodeIdentifier, mods);
            log.debug("Approved Node: " + dnNodeIdentifier);
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem approving node " + nodeIdentifier, e2);
            throw new ServiceFailure("4801", "Could not approve node: " + nodeIdentifier + " " + e2.getMessage());
        }
    }

    protected void createNode(DirContext ctx, Node node) throws NotImplemented, ServiceFailure, InvalidRequest, NotFound {
        String dnNodeIdentifier = this.buildNodeDN(node.getIdentifier());
        try {
            Attributes nodeAttributes = this.mapNodeAttributes(node);
            ctx.createSubcontext(dnNodeIdentifier, nodeAttributes);
            log.debug("Added Node entry " + dnNodeIdentifier);
            if (node.getServices() != null && node.getServices().sizeServiceList() > 0) {
                for (Service service : node.getServices().getServiceList()) {
                    String serviceDN = nodeServicesAccess.buildNodeServiceDN(node.getIdentifier(), service);
                    Attributes serviceAttributes = nodeServicesAccess.mapNodeServiceAttributes(node, service);
                    ctx.createSubcontext(serviceDN, serviceAttributes);
                    log.debug("Added Node Service entry " + serviceDN);
                    if (service.getRestrictionList() == null || service.getRestrictionList().size() <= 0) continue;
                    for (ServiceMethodRestriction restriction : service.getRestrictionList()) {
                        String serviceMethodRestrictionDN = serviceMethodRestrictionsAccess.buildServiceMethodRestrictionDN(node.getIdentifier(), service, restriction);
                        Attributes serviceMethodRestrictionAttributes = serviceMethodRestrictionsAccess.mapServiceMethodRestrictionAttributes(node, service, restriction);
                        ctx.createSubcontext(serviceMethodRestrictionDN, serviceMethodRestrictionAttributes);
                        log.debug("Added Service Method Restriction entry " + serviceMethodRestrictionDN);
                    }
                }
            }
            if (node.getPropertyList() != null && node.getPropertyList().size() > 0) {
                for (Property property : node.getPropertyList()) {
                    String propertyDN = nodePropertyAccess.buildNodePropertyDN(node.getIdentifier(), property);
                    Attributes propertyAttributes = nodePropertyAccess.mapNodePropertyAttributes(node, property);
                    ctx.createSubcontext(propertyDN, propertyAttributes);
                    log.debug("Added Node Property entry " + propertyDN);
                }
            }
        }
        catch (NamingException ex1) {
            ex1.printStackTrace();
            throw new ServiceFailure("0", "Register failed due to LDAP communication failure");
        }
    }

    protected void updateNode(DirContext ctx, Node node) throws NotImplemented, ServiceFailure, InvalidRequest, NotFound {
        try {
            NodeReference nodeid = node.getIdentifier();
            log.info("Updating Node " + nodeid + " ...");
            HashMap<String, NamingEnumeration<?>> attributesMap = this.buildNodeAttributeMap(ctx, nodeid);
            List<ModificationItem> modificationItemList = this.mapNodeModificationItemList(attributesMap, node);
            for (ModificationItem item : modificationItemList) {
                Iterator<Service> id = item.getAttribute().getID();
                Object value = item.getAttribute().get();
                log.debug("updating node attribute: " + (String)((Object)id) + "=" + value);
            }
            ModificationItem[] modificationArray = new ModificationItem[modificationItemList.size()];
            modificationArray = modificationItemList.toArray(modificationArray);
            ctx.modifyAttributes(this.buildNodeDN(nodeid), modificationArray);
            log.debug("(a) modified using attributesMap");
            List<Service> existingNodeServices = nodeServicesAccess.getServiceList(ctx, nodeid.getValue());
            if (existingNodeServices != null && !existingNodeServices.isEmpty()) {
                for (Service removeService : existingNodeServices) {
                    String d1NodeServiceId = nodeServicesAccess.buildNodeServiceId(removeService);
                    List<ServiceMethodRestriction> serviceMethodRestrictionList = serviceMethodRestrictionsAccess.getServiceMethodRestrictionList(ctx, nodeid.getValue(), d1NodeServiceId);
                    if (serviceMethodRestrictionList != null && !serviceMethodRestrictionList.isEmpty()) {
                        for (ServiceMethodRestriction removeServiceMethodRestriction : serviceMethodRestrictionList) {
                            serviceMethodRestrictionsAccess.deleteServiceMethodRestriction(ctx, nodeid, removeService, removeServiceMethodRestriction);
                        }
                    }
                    nodeServicesAccess.deleteNodeService(ctx, nodeid, removeService);
                }
            }
            log.debug("(b) removed existing services and service restrictions");
            if (node.getServices() != null && node.getServices().sizeServiceList() > 0) {
                for (Service service : node.getServices().getServiceList()) {
                    String serviceDN = nodeServicesAccess.buildNodeServiceDN(node.getIdentifier(), service);
                    Attributes serviceAttributes = nodeServicesAccess.mapNodeServiceAttributes(node, service);
                    ctx.createSubcontext(serviceDN, serviceAttributes);
                    log.trace("updateNodeCapabilities Added Node Service entry " + serviceDN);
                    if (service.getRestrictionList() == null) continue;
                    for (ServiceMethodRestriction restriction : service.getRestrictionList()) {
                        String serviceMethodRestrictionDN = serviceMethodRestrictionsAccess.buildServiceMethodRestrictionDN(node.getIdentifier(), service, restriction);
                        Attributes serviceMethodRestrictionAttributes = serviceMethodRestrictionsAccess.mapServiceMethodRestrictionAttributes(node, service, restriction);
                        ctx.createSubcontext(serviceMethodRestrictionDN, serviceMethodRestrictionAttributes);
                        log.trace("updateNodeCapabilities Added Service Method Restriction entry " + serviceMethodRestrictionDN);
                    }
                }
            }
            log.debug("(c) added the updated services and service restrictions");
            List<Property> existingNodeProperties = nodePropertyAccess.getPropertyList(ctx, nodeid.getValue());
            if (existingNodeProperties != null && !existingNodeProperties.isEmpty()) {
                for (Property removeProperty : existingNodeProperties) {
                    if (removeProperty.getKey().startsWith("CN_")) continue;
                    nodePropertyAccess.deleteNodeProperty(ctx, nodeid, removeProperty);
                }
            }
            log.debug("(d) removed existing properties (except CN-controlled)");
            if (node.getPropertyList() != null && node.getPropertyList().size() > 0) {
                for (Property property : node.getPropertyList()) {
                    if (!property.getKey().startsWith("CN_")) {
                        String propertyDN = nodePropertyAccess.buildNodePropertyDN(node.getIdentifier(), property);
                        Attributes propertyAttributes = nodePropertyAccess.mapNodePropertyAttributes(node, property);
                        ctx.createSubcontext(propertyDN, propertyAttributes);
                        log.debug("...Added Node Property entry " + propertyDN);
                        continue;
                    }
                    log.debug("...Skipped Node Property entry with reserved 'CN_' prefix: " + property.getKey());
                }
            }
            log.debug("(e) added the updated properties");
            log.info("Updated NodeCapabilities Node: " + nodeid.getValue());
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("0", "updateNodeCapabilities failed due to LDAP communication failure:: " + ex.getClass().getSimpleName() + ":" + ex.getMessage() + ":" + ex.getExplanation());
        }
    }

    protected void setAggregateLogs(DirContext ctx, NodeReference nodeIdentifier, Boolean aggregateLogs) throws ServiceFailure {
        try {
            String dnNodeIdentifier = this.buildNodeDN(nodeIdentifier);
            BasicAttribute d1NodeAggregateLogs = new BasicAttribute(AGGREGATE_LOGS, Boolean.toString(aggregateLogs).toUpperCase());
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, d1NodeAggregateLogs)};
            ctx.modifyAttributes(dnNodeIdentifier, mods);
            log.debug("Set Aggregate Logs: " + dnNodeIdentifier);
        }
        catch (CommunicationException ex) {
            ex.printStackTrace();
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Problem Setting Aggregate Logs " + nodeIdentifier, e2);
            throw new ServiceFailure("4801", "Could not set Aggregate Logs: " + nodeIdentifier + " " + e2.getMessage());
        }
    }

    protected List<ModificationItem> calcModifications(String attributeName, HashMap<String, NamingEnumeration<?>> attributesMap, String newValue) throws NamingException {
        if (newValue == null) {
            newValue = "";
        }
        ArrayList<ModificationItem> modificationItemList = new ArrayList<ModificationItem>();
        if (attributesMap.containsKey(attributeName.toLowerCase())) {
            String currentValue = this.getEnumerationValueString(attributesMap.get(attributeName.toLowerCase()));
            if (!newValue.contentEquals(currentValue)) {
                BasicAttribute attr = new BasicAttribute(attributeName, newValue);
                modificationItemList.add(new ModificationItem(2, attr));
            }
        } else {
            BasicAttribute attr = new BasicAttribute(attributeName, newValue);
            modificationItemList.add(new ModificationItem(1, attr));
        }
        return modificationItemList;
    }

    protected List<ModificationItem> calcListModifications(String attributeName, HashMap<String, NamingEnumeration<?>> attributesMap, Collection<String> newValues) throws NamingException {
        if (newValues == null) {
            newValues = new ArrayList<String>();
        }
        ArrayList<ModificationItem> modificationItemList = new ArrayList<ModificationItem>();
        if (attributesMap.containsKey(attributeName.toLowerCase()) || !newValues.isEmpty()) {
            ArrayList<String> existingList = new ArrayList<String>();
            if (attributesMap.containsKey(attributeName.toLowerCase())) {
                NamingEnumeration<?> enumeration = attributesMap.get(attributeName.toLowerCase());
                while (enumeration.hasMoreElements()) {
                    existingList.add((String)enumeration.nextElement());
                }
            }
            ArrayList<String> additionList = new ArrayList<String>();
            additionList.addAll(newValues);
            if (!existingList.isEmpty() && !additionList.isEmpty()) {
                additionList.removeAll(existingList);
            }
            if (!additionList.isEmpty()) {
                BasicAttribute additions = new BasicAttribute(attributeName);
                for (String addition : additionList) {
                    additions.add(addition);
                }
                modificationItemList.add(new ModificationItem(1, additions));
            }
            ArrayList<String> removalList = new ArrayList<String>();
            removalList.addAll(existingList);
            if (!newValues.isEmpty() && !removalList.isEmpty()) {
                removalList.removeAll(newValues);
            }
            if (!removalList.isEmpty()) {
                BasicAttribute removals = new BasicAttribute(attributeName);
                for (String removal : removalList) {
                    removals.add(removal);
                }
                modificationItemList.add(new ModificationItem(3, removals));
            }
        }
        return modificationItemList;
    }

    protected List<ModificationItem> calcSubjectListModifications(String attributeName, HashMap<String, NamingEnumeration<?>> attributesMap, List<Subject> newValues) throws NamingException {
        if (newValues == null) {
            newValues = new ArrayList<Subject>();
        }
        ArrayList<ModificationItem> modificationItemList = new ArrayList<ModificationItem>();
        if (attributesMap.containsKey(attributeName.toLowerCase()) || !newValues.isEmpty()) {
            ArrayList<Subject> existingList = new ArrayList<Subject>();
            if (attributesMap.containsKey(attributeName.toLowerCase())) {
                NamingEnumeration<?> enumeration = attributesMap.get(attributeName.toLowerCase());
                while (enumeration.hasMoreElements()) {
                    Subject s = new Subject();
                    s.setValue((String)enumeration.nextElement());
                    existingList.add(s);
                }
            }
            ArrayList<Subject> additionList = new ArrayList<Subject>();
            additionList.addAll(newValues);
            if (!existingList.isEmpty() && !additionList.isEmpty()) {
                additionList.removeAll(existingList);
            }
            if (!additionList.isEmpty()) {
                BasicAttribute additions = new BasicAttribute(attributeName);
                for (Subject addition : additionList) {
                    additions.add(addition.getValue());
                }
                modificationItemList.add(new ModificationItem(1, additions));
            }
            ArrayList<Subject> removalList = new ArrayList<Subject>();
            removalList.addAll(existingList);
            if (!newValues.isEmpty() && !removalList.isEmpty()) {
                removalList.removeAll(newValues);
            }
            if (!removalList.isEmpty()) {
                BasicAttribute removals = new BasicAttribute(attributeName);
                for (Subject removal : removalList) {
                    removals.add(removal.getValue());
                }
                modificationItemList.add(new ModificationItem(3, removals));
            }
        }
        return modificationItemList;
    }
}

