/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v2.Node;
import org.dataone.service.util.DateTimeMarshaller;

public class NodeServicesAccess
extends LDAPService {
    public static Log log = LogFactory.getLog(NodeServicesAccess.class);
    public static final String OBJECT_CLASS_ID = "d1NodeService";
    public static final String NODE_SERVICE_ID = "d1NodeServiceId";
    public static final String NODE_SERVICE_NAME = "d1NodeServiceName";
    public static final String NODE_SERVICE_VERSION = "d1NodeServiceVersion";
    public static final String NODE_SERVICE_AVAILABLE = "d1NodeServiceAvailable";

    public NodeServicesAccess() {
        this.setBase(Settings.getConfiguration().getString("nodeRegistry.ldap.base"));
    }

    protected String buildNodeServiceDN(NodeReference nodeReference, Service service) {
        String d1NodeServiceId = this.buildNodeServiceId(service);
        String serviceDN = "d1NodeServiceId=" + d1NodeServiceId + ",cn=" + nodeReference.getValue() + ",dc=dataone,dc=org";
        return serviceDN;
    }

    protected String buildNodeServiceId(Service service) {
        return service.getName() + "-" + service.getVersion();
    }

    protected Boolean deleteNodeService(DirContext ctx, NodeReference nodeReference, Service service) {
        return super.removeEntry(ctx, this.buildNodeServiceDN(nodeReference, service));
    }

    protected List<Service> getServiceList(DirContext ctx, String nodeIdentifier) throws ServiceFailure {
        ArrayList<Service> allServices = new ArrayList<Service>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), String.format("(&(objectClass=%s)(%s=%s))", OBJECT_CLASS_ID, "d1NodeId", nodeIdentifier), ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                HashMap<String, String> attributesMap = new HashMap<String, String>();
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID().toLowerCase();
                    String attributeValue = (String)attribute.get();
                    attributesMap.put(attributeName, attributeValue);
                }
                allServices.add(this.mapService(attributesMap));
            }
        }
        catch (CommunicationException ex) {
            log.error("LDAP Service is unresponsive " + nodeIdentifier, ex);
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            System.err.print("[" + DateTimeMarshaller.serializeDateToUTC(new Date()) + "]  NodeId: " + nodeIdentifier + " ");
            e2.printStackTrace();
            log.error("Problem search NodesServices for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return allServices;
    }

    protected Attributes mapNodeServiceAttributes(Node node, Service service) {
        BasicAttributes serviceAttributes = new BasicAttributes(true);
        String nodeServiceId = this.buildNodeServiceId(service);
        serviceAttributes.put(new BasicAttribute("objectclass", OBJECT_CLASS_ID));
        serviceAttributes.put(new BasicAttribute(NODE_SERVICE_ID, nodeServiceId));
        serviceAttributes.put(new BasicAttribute("d1NodeId", node.getIdentifier().getValue()));
        serviceAttributes.put(new BasicAttribute(NODE_SERVICE_NAME, service.getName()));
        serviceAttributes.put(new BasicAttribute(NODE_SERVICE_VERSION, service.getVersion()));
        serviceAttributes.put(new BasicAttribute(NODE_SERVICE_AVAILABLE, Boolean.toString(service.getAvailable()).toUpperCase()));
        return serviceAttributes;
    }

    private Service mapService(HashMap<String, String> attributesMap) {
        Service service = new Service();
        service.setName(attributesMap.get(NODE_SERVICE_NAME.toLowerCase()));
        service.setVersion(attributesMap.get(NODE_SERVICE_VERSION.toLowerCase()));
        service.setAvailable(Boolean.valueOf(attributesMap.get(NODE_SERVICE_AVAILABLE.toLowerCase())));
        return service;
    }
}

