/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.rdfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;

public class RDFaORESerialiser
implements ORESerialiser {
    public ResourceMapDocument serialise(ResourceMap rem) throws ORESerialiserException {
        try {
            ORESerialiser rdfxmlSerialiser = ORESerialiserFactory.getInstance("RDF/XML");
            ResourceMapDocument rmd = rdfxmlSerialiser.serialise(rem);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            FileReader reader = new FileReader("/home/richard/workspace/dspace-trunk/foresite/src/main/resources/rdfxml2rdfa.xsl");
            StreamSource xslt = new StreamSource(reader);
            Transformer transformer = tFactory.newTransformer(xslt);
            String serialisation = rmd.getSerialisation();
            if (!serialisation.startsWith("<?xml")) {
                serialisation = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + serialisation;
            }
            StreamSource rdfxml = new StreamSource(new ByteArrayInputStream(serialisation.getBytes()));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            transformer.transform(rdfxml, result);
            String baseRDFa = baos.toString();
            String rx = ">[^<]+</a>";
            Pattern pattern = Pattern.compile(rx);
            Matcher matcher = pattern.matcher(baseRDFa);
            String preppedRDFa = matcher.replaceAll("></a>");
            int xmlHead = preppedRDFa.indexOf("?>");
            preppedRDFa = preppedRDFa.substring(xmlHead + 2);
            rmd.setSerialisation(preppedRDFa);
            return rmd;
        }
        catch (TransformerConfigurationException e2) {
            throw new ORESerialiserException(e2);
        }
        catch (TransformerException e3) {
            throw new ORESerialiserException(e3);
        }
        catch (FileNotFoundException e4) {
            throw new ORESerialiserException(e4);
        }
    }

    public ResourceMapDocument serialiseRaw(ResourceMap rem) throws ORESerialiserException {
        return null;
    }

    public void configure(Properties properties) {
    }
}

