/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private String user;
    private String pass;
    private static final Logger log = LoggerFactory.getLogger(DatasourceConnectionProvider.class);

    public DataSource getDataSource() {
        return this.ds;
    }

    public void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    public void configure(Properties props) throws HibernateException {
        String jndiName = props.getProperty("hibernate.connection.datasource");
        if (jndiName == null) {
            String msg = "datasource JNDI name was not specified by property hibernate.connection.datasource";
            log.error(msg);
            throw new HibernateException(msg);
        }
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        try {
            this.ds = (DataSource)NamingHelper.getInitialContext(props).lookup(jndiName);
        }
        catch (Exception e2) {
            log.error("Could not find datasource: " + jndiName, e2);
            throw new HibernateException("Could not find datasource", e2);
        }
        if (this.ds == null) {
            throw new HibernateException("Could not find datasource: " + jndiName);
        }
        log.info("Using datasource: " + jndiName);
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.ds.getConnection(this.user, this.pass);
        }
        return this.ds.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void close() {
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

