/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanAssertionPredicate
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<Boolean> expression;
    private final Boolean assertedValue;

    public BooleanAssertionPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<Boolean> expression, Boolean assertedValue) {
        super(criteriaBuilder);
        this.expression = expression;
        this.assertedValue = assertedValue;
    }

    public Expression<Boolean> getExpression() {
        return this.expression;
    }

    public Boolean getAssertedValue() {
        return this.assertedValue;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.expression, registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        String operator = this.isNegated() ? " <> " : " = ";
        String assertionLiteral = this.assertedValue != false ? "true" : "false";
        return ((Renderable)((Object)this.expression)).render(renderingContext) + operator + assertionLiteral;
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

