/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType
implements EnhancedUserType,
ParameterizedType,
Serializable {
    private static final boolean IS_VALUE_TRACING_ENABLED = LoggerFactory.getLogger(StringHelper.qualifier(Type.class.getName())).isTraceEnabled();
    private transient Logger log;
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    private Class<? extends Enum> enumClass;
    private transient Object[] enumValues;
    private int sqlType = 4;

    private Logger log() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(this.getClass());
        }
        return this.log;
    }

    @Override
    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    @Override
    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Returning null as column {}", (Object)names[0]);
            }
            return null;
        }
        if (object instanceof Number) {
            this.initEnumValues();
            int ordinal = ((Number)object).intValue();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Returning '{}' as column {}", (Object)ordinal, (Object)names[0]);
            }
            return this.enumValues[ordinal];
        }
        String name = (String)object;
        if (IS_VALUE_TRACING_ENABLED) {
            this.log().debug("Returning '{}' as column {}", (Object)name, (Object)names[0]);
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Binding null to parameter: {}", (Object)index);
            }
            st.setNull(index, this.sqlType);
        } else {
            boolean isOrdinal = this.isOrdinal(this.sqlType);
            if (isOrdinal) {
                int ordinal = ((Enum)value).ordinal();
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().debug("Binding '{}' to parameter: {}", (Object)ordinal, (Object)index);
                }
                st.setObject(index, (Object)ordinal, this.sqlType);
            } else {
                String enumString = ((Enum)value).name();
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().debug("Binding '{}' to parameter: {}", (Object)enumString, (Object)index);
                }
                st.setObject(index, (Object)enumString, this.sqlType);
            }
        }
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", exception);
        }
        String type = parameters.getProperty(TYPE);
        if (type != null) {
            this.sqlType = Integer.decode(type);
        }
    }

    private void initEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.enumClass.getEnumConstants();
            if (this.enumValues == null) {
                throw new NullPointerException("Failed to init enumValues");
            }
        }
    }

    @Override
    public String objectToSQLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return '\'' + ((Enum)value).name() + '\'';
    }

    @Override
    public String toXMLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return ((Enum)value).name();
    }

    @Override
    public Object fromXMLString(String xmlValue) {
        try {
            int ordinal = Integer.parseInt(xmlValue);
            this.initEnumValues();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            return this.enumValues[ordinal];
        }
        catch (NumberFormatException e2) {
            try {
                return Enum.valueOf(this.enumClass, xmlValue);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + xmlValue, iae);
            }
        }
    }
}

