/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class Specifications<T>
implements Specification<T> {
    private final Specification<T> spec;

    private Specifications(Specification<T> spec) {
        this.spec = spec;
    }

    public static <T> Specifications<T> where(Specification<T> spec) {
        return new Specifications<T>(spec);
    }

    public Specifications<T> and(final Specification<T> other) {
        return new Specifications<T>(new Specification<T>(){

            @Override
            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query2, CriteriaBuilder builder) {
                Predicate thisPredicate;
                Predicate otherPredicate = other == null ? null : other.toPredicate(root, query2, builder);
                Predicate predicate = thisPredicate = Specifications.this.spec == null ? null : Specifications.this.spec.toPredicate(root, query2, builder);
                return thisPredicate == null ? otherPredicate : (otherPredicate == null ? thisPredicate : builder.and((Expression<Boolean>)thisPredicate, (Expression<Boolean>)otherPredicate));
            }
        });
    }

    public Specifications<T> or(final Specification<T> other) {
        return new Specifications<T>(new Specification<T>(){

            @Override
            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query2, CriteriaBuilder builder) {
                Predicate thisPredicate;
                Predicate otherPredicate = other == null ? null : other.toPredicate(root, query2, builder);
                Predicate predicate = thisPredicate = Specifications.this.spec == null ? null : Specifications.this.spec.toPredicate(root, query2, builder);
                return thisPredicate == null ? otherPredicate : (otherPredicate == null ? thisPredicate : builder.or((Expression<Boolean>)thisPredicate, (Expression<Boolean>)otherPredicate));
            }
        });
    }

    public static <T> Specifications<T> not(final Specification<T> spec) {
        return new Specifications<T>(new Specification<T>(){

            @Override
            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query2, CriteriaBuilder builder) {
                return spec == null ? null : builder.not(spec.toPredicate(root, query2, builder));
            }
        });
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query2, CriteriaBuilder builder) {
        return this.spec == null ? null : this.spec.toPredicate(root, query2, builder);
    }
}

