/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import javax.persistence.Entity;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultJpaEntityMetadata<T>
implements JpaEntityMetadata<T> {
    private final Class<T> domainType;

    public DefaultJpaEntityMetadata(Class<T> domainType) {
        Assert.notNull(domainType, "Domain type must not be null!");
        this.domainType = domainType;
    }

    @Override
    public Class<T> getJavaType() {
        return this.domainType;
    }

    @Override
    public String getEntityName() {
        Entity entity = this.domainType.getAnnotation(Entity.class);
        boolean hasName = null != entity && StringUtils.hasText(entity.name());
        return hasName ? entity.name() : this.domainType.getSimpleName();
    }
}

