/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.util.Assert;

public class SpELExpressionParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    private final SpELExpressionEvaluator evaluator;
    private final ParameterValueProvider<P> delegate;
    private final ConversionService conversionService;

    public SpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<P> delegate) {
        Assert.notNull(evaluator, "SpELExpressionEvaluator must not be null!");
        Assert.notNull(conversionService, "ConversionService must not be null!");
        Assert.notNull(delegate, "ParameterValueProvider delegate must not be null!");
        this.evaluator = evaluator;
        this.conversionService = conversionService;
        this.delegate = delegate;
    }

    @Override
    public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
        if (!parameter.hasSpelExpression()) {
            return this.delegate == null ? null : (T)this.delegate.getParameterValue(parameter);
        }
        Object object = this.evaluator.evaluate(parameter.getSpelExpression());
        return object == null ? null : (T)this.potentiallyConvertSpelValue(object, parameter);
    }

    protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, P> parameter) {
        return this.conversionService.convert(object, parameter.getRawType());
    }
}

