/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MergeStream
extends TupleStream
implements ExpressibleStream {
    private static final long serialVersionUID = 1L;
    private PushBackStream streamA;
    private PushBackStream streamB;
    private Comparator<Tuple> comp;

    public MergeStream(TupleStream streamA, TupleStream streamB, Comparator<Tuple> comp) {
        this.streamA = new PushBackStream(streamA);
        this.streamB = new PushBackStream(streamB);
        this.comp = comp;
    }

    public MergeStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, ExpressibleStream.class, TupleStream.class);
        StreamExpressionNamedParameter onExpression = factory.getNamedOperand(expression, "on");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (2 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two streams but found %d (must be PushBackStream types)", expression, streamExpressions.size()));
        }
        this.streamA = new PushBackStream(factory.constructStream(streamExpressions.get(0)));
        this.streamB = new PushBackStream(factory.constructStream(streamExpressions.get(1)));
        if (null == onExpression || !(onExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'on' parameter listing fields to merge on but didn't find one", expression));
        }
        this.comp = factory.constructComparator(((StreamExpressionValue)onExpression.getParameter()).getValue(), FieldComparator.class);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.streamA.toExpression(factory));
        expression.addParameter(this.streamB.toExpression(factory));
        if (!(this.comp instanceof ExpressibleComparator)) {
            throw new IOException("This MergeStream contains a non-expressible comparator - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", ((ExpressibleComparator)((Object)this.comp)).toExpression(factory)));
        return expression;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamA.setStreamContext(context);
        this.streamB.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.streamA);
        l.add(this.streamB);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.streamA.open();
        this.streamB.open();
    }

    @Override
    public void close() throws IOException {
        this.streamA.close();
        this.streamB.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple a = this.streamA.read();
        Tuple b = this.streamB.read();
        if (a.EOF && b.EOF) {
            return a;
        }
        if (a.EOF) {
            this.streamA.pushBack(a);
            return b;
        }
        if (b.EOF) {
            this.streamB.pushBack(b);
            return a;
        }
        int c = this.comp.compare(a, b);
        if (c < 0) {
            this.streamB.pushBack(b);
            return a;
        }
        this.streamA.pushBack(a);
        return b;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

