/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;

public abstract class ConnectionPoolProvider<T extends ConnectionPool>
extends HierarchicalConfigProvider<T> {
    protected String host;
    protected String driver;
    protected int port = -1;
    protected String schema;
    protected String database;
    protected boolean useSSL = false;
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String DRIVER = "driver";
    public static final String USE_SSL = "useSSL";
    public static final String DATABASE = "database";
    public static final String SCHEMA = "schema";

    protected ConnectionPoolProvider(String database, String schema, String host, int port, String driver, boolean useSSL) {
        this.database = database;
        this.host = host;
        this.driver = driver;
        this.port = port;
        this.schema = schema;
        this.useSSL = useSSL;
    }

    protected ConnectionPoolProvider(String database, String schema) {
        this.database = database;
        this.schema = schema;
    }

    protected String checkValue(String key, String defaultValue) {
        String x = this.getAttribute(key);
        if (x != null) {
            return x;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new MyConfigurationException("Error: no value specified for " + key);
    }

    protected int checkValue(String key, int defaultValue) {
        String x = this.getAttribute(key);
        if (x != null) {
            return Integer.parseInt(x);
        }
        if (defaultValue != -1) {
            return defaultValue;
        }
        throw new MyConfigurationException("Error: no value specified for " + key);
    }

    protected boolean checkValue(String key, boolean defaultValue) {
        String x = this.getAttribute(key);
        if (x != null) {
            return Boolean.parseBoolean(x);
        }
        return defaultValue;
    }

    protected String checkValue(String key) {
        String x = this.getAttribute(key);
        if (x == null) {
            throw new MyConfigurationException("Error: no value specified for " + key);
        }
        return x;
    }
}

