/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfigurationLayout
implements ConfigurationListener {
    private static final String CR = "\n";
    private static final String COMMENT_PREFIX = "# ";
    private PropertiesConfiguration configuration;
    private Map layoutData;
    private String headerComment;
    private String globalSeparator;
    private String lineSeparator;
    private int loadCounter;
    private boolean forceSingleLine;

    public PropertiesConfigurationLayout(PropertiesConfiguration config) {
        this(config, null);
    }

    public PropertiesConfigurationLayout(PropertiesConfiguration config, PropertiesConfigurationLayout c) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        this.configuration = config;
        this.layoutData = new LinkedMap();
        config.addConfigurationListener(this);
        if (c != null) {
            this.copyFrom(c);
        }
    }

    public PropertiesConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCanonicalComment(String key, boolean commentChar) {
        String comment = this.getComment(key);
        if (comment == null) {
            return null;
        }
        return PropertiesConfigurationLayout.trimComment(comment, commentChar);
    }

    public String getComment(String key) {
        return this.fetchLayoutData(key).getComment();
    }

    public void setComment(String key, String comment) {
        this.fetchLayoutData(key).setComment(comment);
    }

    public int getBlancLinesBefore(String key) {
        return this.fetchLayoutData(key).getBlancLines();
    }

    public void setBlancLinesBefore(String key, int number) {
        this.fetchLayoutData(key).setBlancLines(number);
    }

    public String getCanonicalHeaderComment(boolean commentChar) {
        return this.getHeaderComment() == null ? null : PropertiesConfigurationLayout.trimComment(this.getHeaderComment(), commentChar);
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(String comment) {
        this.headerComment = comment;
    }

    public boolean isSingleLine(String key) {
        return this.fetchLayoutData(key).isSingleLine();
    }

    public void setSingleLine(String key, boolean f) {
        this.fetchLayoutData(key).setSingleLine(f);
    }

    public boolean isForceSingleLine() {
        return this.forceSingleLine;
    }

    public void setForceSingleLine(boolean f) {
        this.forceSingleLine = f;
    }

    public String getSeparator(String key) {
        return this.fetchLayoutData(key).getSeparator();
    }

    public void setSeparator(String key, String sep) {
        this.fetchLayoutData(key).setSeparator(sep);
    }

    public String getGlobalSeparator() {
        return this.globalSeparator;
    }

    public void setGlobalSeparator(String globalSeparator) {
        this.globalSeparator = globalSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public Set getKeys() {
        return this.layoutData.keySet();
    }

    public void load(Reader in) throws ConfigurationException {
        if (++this.loadCounter == 1) {
            this.getConfiguration().removeConfigurationListener(this);
        }
        PropertiesConfiguration.PropertiesReader reader = this.getConfiguration().getIOFactory().createPropertiesReader(in, this.getConfiguration().getListDelimiter());
        try {
            while (reader.nextProperty()) {
                if (!this.getConfiguration().propertyLoaded(reader.getPropertyName(), reader.getPropertyValue())) continue;
                boolean contained = this.layoutData.containsKey(reader.getPropertyName());
                int blancLines = 0;
                int idx = this.checkHeaderComment(reader.getCommentLines());
                while (idx < reader.getCommentLines().size() && ((String)reader.getCommentLines().get(idx)).length() < 1) {
                    ++idx;
                    ++blancLines;
                }
                String comment = this.extractComment(reader.getCommentLines(), idx, reader.getCommentLines().size() - 1);
                PropertyLayoutData data = this.fetchLayoutData(reader.getPropertyName());
                if (contained) {
                    data.addComment(comment);
                    data.setSingleLine(false);
                    continue;
                }
                data.setComment(comment);
                data.setBlancLines(blancLines);
                data.setSeparator(reader.getPropertySeparator());
            }
        }
        catch (IOException ioex) {
            throw new ConfigurationException(ioex);
        }
        finally {
            if (--this.loadCounter == 0) {
                this.getConfiguration().addConfigurationListener(this);
            }
        }
    }

    public void save(Writer out) throws ConfigurationException {
        try {
            char delimiter = this.getConfiguration().isDelimiterParsingDisabled() ? (char)'\u0000' : this.getConfiguration().getListDelimiter();
            PropertiesConfiguration.PropertiesWriter writer = this.getConfiguration().getIOFactory().createPropertiesWriter(out, delimiter);
            writer.setGlobalSeparator(this.getGlobalSeparator());
            if (this.getLineSeparator() != null) {
                writer.setLineSeparator(this.getLineSeparator());
            }
            if (this.headerComment != null) {
                PropertiesConfigurationLayout.writeComment(writer, this.getCanonicalHeaderComment(true));
                writer.writeln(null);
            }
            Iterator it = this.layoutData.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!this.getConfiguration().containsKey(key)) continue;
                for (int i = 0; i < this.getBlancLinesBefore(key); ++i) {
                    writer.writeln(null);
                }
                PropertiesConfigurationLayout.writeComment(writer, this.getCanonicalComment(key, true));
                boolean singleLine = (this.isForceSingleLine() || this.isSingleLine(key)) && !this.getConfiguration().isDelimiterParsingDisabled();
                writer.setCurrentSeparator(this.getSeparator(key));
                writer.writeProperty(key, this.getConfiguration().getProperty(key), singleLine);
            }
            writer.flush();
        }
        catch (IOException ioex) {
            throw new ConfigurationException(ioex);
        }
    }

    public void configurationChanged(ConfigurationEvent event) {
        if (event.isBeforeUpdate()) {
            if (20 == event.getType()) {
                this.clear();
            }
        } else {
            switch (event.getType()) {
                case 1: {
                    boolean contained = this.layoutData.containsKey(event.getPropertyName());
                    PropertyLayoutData data = this.fetchLayoutData(event.getPropertyName());
                    data.setSingleLine(!contained);
                    break;
                }
                case 2: {
                    this.layoutData.remove(event.getPropertyName());
                    break;
                }
                case 4: {
                    this.clear();
                    break;
                }
                case 3: {
                    this.fetchLayoutData(event.getPropertyName());
                }
            }
        }
    }

    private PropertyLayoutData fetchLayoutData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property key must not be null!");
        }
        PropertyLayoutData data = (PropertyLayoutData)this.layoutData.get(key);
        if (data == null) {
            data = new PropertyLayoutData();
            data.setSingleLine(true);
            this.layoutData.put(key, data);
        }
        return data;
    }

    private void clear() {
        this.layoutData.clear();
        this.setHeaderComment(null);
    }

    static boolean isCommentLine(String line) {
        return PropertiesConfiguration.isCommentLine(line);
    }

    static String trimComment(String s, boolean comment) {
        int pos;
        StringBuffer buf = new StringBuffer(s.length());
        int lastPos = 0;
        do {
            if ((pos = s.indexOf(CR, lastPos)) < 0) continue;
            String line = s.substring(lastPos, pos);
            buf.append(PropertiesConfigurationLayout.stripCommentChar(line, comment)).append(CR);
            lastPos = pos + CR.length();
        } while (pos >= 0);
        if (lastPos < s.length()) {
            buf.append(PropertiesConfigurationLayout.stripCommentChar(s.substring(lastPos), comment));
        }
        return buf.toString();
    }

    static String stripCommentChar(String s, boolean comment) {
        if (s.length() < 1 || PropertiesConfigurationLayout.isCommentLine(s) == comment) {
            return s;
        }
        if (!comment) {
            int pos = 0;
            while ("#!".indexOf(s.charAt(pos)) < 0) {
                ++pos;
            }
            ++pos;
            while (pos < s.length() && Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            return pos < s.length() ? s.substring(pos) : "";
        }
        return COMMENT_PREFIX + s;
    }

    private String extractComment(List commentLines, int from, int to) {
        if (to < from) {
            return null;
        }
        StringBuffer buf = new StringBuffer((String)commentLines.get(from));
        for (int i = from + 1; i <= to; ++i) {
            buf.append(CR);
            buf.append(commentLines.get(i));
        }
        return buf.toString();
    }

    private int checkHeaderComment(List commentLines) {
        if (this.loadCounter == 1 && this.getHeaderComment() == null && this.layoutData.isEmpty()) {
            int index;
            for (index = commentLines.size() - 1; index >= 0 && ((String)commentLines.get(index)).length() > 0; --index) {
            }
            this.setHeaderComment(this.extractComment(commentLines, 0, index - 1));
            return index + 1;
        }
        return 0;
    }

    private void copyFrom(PropertiesConfigurationLayout c) {
        Iterator it = c.getKeys().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            PropertyLayoutData data = (PropertyLayoutData)c.layoutData.get(key);
            this.layoutData.put(key, data.clone());
        }
    }

    private static void writeComment(PropertiesConfiguration.PropertiesWriter writer, String comment) throws IOException {
        if (comment != null) {
            writer.writeln(StringUtils.replace((String)comment, (String)CR, (String)writer.getLineSeparator()));
        }
    }

    static class PropertyLayoutData
    implements Cloneable {
        private StringBuffer comment;
        private String separator = " = ";
        private int blancLines;
        private boolean singleLine = true;

        public int getBlancLines() {
            return this.blancLines;
        }

        public void setBlancLines(int blancLines) {
            this.blancLines = blancLines;
        }

        public boolean isSingleLine() {
            return this.singleLine;
        }

        public void setSingleLine(boolean singleLine) {
            this.singleLine = singleLine;
        }

        public void addComment(String s) {
            if (s != null) {
                if (this.comment == null) {
                    this.comment = new StringBuffer(s);
                } else {
                    this.comment.append(PropertiesConfigurationLayout.CR).append(s);
                }
            }
        }

        public void setComment(String s) {
            this.comment = s == null ? null : new StringBuffer(s);
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.toString();
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public Object clone() {
            try {
                PropertyLayoutData copy = (PropertyLayoutData)super.clone();
                if (this.comment != null) {
                    copy.comment = new StringBuffer(this.getComment());
                }
                return copy;
            }
            catch (CloneNotSupportedException cnex) {
                throw new ConfigurationRuntimeException(cnex);
            }
        }
    }
}

