/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.AccessUtil;
import org.dataone.service.types.v1.util.AuthUtils;

public class AccessPolicyEditor
implements Cloneable {
    private AccessPolicy policy;

    public AccessPolicyEditor(AccessPolicy policy) {
        this.policy = policy == null ? new AccessPolicy() : policy;
    }

    public AccessPolicy getAccessPolicy() {
        return this.policy;
    }

    public void addAccess(Subject[] subjects, Permission permission) {
        AccessRule newRule = null;
        for (Subject s : subjects) {
            Set perms = (Set)AccessUtil.getPermissionMap((AccessPolicy)this.policy).get(s);
            if (perms == null) {
                if (newRule == null) {
                    newRule = new AccessRule();
                    newRule.addPermission(permission);
                }
                newRule.addSubject(s);
                continue;
            }
            if (AuthUtils.comparePermissions((Permission)permission, (Collection)perms)) continue;
            this.removeAccess(new Subject[]{s});
            newRule.addSubject(s);
        }
        this.policy.addAllow(newRule);
    }

    public boolean removeAccess(Subject[] subjects) {
        List<Subject> subjectList = Arrays.asList(subjects);
        boolean accessChanged = false;
        for (int i = 0; i < this.policy.sizeAllowList(); ++i) {
            AccessRule ar = this.policy.getAllow(i);
            if (!ar.getSubjectList().removeAll(subjectList)) continue;
            accessChanged = true;
            if (!ar.getSubjectList().isEmpty()) continue;
            this.policy.getAllowList().remove(i);
        }
        return accessChanged;
    }

    public void setAccess(Subject[] subjects, Permission permission) {
        this.removeAccess(subjects);
        AccessRule newRule = AccessUtil.createAccessRule((Subject[])subjects, (Permission[])new Permission[]{permission});
        this.policy.addAllow(newRule);
    }

    public void clearAccessPolicy() {
        this.policy.clearAllowList();
    }

    public AccessPolicy clone() {
        return AccessUtil.cloneAccessPolicy((AccessPolicy)this.policy);
    }

    public boolean hasAccess(Subject subject, Permission permission) {
        return AuthUtils.comparePermissions((Permission)permission, (Collection)((Collection)AccessUtil.getPermissionMap((AccessPolicy)this.policy).get(subject)));
    }

    public void setPublicAccess() {
        Subject publick = new Subject();
        publick.setValue("public");
        if (!this.hasAccess(publick, Permission.READ)) {
            AccessRule ar = new AccessRule();
            ar.addSubject(publick);
            ar.addPermission(Permission.READ);
            this.policy.addAllow(ar);
        }
    }
}

