/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.InvalidURIException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.UUID;

public class BasicIdentifier
implements Identifier {
    static final long serialVersionUID = 3405692655L;
    final URI id;
    static SecureRandom random = new SecureRandom();

    public String toString() {
        if (this.id == null) {
            return null;
        }
        return this.id.toString();
    }

    @Override
    public URI getUri() {
        return this.id;
    }

    public BasicIdentifier(URI id) {
        this.id = id;
    }

    public BasicIdentifier(String id) {
        try {
            this.id = URI.create(id);
        }
        catch (Throwable t) {
            throw new InvalidURIException("Error parsing URI \"" + id + "\"", t);
        }
    }

    public static Identifier newID(String id) {
        if (id == null) {
            return null;
        }
        return new BasicIdentifier(id);
    }

    public static Identifier newID(URI uri) {
        if (uri == null) {
            return null;
        }
        return new BasicIdentifier(uri);
    }

    public static Identifier randomID() {
        return BasicIdentifier.newID("urn:id:" + UUID.randomUUID());
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof BasicIdentifier) {
            BasicIdentifier x = (BasicIdentifier)obj;
            if (this.getUri() == null) {
                if (x.getUri() == null) {
                    rc = true;
                }
            } else {
                rc = this.getUri().equals(x.getUri());
            }
        }
        return rc;
    }

    public int hashCode() {
        if (this.id == null) {
            return 41;
        }
        return this.id.hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Identifier)) {
            throw new ClassCastException("The given object is of type " + o.getClass().getName() + " and cannot be compared to an Identifier");
        }
        if (this.id == null) {
            if (o.toString() == null) {
                return 0;
            }
            throw new NullPointerException("Error: Attempt to compare a null identifier to a non-null one \"" + o.toString() + "\"");
        }
        return this.toString().compareTo(o.toString());
    }
}

