/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.storage.StoreInitializer;
import java.io.File;

public class FSInitializer
extends StoreInitializer {
    File storeDirectory;
    File indexDirectory;

    public FSInitializer(File storeDirectory, File indexDirectory) {
        this.indexDirectory = indexDirectory;
        this.storeDirectory = storeDirectory;
    }

    public boolean createNew() {
        boolean isOk = true;
        if (this.storeDirectory == null) {
            throw new MyConfigurationException("Error: storage directory is null");
        }
        if (this.indexDirectory == null) {
            throw new MyConfigurationException("Error: index directory is null");
        }
        if (!this.storeDirectory.exists()) {
            isOk = isOk && this.storeDirectory.mkdirs();
        } else if (!this.storeDirectory.isDirectory()) {
            throw new MyConfigurationException("Error: The given directory \"" + this.storeDirectory.getAbsolutePath() + "\" is not a directory. Cannot be used as a file store.");
        }
        if (!this.indexDirectory.exists()) {
            isOk = isOk && this.indexDirectory.mkdirs();
        } else if (!this.indexDirectory.isDirectory()) {
            throw new MyConfigurationException("Error: The given directory \"" + this.storeDirectory.getAbsolutePath() + "\" is not a directory. Cannot be used as a file store.");
        }
        return isOk;
    }

    @Override
    public boolean isCreated() {
        if (this.storeDirectory == null || this.indexDirectory == null) {
            return false;
        }
        return this.storeDirectory.exists() && this.indexDirectory.exists();
    }

    @Override
    public boolean isInitialized() {
        if (!this.isCreated()) {
            return false;
        }
        return this.storeDirectory.list().length == 0 && this.indexDirectory.list().length == 0;
    }

    public boolean destroy() {
        boolean isOk;
        if (this.isCreated()) {
            this.clearEntries();
        }
        isOk = (isOk = true) && this.indexDirectory.delete();
        isOk = isOk && this.storeDirectory.delete();
        return isOk;
    }

    protected void clearEntries() {
        if (this.storeDirectory != null) {
            for (File f : this.storeDirectory.listFiles()) {
                f.delete();
            }
        }
        if (this.indexDirectory != null) {
            for (File f : this.indexDirectory.listFiles()) {
                f.delete();
            }
        }
    }

    public boolean init() {
        if (!this.isCreated()) {
            return false;
        }
        this.clearEntries();
        return true;
    }
}

