/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Blob {
    private LargeObject lo;

    public AbstractJdbc2Blob(PGConnection conn, int oid) throws SQLException {
        LargeObjectManager lom = conn.getLargeObjectAPI();
        this.lo = lom.open(oid);
    }

    public long length() throws SQLException {
        return this.lo.size();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.lo.getInputStream();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.lo.seek((int)(pos - 1L), 0);
        return this.lo.read(length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "position(byte[],long)");
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }
}

