/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.List;

public class UpdateCompare {
    public static boolean isomorphic(UpdateRequest req1, UpdateRequest req2) {
        if (req1 == req2) {
            return true;
        }
        if (!req1.samePrologue(req2)) {
            return false;
        }
        List<Update> updates1 = req1.getOperations();
        List<Update> updates2 = req2.getOperations();
        if (updates1.size() != updates2.size()) {
            return false;
        }
        NodeIsomorphismMap isomap = new NodeIsomorphismMap();
        for (int i = 0; i < updates1.size(); ++i) {
            Update upd2;
            Update upd1 = updates1.get(i);
            if (UpdateCompare.isomorphic(upd1, upd2 = updates2.get(i), isomap)) continue;
            return false;
        }
        return true;
    }

    public static boolean isomorphic(Update req1, Update req2) {
        return UpdateCompare.isomorphic(req1, req2, new NodeIsomorphismMap());
    }

    private static boolean isomorphic(Update upd1, Update upd2, NodeIsomorphismMap isomap) {
        return upd1.equalTo(upd2, isomap);
    }
}

