/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateRegistry;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.Locale;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;

public class AggCustom
extends AggregatorBase {
    private final String iri;

    public AggCustom(String iri2, ExprList exprs) {
        super("AGG", false, exprs);
        this.iri = iri2;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggCustom(this.iri, exprs);
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        if (!AggregateRegistry.isRegistered(this.iri)) {
            x.append(this.getName(), new Object[0]);
            x.append(" ", new Object[0]);
        }
        x.append("<", new Object[0]);
        x.append(this.iri, new Object[0]);
        x.append(">", new Object[0]);
        if (this.isDistinct) {
            x.append(" DISTINCT ", new Object[0]);
        }
        x.incIndent();
        x.append("(", new Object[0]);
        ExprUtils.fmtSPARQL((IndentedWriter)x, this.getExprList(), sCxt);
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public String toPrefixString() {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append("(", new Object[0]);
        x.append(this.getName().toLowerCase(Locale.ROOT), new Object[0]);
        x.append(" <", new Object[0]);
        x.append(this.iri, new Object[0]);
        x.append("> ", new Object[0]);
        x.incIndent();
        if (this.isDistinct) {
            x.append("distinct ", new Object[0]);
        }
        boolean first = true;
        for (Expr e2 : this.getExprList()) {
            if (!first) {
                x.append(" ", new Object[0]);
            }
            first = false;
            WriterExpr.output((IndentedWriter)x, e2, null);
            first = false;
        }
        x.decIndent();
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public Accumulator createAccumulator() {
        AccumulatorFactory f = AggregateRegistry.getAccumulatorFactory(this.iri);
        if (f == null) {
            throw new QueryExecException("Unregistered aggregate: " + this.iri);
        }
        return f.createAccumulator(this);
    }

    @Override
    public Node getValueEmpty() {
        return AggregateRegistry.getNoGroupValue(this.iri);
    }

    @Override
    public Expr getExpr() {
        return null;
    }

    public String getIRI() {
        return this.iri;
    }

    @Override
    public int hashCode() {
        if (!AggregateRegistry.isRegistered(this.iri)) {
            return this.asFunction().hashCode();
        }
        return 0x181 ^ this.getExprList().hashCode() ^ this.iri.hashCode();
    }

    private E_Function asFunction() {
        return new E_Function(this.iri, this.exprList);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!AggregateRegistry.isRegistered(this.iri)) {
            E_Function f1 = this.asFunction();
            if (other instanceof AggCustom) {
                other = ((AggCustom)other).asFunction();
            }
            return f1.equals(other);
        }
        if (!(other instanceof AggCustom)) {
            return false;
        }
        AggCustom agg = (AggCustom)other;
        return Lib.equal(this.iri, agg.iri) && this.isDistinct == agg.isDistinct && Lib.equal(this.getExprList(), agg.getExprList());
    }

    public static Accumulator createAccNull() {
        return new AccCustom();
    }

    private static class AccCustom
    implements Accumulator {
        private int nBindings = 0;

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.nBindings;
        }

        @Override
        public NodeValue getValue() {
            return null;
        }
    }
}

