/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;

public abstract class RepeatApplyIterator<T>
implements Iterator<T>,
Closeable {
    private Iterator<T> input;
    private boolean finished = false;
    private Iterator<T> currentStage = null;

    protected RepeatApplyIterator(Iterator<T> input) {
        this.input = input;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        while (true) {
            if (this.currentStage == null && this.input.hasNext()) {
                T nextItem = this.input.next();
                this.currentStage = this.makeNextStage(nextItem);
            }
            if (this.currentStage == null) {
                this.hasFinished();
                this.finished = true;
                return false;
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage = null;
        }
    }

    protected abstract Iterator<T> makeNextStage(T var1);

    protected void hasFinished() {
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
        }
        return this.currentStage.next();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        Iter.close(this.input);
    }
}

