/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum GlobberStrategy {
    ANYTHING{

        final Object compile(String glob) {
            return null;
        }

        final boolean match(Object globPattern, String filename) {
            return true;
        }
    }
    ,
    SUFFIX{

        final Object compile(String glob) {
            return glob.substring(1);
        }

        final boolean match(Object globPattern, String filename) {
            return filename.endsWith((String)globPattern);
        }
    }
    ,
    PREFIX{

        final Object compile(String glob) {
            return glob.substring(0, glob.length() - 1);
        }

        final boolean match(Object globPattern, String filename) {
            return 3.basename(filename).startsWith((String)globPattern);
        }
    }
    ,
    EXACT{

        final Object compile(String glob) {
            return glob;
        }

        final boolean match(Object globPattern, String filename) {
            return ((String)globPattern).equals(4.basename(filename));
        }
    }
    ,
    PATTERN{

        final Object compile(String glob) {
            return Pattern.compile(glob.replaceAll("[^*]+", "\\\\Q$0\\\\E").replaceAll("\\*+", ".*"));
        }

        final boolean match(Object globPattern, String filename) {
            return ((Pattern)globPattern).matcher(5.basename(filename)).matches();
        }
    };


    abstract Object compile(String var1);

    abstract boolean match(Object var1, String var2);

    static final String basename(String filename) {
        return filename.substring(1 + filename.lastIndexOf(47));
    }
}

